function dat = read3ColFile(in_file)
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Read in a TF ChIP-seq peak file with 3 columns format and converted into
% numeric representation. 
%
% Format: Chr#  txStart   txEnd
%
% yuanyuan.li@nih.gov 
% 1/23/2012
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Read in data 
%  - format: chr#   start_pos   end_pos
f_r=fopen(in_file);
aa = textscan(f_r, '%s %d %d');
fclose(f_r);

chro    = aa{1};
txStart = aa{2};
txEnd   = aa{3};

% Convert chr to num (chrX=23   and chrY=24)
chro_num=chr2num(chro);    
dat=[chro_num, txStart, txEnd];

end% end function
