function is_conRange = is_conRangeByPctNoFalsePos(dat_chr, ...
    bucket_points, thre)
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% For a given set of peak center points by cell line. 
%  - get percent of cell lines that contains given set of points. 
%  - there has to be >=2 replicates under the same region.
%  - if there is only 1 cell line, omit the cell line.
%  - return yes/no (1/0) for constitutive range or not. 
% Notes: 
%   - used peak middle points
%
% yuanyuan.li@nih.gov 
% 12/27/2012
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% initializition
is_conRange = 0; % return 1 if the bucket is constitutive, 0 otherwise
num_rep  = 0; % # replicates that re found under current bucket
num_cell = 0; % # cells that are found under current bucket
num_valid_cell = 0; % total # cells that are valid for consideration

% Only need unique ones for computational speed up
points = unique(bucket_points);

% For all points in a bucket:
%   1. If >=2 replicates under a cell line is found, count the cell
%   2. Add up # cells that satisfy 1
for i=1:numel(dat_chr)
    % if only 1 replicate under current cell, omit current cell.
    if numel(dat_chr{i}) == 1
        continue;
    end %end-if
    
    % update total # valid cells
    num_valid_cell = num_valid_cell + 1;
    % get # replicates found under current bucket
    num_rep = sum(cellfun(@(x) ~isempty(intersect(x,points)),dat_chr{i}));
    
    % if >=2 replicates from the same cell line are found, update # cells
    if num_rep >= 2
        num_cell = num_cell + 1;
    end%end-if
    
end%end-for each cellline

% If # cells found for a given bucket >= # valid cellline*threshold, 
% then it is constitutive
if ( num_cell >= num_valid_cell*thre );
    is_conRange = 1;
end

end %end-function