function [nn,rr,conClusterRange,numPtsInCluster,clusterMean,clusterVar] ...
    = get_kdtree_conRange(node, recNum, position,idxPar, nn, rr, ...
    conClusterRange, numPtsInCluster, clusterMean, clusterVar)
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Tree traversal (recursive call) 1D data only!
%   - traverse the 1d binary tree
%   - get tree layout (nn) for treeplot funciton to display
%   - get range and number of nodes in each level
% INPUT:  tree built from build_kdtree_conRange funciton
% OUTPUT: 
%   - nn (list of tree nodes, i.e., [0 1 2 2 1 5 5])
%   - rr (list of tree nodes ranges and #nodes in the bucket)
%       - FORMAT: start end (#nodes)
%   - conClusterRange (list of tree leaf ranges, i.e., [1 5; 8 10])
%   - numPtsInCluster (list of num of children in the range, i.e., [2; 3])
%       - FORMAT: start end (#nodes)
% note: nn & rr can be used to plot kdtree (plot_tree_a)
%
% yuanyuan.li@nih.gov
% 11/14/2011
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ----- initialize all variable -----
% Can only visualize data in 1D
if size(node.centroid,1) ~= 1
    disp('only works for 1 dimension');
    return
end

% If recNum is not specified, set it to 1
if exist('recNum','var') == 0
    recNum = 1;
end

if exist('idxPar','var') == 0
    idxPar = 0;
end

if exist('nn','var') == 0
    nn = [];
end

if exist('rr','var') == 0
    rr = {};
end

if exist('conClusterRange','var') == 0
    conClusterRange = [];
end

if exist('numPtsInCluster','var') == 0
    numPtsInCluster = [];
end

if exist('clusterMean','var') == 0
    clusterMean = [];
end

if exist('clusterVar','var') == 0
    clusterVar = [];
end


% ------ Get nodes information ----------------
idx   = length(nn);
leaf_idx = length(numPtsInCluster);

% First time, top level if position is not specified
if exist('position','var') == 0 
    position = 'top';
end


% Add spaces as number of recursion increase
printField=['%',num2str(recNum*1),'s'];
subTreeInfo=['range [',num2str(node.hyperrect),'] ',...
    'numpoints: ',num2str(node.numpoints)];


% The node is a leaf
if strcmp(node.type,'leaf')
    idx=idx+1;
    leaf_idx = leaf_idx+1;
    nn(idx)=idxPar;      
    rr{idx}=[num2str(node.hyperrect),' (',num2str(node.numpoints),')'];
    conClusterRange(leaf_idx,:) = node.hyperrect;
    numPtsInCluster(leaf_idx) = node.numpoints;
    clusterMean(leaf_idx) = node.centroid;
    clusterVar(leaf_idx) = node.cov;
    return;
end


% The node has children
if strcmp(node.type,'node') 
    if strcmp(position,'top') 
        nn(1)=0;
        rr{1}=[num2str(node.hyperrect),' (',num2str(node.numpoints),')'];
    elseif strcmp(position,'left') 
        idx=idx+1;
        nn(idx)=idxPar;
        rr{idx}=[num2str(node.hyperrect),' (',num2str(node.numpoints),')'];
    elseif strcmp(position,'right') 
        idx=idx+1;
        nn(idx)=idxPar;
        rr{idx}=[num2str(node.hyperrect),' (',num2str(node.numpoints),')'];
    end

    if strcmp(position,'top') 
        node.idxCur  = 0;
    else
        node.idxCur  = length(nn)-1;        
    end

    node.idxPar  = idxPar;
    idxPar       = node.idxCur+1;
    [nn,rr,conClusterRange,numPtsInCluster,clusterMean,clusterVar] =...
        get_kdtree_conRange(node.left,recNum+1,'left',idxPar, nn,rr,...
        conClusterRange, numPtsInCluster, clusterMean, clusterVar);
    
    [nn,rr,conClusterRange,numPtsInCluster,clusterMean,clusterVar] = ...
        get_kdtree_conRange(node.right,recNum+1,'right',idxPar,nn,rr,...
        conClusterRange, numPtsInCluster, clusterMean, clusterVar);
    
end

return

