function [con_modes_idx, con_modes_nCell] = get_conModesByPctNoFP(...
    tf_chr, cluster_pts, assoc, thre)
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% For a given set of peak center points by cell line. 
%  - omit cell line with 1 replicate. 
%  - >= 2 replicates can be found under a cell line.
%  - get percent of cell lines that contains given set of points. 
%  - if a mode contains peak centers that are constitutive, 
%  - then, declare it as consititutive mode.
% Notes: 
%   - used peak middle points
%
% yuanyuan.li@nih.gov 
% 12/27/2012
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
[mode_cnt modes_idx] = hist(assoc, unique(assoc) );
% # cells that are found their corresponding modes
num_cell  = zeros(1, max(modes_idx));
pct_cell  = zeros(1, max(modes_idx));

num_valid_cell = 0; % total # cells that are valid for consideration
num_rep  = 0; % # replicates that are found under current mode

% for each mode, get num cell lines contain any points of a given mode
for i = modes_idx
    % Get points within a mode
    points = unique(cluster_pts( assoc==i ));
    
    % For all points in a mode:
    %   1. If >=2 replicates under a cell line is found, count the cell
    %   2. Add up # cells that satisfy 1
    for ii=1:numel(tf_chr)
        
        % if only 1 replicate under current cell, omit current cell.
        if numel(tf_chr{ii}) == 1
            continue;
        end %end-if
    
        if i == 1 % only do it for the 1st mode, rest are the same
            % update total # valid cells
            num_valid_cell = num_valid_cell + 1;
        end
        
        % Get # cells that contains any points in the mode
        num_rep = sum( cellfun( @(x) ~isempty(intersect(x,points)), ...
            tf_chr{ii}) );
    
        % if >=2 replicates from the same cell line are found, 
        % update # cells
        if num_rep >= 2
            num_cell(i) = num_cell(i) + 1;
        end%end-if
    end%end-for each cellline

end% end for each mode

% Get mode idx that satisfy the given threshold
con_modes_idx = find( num_cell >= num_valid_cell*thre);
con_modes_nCell = num_cell(con_modes_idx);

end %end-function