%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Change chr to corresponding chr # 
%   - note chrX=23 and chY=24
%
% liy19@niehs.nih.gov 
% 6/6/2011
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [chro_num]=chr2num(chro)

chro_num = zeros(size(chro));
% Remove chr, number remains
%   let chrX=23   and chrY=24
for i=1:size(chro)
    chro_str = strrep(chro{i},'chr','');
    if( strcmp(chro_str,'X') == 1 )
        chro_str = '23';
    end

    if( strcmp(chro_str,'Y') == 1 )
        chro_str = '24';
    end
    
    if( strcmp(chro_str,'M') == 1 )
        continue;
    end
    
    if( length(chro_str) >= 6 )
        continue;
    end
    
    chro_num(i) = str2num(chro_str);    
    
end