function step3_getModeAssocFromKDEs(in_loc, tf, chr, bw, out_loc)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Get modes & associations from KDEs built from constitutive nodes
% of a given chr
%  - no false positive peaks or cell line with 1 replicate are considered
%  - used ChIP-seq centers
%  - used binary range tree to get constitutive nodes
%
% yuanyuan.li@nih.gov
% created : 03-27-2013
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
addpath(genpath('./'))

% Load existing KDEs from constitutive nodes
in_base = [in_loc,tf,'_KDE_bw',num2str(bw),'_chr',num2str(chr),'_cNode'];
in_name = dir([in_base, '*']);
[num_cNodes, ~] = size(in_name);

out_name = [out_loc,tf,'_KDE_bw',num2str(bw),'_chr',num2str(chr),'_cNode'];

disp(['- Step 3: getting bump info from constructed KDEs for ',tf,...
    ' chr', num2str(chr), ' bw', num2str(bw)]);

% For each constitutive terminal nodes, get modes & assoc from built KDE
for i = 1:num_cNodes
    
    % load KDE matrix
    kde_mat = [in_base, num2str(i), '.mat'];
    loadCmd =['load ', strrep( kde_mat, '.mat', '' )]; eval(loadCmd);
    
    % get KDE modes & associations
    [tf_modes tf_assoc] = modes(cNode_kde);
    
    % ---- save matrix to file ----
    kde_mat = [out_name, num2str(i),'_kde.mat'];
    saveCmd=['save  ',  kde_mat ,' cNode_kde']; eval(saveCmd);
    kde_modes_mat = [out_name, num2str(i),'_modes.mat'];
    saveCmd=['save  ',  kde_modes_mat ,' tf_modes']; eval(saveCmd);
    kde_assoc_mat = [out_name, num2str(i),'_assoc.mat'];
    saveCmd=['save  ',  kde_assoc_mat ,' tf_assoc']; eval(saveCmd);

end%end-for each cNode

disp('done');
end % end-function

