function step3_getConModeAssocFromKDE(in_tf, in_modes, tf, chr, bw, ...
    thre, out_loc)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Get constitutive modal regions from all modes gotten from the KDE built  
% (ChIP-seq centers) for a given TF
%
% Note:
%   - No false positive peaks or cells with 1 replicate are considered.
% 
% yuanyuan.li@nih.gov
% created : 03-27-2013
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
addpath(genpath('./'))

% Load existing chip-seq matrix
tf_mat=[in_tf,tf,'_peakCenterByCell_chr',num2str(chr),'.mat'];
loadCmd =['load ',strrep(tf_mat,'.mat','')];    eval(loadCmd);

% Load existing modes, assoc, & KDEs from constitutive clusters
mode_name=[in_modes,tf,'_KDE_bw',num2str(bw),'_chr',num2str(chr),'_cNode'];
modes_names = dir([mode_name, '*_modes.mat']);
[num_clusters, ~] = size(modes_names);

disp(['- Step 3: getting constitutive bumps for ',tf,' chr',...
    num2str(chr), ' bw', num2str(bw)]);

% initialize output loc & name
out_name=[out_loc,tf,'_KDE_bw',num2str(bw),'_chr',num2str(chr)];
% # constitutive modes found number each cluster (1 line per cluster)
fid_num_modes = fopen([out_name, '_numModes.txt'],'w');
num_con_modes = 0;
for i = 1:num_clusters
    %disp([' -- processing cluster ' num2str(i), ' of ' ...
    %    num2str(num_clusters), ' ...']);
    
    % load kde, get points from KDE for each constitutive cluster
    kde_mat = [mode_name, num2str(i), '_kde.mat'];
    loadCmd =['load ',strrep(kde_mat,'.mat','')]; eval(loadCmd);
    cluster_pts = getPoints(cNode_kde);
    
    % load modes & assoc for each cluster
    kde_modes_mat = [mode_name, num2str(i), '_modes.mat'];
    kde_assoc_mat = [mode_name, num2str(i), '_assoc.mat'];
    loadCmd =['load ',strrep(kde_modes_mat,'.mat','')]; eval(loadCmd);
    loadCmd =['load ',strrep(kde_assoc_mat,'.mat','')]; eval(loadCmd);

    % Get mode idx that are constitutive 
    %  - if all points in a given mode together appear in (all cells*thre)
    %  - then the mode is a constitutive mode
    [con_modes_idx, con_modes_nCell] = ...
        get_conModesByPctNoFP(tf_chr, cluster_pts, tf_assoc, thre);
    
    % Get # modes under current cluster. 
    [tmp, num_modes] = size(con_modes_idx);
    % Keep a running total of all clusters checked so far
    num_con_modes = num_con_modes + num_modes;
    
    % if found constitutive modes under current cluster, save info
    if isempty(con_modes_idx) == 0
        
        % get a vector of con modes locations, round nearest integers 
        con_modes_loc = round(tf_modes(con_modes_idx));
        
        % save idx, location & # cells of the constitutive modes
        fid = fopen([out_name, '_cNode', num2str(i), '_cBump.txt'],'w');
        for ii = 1:num_modes
            fprintf(fid,'%12d \t %12d \t %12d\n', ...
                con_modes_idx(ii), con_modes_loc(ii), con_modes_nCell(ii));
        end
        fclose(fid);

    end%end-if

    % Write # constitutive modes found under current cluster
    fprintf(fid_num_modes,'%d\n', num_modes);
    
end%end-for all clusters
fclose(fid_num_modes);

disp('done');
end % end-function
