function step2_constructKDEfromConNodes(in_tf,in_loc,tf,bw,chr,out_loc)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Construct KDE with a given bandwidth for each constitutive node.
%
% Note: 
% - Constitutive terminal nodes are given by the binary range tree (step 1)
% - No false positive peak centers or cell line with 1 replicate are 
%   considered
%
% yuanyuan.li@nih.gov
% created : 12-27-2012
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
addpath(genpath('./'))

% Load ctcf_chr_all
tf_all_mat = [in_tf, tf, '_allPeakCenter_chr', num2str(chr), '.mat'];
loadCmd =['load ',strrep(tf_all_mat,'.mat','')];  eval(loadCmd);

% Read in constitutive ctcf cluster range, count, mean and variance info
in_name=[in_loc,tf,'_tree_chr',num2str(chr),'_cNodes'];
tf_range = dlmread([in_name, '_ranges.txt']);
tf_count = dlmread([in_name, '_peaksCounts.txt']);

disp(['- Step 2: constructing KDE for each constitutive node ',tf,...
    ' chr',num2str(chr)]);

num_clusters = length(tf_count);
out_name = [out_loc, tf, '_KDE_bw', num2str(bw), '_chr', num2str(chr),...
    '_cNode'];
% Construct KDE with given bandwidth and save the .mat file
for i=1:num_clusters
    pts = double( tf_chr_all(tf_chr_all >= tf_range(i,1) & ...
        tf_chr_all <= tf_range(i,2))');

    % build KDE and get KDE plot
    cNode_kde = kde(pts, bw);
     
    % save the KDE into a mat file
    kde_mat = [out_name, num2str(i),'.mat'];
    saveCmd = ['save  ',  kde_mat ,' cNode_kde'];
    eval(saveCmd);
end

disp('done');
end % end-function
