function step1_getTreeConNode(in_loc, tf, chr, out_loc)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Get constitutive terminal nodes from the built tree by tree traversal. 
% The binary range tree is built based on constitutive criteria, 
% therefore, only leafs are being considered at the final layer buckets. 
%
% NOTE:
% - nodes & ranges can be used to plot the full tree
% - leaf_r & leaf_n are leaf buckets info only (That's all we need)
% - no false positive cell lines and cell lines with 1 replicate are
%   considered.
%
% yuanyuan.li@nih.gov
% created : 12-27-2012
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
addpath(genpath('./'))

% Save filtered KDE as mat file
kdtree_mat = [in_loc,tf,'_tree_chr',num2str(chr),'.mat'];
loadCmd=['load ',strrep(kdtree_mat,'.mat','')]; eval(loadCmd);

disp(['- Step 1: getting cNodes range for ',tf,' chr', num2str(chr)]);

% Get KD-trees constitutive clusters infomation from filtered points
[nodes, ranges, cluster_range, cluster_n_pts, cluster_mean, cluster_var]...
    = get_kdtree_conRange(tf_tree);


% Save constitutive tree nodes ranges & peaks counts
%   - one line per constitutive terminal node
out_name = [out_loc,tf,'_tree_chr',num2str(chr),'_cNodes'];

dlmwrite( [out_name, '_ranges.txt'], cluster_range, ...
    'precision', 12, 'delimiter', '\t');

fid = fopen([out_name, '_peaksCounts.txt'], 'w');
fprintf(fid,'%12d\n', cluster_n_pts);
fclose(fid);

disp('done');
end % end-function
