function tf_tree = step1_buildBinaryRangeTree(in_loc,tf,chr,thre,out_loc)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Build binary range tree from a given TF's peak centers for a given 
% chromosome. 
% 
% Note:
% - Grow tree until the cluster is not constitutive
% - There has to be >= 2 replicates fall under the same constitutive region 
%   for a given cell line
%
% yuanyuan.li@nih.gov
% created : 12-27-2012
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
addpath(genpath('./'))

% Read in filted data
tf_mat = [in_loc, tf, '_allPeakCenter_chr', num2str(chr), '.mat'];
loadCmd=['load ',strrep(tf_mat,'.mat','')];  eval(loadCmd);

tf_chr_mat = [in_loc, tf, '_peakCenterByCell_chr', num2str(chr), '.mat'];
loadCmd=['load ',strrep(tf_chr_mat,'.mat','')];  eval(loadCmd);

disp(['- Step 1: building binary range tree for ',tf,' chr',num2str(chr)]);

% Get binary range tree from filtered points
dat = double(tf_chr_all');
tf_tree = build_kdtree_conRange_noFalsePos(dat, tf_chr, thre);

% Save filtered KDE as mat file
tree_tf_mat=[out_loc,tf,'_tree_chr',num2str(chr),'.mat'];
saveCmd=['save  ',tree_tf_mat,' tf_tree'];  eval(saveCmd);

disp('done');
end % end-function

