function preprocess_getPeakCenterByCellline(in_loc,cell_nfo,tf,chr,out_loc)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Preprocessing step 1: pool replicates together by cell line and get peak 
% centers for a given chromosome.
%
% yuanyuan.li@nih.gov
% created : 12-27-2012
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
addpath(genpath('./'))

disp(['- Preprocessing: pool replicates together by cellline for TF ',...
    tf, ' chr', num2str(chr), ' (2-tier cell structure)...']);

% Read in a TF's chip-seq data & put replicates into their own cells, 
% next, pool same replicates in the same cellline together
tf_names = dir([in_loc, '*Peak']);
[tf_chr, tf_chr_all] = get_replicatesInCellByCelllines(in_loc, tf_names,...
    cell_nfo, tf, chr);
    

% Save data into .mat files
tf_mat     = [out_loc,tf,'_peakCenterByCell_chr',num2str(chr),'.mat'];
tf_all_mat = [out_loc,tf,'_allPeakCenter_chr',num2str(chr),'.mat'];
saveCmd=['save  ',  tf_mat ,' tf_chr'];
eval(saveCmd);
saveCmd=['save  ',  tf_all_mat ,' tf_chr_all'];
eval(saveCmd);

%Cell+TF 

disp('done');
end % end-function
