function postprocess_poolConBumpForAllChrTogether(in_loc,tf,bw,CHR,out_loc)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Pool all constitutive bumps gotten from KDEs built for all chromosomes
% together for a given TF. 
% 
% Note:
%   - KDE built using ChIP-seq peak centers
%   - No false positive peaks or cell lines with 1 replicate 
%
% yuanyuan.li@nih.gov
% created : 03-27-2013
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
addpath(genpath('./'))

fid = fopen([out_loc,tf,'_TKDE_bw',num2str(bw),'_cBump_allChr.bed'], 'w');

disp(['- Postprocessing: pool all chr for ',tf,' TKDE bw',num2str(bw)]);

for chr = 1:CHR
    
    % find all con_mode names, read them in. 
    cMode_file = dir([in_loc, tf, '_KDE_bw', num2str(bw), '_chr', ...
        num2str(chr), '_cNode*_cBump.txt']);
    
    con_modes_chr_loc = [];
    con_modes_chr_nCell = [];

    % for all constitutive modes under current chromosome, 
    %     - find all modes' locations, use them as txStart & txEnd.
    %     - find # cells associate with them.
    for i=1:length(cMode_file)
        con_mode = dlmread([in_loc, cMode_file(i).name]);
        con_modes_loc   = con_mode(:,2); %2nd col
        con_modes_nCell = con_mode(:,3); %3rd col
        
        con_modes_chr_loc = [con_modes_chr_loc; con_modes_loc];
        con_modes_chr_nCell = [con_modes_chr_nCell; con_modes_nCell];

        % sort the locations based on their order
        [con_modes_chr_loc, idx] = sort(con_modes_chr_loc, 'ascend');
        con_modes_chr_nCell = con_modes_chr_nCell(idx);
    end%end-for all constitutive modes found
    
    % Write to 0 bps bed file format:chr#  txStart  txEnd  #cells
    if chr <= 22 %for chr1-22
        for ii = 1:length(con_modes_chr_loc)
            fprintf(fid,'chr%d\t%12d\t%12d\t%12d\n', chr, ...
                con_modes_chr_loc(ii), con_modes_chr_loc(ii), ...
                con_modes_chr_nCell(ii));
        end%end: for all constitituve locations available
    elseif chr==23% for chr==23
        % There might be multiple constitutive mdoes under a cluster
        for ii = 1:length(con_modes_chr_loc)
            fprintf(fid,'chrX\t%12d\t%12d\t%12d\n', ...
                con_modes_chr_loc(ii), con_modes_chr_loc(ii), ...
                con_modes_chr_nCell(ii));
        end
    elseif chr==24% for chr==24
        % There might be multiple constitutive mdoes under a cluster
        for ii = 1:length(con_modes_chr_loc)
            fprintf(fid,'chrY\t%12d\t%12d\t%12d\n', ...
                con_modes_chr_loc(ii), con_modes_chr_loc(ii), ...
                con_modes_chr_nCell(ii));
        end
    end%end-if-else


end%end-for each chromosome 

fclose(fid);
disp('done');
end % end-function

