%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% demo_par.m : this is a T-KDE software demo script (parallel version)
%
% Parallel processing may speedup the process. To execute
%  1. start 12 processors in matlab command line  >>matlabpool open 12
%  2. run this program                            >>demo_par
%  3. end parallel processing                     >>matlabpool close
%
% yuanyuan.li@nih.gov
% created : 05-28-2013
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clc; clear; 
% Setup class path
addpath(genpath('./'))

CHR=23; % total number of chromosomes

% Preprocess step: input & output parameter settings
tf_name ='Gabp';
db_loc  ='./input/Gabp/';
cellline_info = './input/Gabp/Gabp_cell.nfo';
pre_loc_o = './output/Gabp/preprocess/';

% Step1: input & output parameter settings
thre = 0.90; % threshold for constitutive condition
tree_loc_o = './output/Gabp/tree/';
node_loc_o = './output/Gabp/cNode/';

% Step2: input & output parameter settings
bandwidth = 100; % Bandwidth for KDE = 100 bps
kde_loc_o = './output/Gabp/kde/';

% Step3: input & output parameter settings
bump_loc_o = './output/Gabp/bump/';
cbump_loc_o = './output/Gabp/cBump/';

% Postprocessing: pool all chromosome together
out_loc = './output/Gabp/';

% For each chromosome do TKDE 
parfor chr = 1:CHR % parallel processing choice (chr exe out of order)

    % Preprocess step: read in ChIP-seq, get peak centers by cell line. 
    preprocess_getPeakCenterByCellline(db_loc, cellline_info, tf_name, ...
        chr, pre_loc_o);

    % Step 1: Build range tree & get constitutive terminal nodes
    %         for a given TF's ChIP-seq peak centers. 
    step1_buildBinaryRangeTree(pre_loc_o, tf_name, chr, thre, tree_loc_o);
    step1_getTreeConNode(tree_loc_o, tf_name, chr, node_loc_o);

    % Step 2: Build KDE for each constitutive terminal nodes identified
    step2_constructKDEfromConNodes(pre_loc_o, node_loc_o, tf_name, ...
        bandwidth, chr, kde_loc_o);

    % Step 3: Get constitutive modal regions (this step is time consuming)
    step3_getModeAssocFromKDEs(kde_loc_o,tf_name,chr,bandwidth,bump_loc_o);
    step3_getConModeAssocFromKDE(pre_loc_o, bump_loc_o, tf_name, chr, ...
        bandwidth, thre, cbump_loc_o);
    
end% end-for 23 chromosomes do TKDE

postprocess_poolConBumpForAllChrTogether(cbump_loc_o,tf_name,bandwidth,...
    CHR, out_loc);
