/*
The original data matrix containing the phase angles is called DATA0.
The names of the genes are in vector NAMES.
Order is a vector specifying the order in which the genes are introduced in the model.
Initnum is the value setting the number of genes included in the initial model.

In each step the program returns the number of the step, the number and name of the gene processed in that step,
a variable announcing if that gene is included in the final model or not,
the SCE and p-values of each experiment.

At the end the program returns the final selected model.
selec is a vector containing 1 if the gene in that position is in the final model and 0 otherwise.
solu gives the numbers of the genes in the final model;
finalgen gives the names of the selected genes (in the original order in which they appear in matrix DATA0);

This program allows the specification of genes assumed to have equal angle phases in vector eq (see below).

The program includes also the backward step.
*/

options nonotes;

proc iml;


* Parameters and values of the model start below this line 
***********************************************************************************************************************;


* DATA0 matrix should contain the values of the phase angles given by the RPM model.
Each of the rows of matrix DATA should contain the values for each of the experiments that is being used.
In each of the columns should appear the values for the same gene across the experiments.
The columns should be ordered according to the isotropic order that is to be tested as null.;

* MISSING VALUES.
Missing values must be replaced by a value higher than 2pi. For example set them equal to 500 as below.;

* Set DATA0 as the matrix containing the phase angles and NAMES as the vector containing the gene names HERE; 

*Core set FB;
*NAMES={cdc18 ssb1 cdc22 msh6 mrc1 pol1 psm3 rad21 rhp51 cig2 pol2 mik1 h3_3 hhf1 hht3 hta2 htb1 pht1 klp5 fkh2 ace2 mid2 plo1 mob1 mcp1 myo3 chs2 cdc15 imp2 fin1 sid2 rgs1 slp1 SPAC1705_03C eng1};
*DATA0={5.788814286 0.202114286 0.217614286 6.261714286 6.024914286 5.615314286 5.764714286 0.892814286 4.928614286 5.611914286 5.341814286 6.257114286 1.178314286 0.911714286 1.200214286 0.970714286 1.288614286 0.582414286 4.817814286 5.298114286 5.645614286 0.339714286 4.890614286 5.920614286 4.751914286 1.111814286 5.596614286 5.297814286 5.204214286 1.604214286 4.251514286 4.641314286 5.209214286 4.877314286 6.028914286,
2.182014286 2.939814286 3.261714286 2.810614286 2.683814286 2.004914286 2.848414286 1.603414286 2.252214286 2.381714286 1.936814286 1.709314286 4.689214286 4.355214286 4.717214286 4.418814286 4.397014286 5.984514286 1.821314286 1.600214286 2.507914286 3.285114286 2.644314286 3.307614286 0.819314286 2.373414286 1.819314286 2.514914286 2.114614286 2.596714286 1.751214286 2.535314286 2.518614286 2.811414286 2.906414286,
5.434914286 0.440514286 0.447414286 5.257514286 5.520714286 5.933514286 6.206114286 4.381214286 0.664214286 5.458414286 0.581014286 6.044714286 1.541214286 0.727214286 6.114814286 0.351814286 0.687314286 5.852914286 4.825214286 3.935014286 5.337614286 0.067914286 4.851714286 6.082514286 4.353114286 0.741414286 3.970414286 5.502714286 5.879114286 6.202814286 5.835714286 5.307214286 5.895914286 0.446214286 0.117114286,
2.533714286 3.327714286 3.565314286 3.387314286 3.025714286 3.013014286 2.806314286 3.193614286 2.466914286 3.260414286 2.853114286 3.026114286 4.778714286 4.693514286 4.755314286 4.816414286 4.675114286 5.795614286 3.094114286 2.685114286 2.653214286 4.150114286 2.540914286 3.741614286 5.564814286 3.273414286 2.769814286 2.961314286 2.295714286 3.528114286 2.885114286 2.884914286 2.421814286 3.185914286 3.025514286,
3.671514286 3.333314286 3.912214286 3.894514286 3.143714286 3.573914286 3.443614286 3.647714286 2.422814286 3.969514286 3.384714286 4.296214286 5.188714286 5.059914286 5.143514286 5.215914286 5.243414286 3.134014286 2.572514286 3.338014286 3.542714286 3.509114286 3.330314286 2.818614286 1.725414286 3.249914286 3.607014286 3.186214286 3.288814286 3.105314286 3.082114286 3.876214286 3.185314286 2.744314286 3.880814286,
1.407914286 1.965114286 2.150714286 2.033814286 1.784614286 2.064314286 2.028914286 1.741714286 1.497114286 2.072714286 500 1.730114286 3.129814286 2.993014286 3.085314286 3.063214286 2.872714286 3.255914286 1.253514286 1.281414286 1.289214286 2.219314286 0.771914286 1.650914286 0.171214286 1.348314286 1.178714286 1.296114286 1.747714286 2.156314286 1.905914286 2.246414286 1.236814286 1.812214286 1.769214286,
1.695114286 1.809114286 2.207914286 1.414814286 2.295114286 2.188514286 1.351114286 1.963514286 1.978614286 1.940414286 1.370014286 1.978514286 3.744914286 3.584314286 3.669714286 3.479414286 3.590514286 3.600514286 1.129614286 1.382914286 1.723814286 2.703614286 0.963214286 2.166914286 1.464114286 1.212014286 1.455614286 1.518314286 1.180514286 1.920714286 1.063714286 2.694114286 1.396114286 1.329414286 1.410114286,
1.334514286 500 1.457414286 1.288414286 1.492514286 1.306814286 500 1.529614286 1.664014286 1.373714286 1.357414286 1.379214286 2.420114286 2.278814286 2.409314286 2.310614286 2.245014286 2.008614286 1.104614286 1.010414286 1.035614286 1.686214286 0.353314286 0.990214286 6.041214286 0.981714286 1.146314286 0.951514286 500 1.285614286 500 1.077214286 1.090514286 0.960714286 1.431014286,
1.732614286 2.213714286 1.786314286 1.730014286 1.776714286 1.824214286 1.987214286 1.878214286 1.864314286 1.882314286 1.392814286 3.070614286 2.704414286 2.787914286 2.814214286 2.908614286 2.739614286 2.622314286 1.464514286 1.351714286 1.449714286 1.966914286 0.838614286 1.862014286 0.691814286 1.418014286 1.441014286 1.290414286 1.447914286 1.578914286 1.275014286 4.270214286 1.420114286 1.304914286 1.707314286,
2.101814286 2.340114286 2.701814286 2.703514286 2.220314286 2.694614286 2.525714286 2.978914286 2.275514286 2.319014286 500 2.284314286 3.773314286 3.567514286 3.636214286 3.465014286 3.430614286 3.894414286 2.692214286 1.981314286 2.215914286 2.844914286 2.341714286 2.578714286 0.592414286 500 1.716414286 2.066014286 2.373814286 2.669814286 2.523514286 3.947514286 2.118114286 2.202014286 2.600314286};

*Core set FH;
NAMES={ssn6 sds22 ace2 cdc18 mik1 hhf1 dfr1 x1  hta2 mug71 rnc1 top2 pif1 fkh2 x2 cdc25 ark1 klp5 cig2 plo1 spm1 slp1 bir1 rad21};
DATA0={1.821414286	5.071514286	5.645614286	5.788814286	6.257114286	0.911714286	2.678714286	0.587514286	0.970714286	5.209114286	6.274414286	3.842314286	5.859614286	5.298114286	2.082514286	3.354214286	3.939014286	4.817814286	5.611914286	4.890614286	5.726614286	5.209214286	4.545314286	0.892814286,
0.819714286	6.285314286	2.507914286	2.182014286	1.709314286	4.355214286	0.683914286	1.224414286	4.418814286	2.228814286	6.254514286	1.748314286	2.621514286	1.600214286	3.378214286	2.102814286	1.319314286	1.821314286	2.381714286	2.644314286	4.685314286	2.518614286	1.801914286	1.603414286,
3.870614286	4.531914286	5.337614286	5.434914286	6.044714286	0.727214286	4.002614286	0.754514286	0.351814286	1.365514286	4.108414286	3.627814286	1.042714286	3.935014286	1.042314286	4.351914286	5.777314286	4.825214286	5.458414286	4.851714286	6.139614286	5.895914286	3.369414286	4.381214286,
5.659914286	4.352714286	2.653214286	2.533714286	3.026114286	4.693514286	4.285814286	6.144114286	4.816414286	3.150114286	5.592314286	0.803414286	3.068414286	2.685114286	5.397714286	0.691314286	1.722014286	3.094114286	3.260414286	2.540914286	3.005814286	2.421814286	1.491514286	3.193614286,
6.116614286	5.419114286	3.542714286	3.671514286	4.296214286	5.059914286	3.466014286	2.520614286	5.215914286	2.999714286	0.820214286	2.241614286	4.164314286	3.338014286	2.103914286	2.610414286	3.054214286	2.572514286	3.969514286	3.330314286	2.247514286	3.185314286	2.671614286	3.647714286,
3.642414286	4.448314286	1.289214286	1.407914286	1.730114286	2.993014286	2.323714286	1.377714286	3.063214286	1.667014286	3.695414286	5.363214286	2.456614286	1.281414286	2.218814286	5.363914286	0.530714286	1.253514286	2.072714286	0.771914286	1.514614286	1.236814286	5.685814286	1.741714286,
5.266014286	2.428714286	1.723814286	1.695114286	1.978514286	3.584314286	4.114614286	1.279614286	3.479414286	2.073214286	4.176014286	5.847514286	2.592714286	1.382914286	1.549514286	5.898114286	0.868514286	1.129614286	1.940414286	0.963214286	2.203914286	1.396114286	0.969314286	1.963514286,
4.394514286	4.721414286	1.035614286	1.334514286	1.379214286	2.278814286	3.952214286	0.760514286	2.310614286	1.258114286	3.840614286	4.601314286	500	1.010414286	1.968514286	500	0.624414286	1.104614286	1.373714286	0.353314286	1.500714286	1.090514286	500	1.529614286,
4.279614286	4.160214286	1.449714286	1.732614286	3.070614286	2.787914286	4.630414286	1.677114286	2.908614286	1.307114286	3.996414286	6.080314286	2.114214286	1.351714286	2.182514286	0.345214286	1.294014286	1.464514286	1.882314286	0.838614286	1.662614286	1.420114286	1.527314286	1.878214286,
5.405214286	500	2.215914286	2.101814286	2.284314286	3.567514286	4.694514286	1.886214286	3.465014286	2.356614286	0.344714286	2.403514286	2.437114286	1.981314286	1.790314286	1.811214286	0.594414286	2.692214286	2.319014286	2.341714286	1.733114286	2.118114286	0.654214286	2.978914286
};


pi=4*atan(1); 

*Equalities among the parameters. 
Each line of the eq matrix contains the first and last gene assumed to have equal phase angles.
There may be more than one set of equal genes. Use a line of eq matrix for each set.
If there are no equalities just set the eq matrix equal to {0 0};
*eq={0 0}; 
*Core set FB; 
*eq={3 7, 8 9, 10 11, 21 23, 25 27, 28 29};
*Core set FH;
eq={16 17, 19 21, 22 23};

*This is the order in which the genes are introduced in the model;
*orden={33 3 14 17 13 15 16 20 10 4 12 2 27 7 31 8 28 1 21 35 34 22 5 23 30 26 6 19 29 24 18 11 32 9 25};
*Core set FH; 
orden={22 4 3 9 19 20 18 13 24 21 6 14 5 10 16 11 15 12 1 17 8 2 23 7};

*This is the initial number of genes to be introduced;
*Core set FB;
*initnum=16;
*Core set FH; 
initnum=10;

*FSA p-values limits. 
The gene is rejected if at least FSn1 of the p-values is lower than FSAp1 or at least FSAn2 are lower than FSAp2;
FSAp1=0.2; FSAp2=0.3; FSAn1=1; FSAn2=2;


*********************************************************************************************************************
Parameters end above this line. There should be no need of changing anything below this line;

*Routines start here;

*SCE COMPUTATION ROUTINE v2;
START F_MSCE(init) global(exp,wexp);
	y=wexp*cos(exp-init)`;
	return(y);
FINISH F_MSCE;

*CIRCULAR MEAN and RESULTANT VALUES ROUTINE v2;
START CMEAN(g);

pi=4*atan(1); 
k=nrow(g);

caut2=cos(g)[+,]; saut2=sin(g)[+,];
mean2=atan(saut2/caut2);
ll=loc(caut2<0);
if nrow(ll)>0 then do; mean2[,loc(caut2<0)]=mean2[,loc(caut2<0)]+pi; end;
ll=loc(mean2<0);
if nrow(ll)>0 then do; mean2[,ll]=mean2[,ll]+2*pi; end;
res2=((caut2/k)##2+(saut2/k)##2)##0.5;
meanres=(mean2)`||(res2)`;

RETURN(meanres);
FINISH;

*Bessel function to be minimized;	
start funbessel(x) global(z);
	if x<0 then x=0.000000001;
	y=(IBESSEL(1,x,0)/IBESSEL(0,x,0)-z)**2; 	
	return(y);
finish funbessel;

*Cosinus function to be minimized;	
start funcos(x) global(i,zaux,kaux);
		y=0;
	do ii=1 to nrow(zaux);
		y=y+kaux[ii]*cos(zaux[ii]-x);	
	end;
return(y);
finish funcos;


* KAPPA ESTIMATION ROUTINE;
START kappa(mat) global(z,i,zaux,kaux);

pi=4*atan(1);
th=mat;
*total circular mean;
thvec=th[1,loc(th[1,]<2*pi)]`;
do i=2 to nrow(th);
	thvec=thvec//th[i,loc(th[i,]<2*pi)]`;
end;
total=CMEAN(thvec);

*mean for each gene;
meangen=J(1,ncol(th),0);
do i=1 to ncol(th);
	auxi=th[loc(th[,i]<2*pi),i];
	meangen[i]=CMEAN(auxi)[1]; 
end;

*mean for each experiment;
meanexp=J(nrow(th),1,0);
do i=1 to nrow(th);
	auxi=th[i,loc(th[i,]<2*pi)]`;
	meanexp[i]=CMEAN(auxi)[1]; 
end;


* starting value of gamma;
gamma=J(nrow(th),ncol(th),0);
gamma=th-J(nrow(th),1,1)*meangen+total[1]*J(nrow(th),ncol(th),1);

*resultant by experiment (first step);
resexp=J(nrow(th),2,0);
do i=1 to nrow(th);
	auxi=gamma[i,loc(th[i,]<2*pi)]`;
	resexp[i,]=CMEAN(auxi); 
end;

*first values for kappa;
kappa=J(nrow(th),1,0);
optn={0 0};
do i=1 to nrow(th);
	x=1; z=resexp[i,2]; con={0,.};
	call nlpnrr(rc,xres,"funbessel",x,optn,con);
	kappa[i]=xres;	
end;

*print kappa;

* first values for zeta;
zeta=J(nrow(th),ncol(th),0);
zeta=th-(meanexp*J(1,ncol(th),1));

* first values for alfa;
meangen2=J(1,ncol(th),0);
do i=1 to ncol(th);
	zaux=zeta[loc(th[,i]<2*pi),i]; kaux=kappa[loc(th[,i]<2*pi)];
	x=pi; optn={1 0}; con={0,6.283185};
	call nlpnrr(rc,xres,"funcos",x,optn,con);
	meangen2[i]=xres;
end;

*Iteration procedure;
do ss=1 to 40;

	*new gamma;
	gamma=th-J(nrow(th),1,1)*meangen2;

	*new resultants and means for each experiment;
	do i=1 to nrow(th);
		auxi=gamma[i,loc(th[i,]<2*pi)]`;
		resexp[i,]=CMEAN(auxi); 
	end;

	*new kappa for each experiment;
	optn={0 0};
	do i=1 to nrow(th);
		x=1; z=resexp[i,2]; con={0,.};
		call nlpnrr(rc,xres,"funbessel",x,optn,con);
		kappa[i]=xres;	
	end;

	*new zetas;
	zeta=th-(resexp[,1]*J(1,ncol(th),1));

	*new alfas;
	do i=1 to ncol(th);
		zaux=zeta[loc(th[,i]<2*pi),i]; kaux=kappa[loc(th[,i]<2*pi)];
		x=pi; optn={1 0}; con={0,6.283185};
		call nlpnrr(rc,xres,"funcos",x,optn,con);
		meangen2[i]=xres;
	end;

kappa2=kappa`;

*print ss kappa;

end;

*print kappa;

* Maximum likelihood estimator for kappa in each experiment (MARDIA);
do i=1 to nrow(th);
	cte=ncol(th)-ncol(loc(th[i,]>2*pi));
	if kappa[i]<2 then do;
		kappa[i]=max(kappa[i]-2/(cte*kappa[i]),0);
	end;
	else do;
		kappa[i]=((cte-1)**3)*kappa[i]/(cte**3+cte);
	end;
end;

kappa3=kappa`;

*print kappa;

RETURN(kappa3);
FINISH KAPPA;

* CONDITIONAL TEST ROUTINE;
START CTEST(data) global(SCEmat,CIREmat,z,i,zaux,kaux,kp,eqtotvec);
pi=4*atan(1);
thmat=data;

*Estimated values of kappa;
*kp=KAPPA(thmat`);

* CONDITIONAL TEST FOR EACH OF THE EXPERIMENTS;
do nexp=1 to ncol(thmat);

	thf=CIREmat[loc(CIREmat[,nexp]<2*pi),nexp]; SCE=SCEmat[nexp];

	* Equalities counter for determining the degrees of freedom;
	ig=0;
	do ii=1 to nrow(thf)-1;
		if abs(thf[ii]-thf[ii+1])<0.000001 then ig=ig+1;
	end;
	if abs(thf[nrow(thf)]-thf[1])<0.000001 then ig=ig+1;
	
	ig=ig+eqtotvec[nexp];

	* p-values;
	if ig>0 then pval=(1-(1/FACT(nrow(thf)-1)))*(1-probchi(2*kp[nexp]*SCE,ig));
	if ig=0 then pval=1;
	if nexp=1 then pvalmat=pval;
	else pvalmat=pvalmat//pval;
end;

CIREmat2=CIREmat`; SCEmat2=SCEmat`; kp=kp`; result=CIREmat2||SCEmat2||kp||pvalmat; 

RETURN(result);
FINISH CTEST;

*Routines end above this line;

*Inclusion of the initial genes in the analysis;
selec=J(1,ncol(data0),0);
do se=1 to initnum;
	selec[orden[se]]=1;
end;

in=0;

*Iterations for the possible elimination of the initial genes;
do sel=initnum to 1 by -1 while (in=0);

	DATA=DATA0[,loc(selec)];
	pi=4*atan(1); 
	ngenexp=J(nrow(data),1,0);
	do j=1 to nrow(data);
		ngenexp[j]=ncol(loc(data[j,]<2*pi));
	end;
*print DATA;
	pi=4*atan(1);
	thmat=data;

	*Estimated values of kappa;
	kp=KAPPA(thmat); 

	*Correction for equalities;
	selec2=J(1,ncol(data),1);
	resmat=J(nrow(data),ncol(data),1);
	eqtotvec=J(nrow(data),1,0);

	if eq[1,1]>0 then do;
		do rr=1 to nrow(eq);
			eqtot=sum(selec[eq[rr,1]:eq[rr,2]]);
			if eqtot>1 then do;
				eqprim=loc(selec[eq[rr,1]:eq[rr,2]])[1];
				
					kmar=0;
					do j=1 to eq[rr,1]+eqprim-1 while (kmar=0);
						if data[,j]=data0[,eq[rr,1]+eqprim-1] then do; kpos=j; kmar=1; end;
					end;
					selec2[kpos+1:kpos+eqtot-1]=0;

					if ncol(loc(data[,kpos:kpos+eqtot-1]>2*pi))=0 then do;
						eqtotvec=eqtotvec+(eqtot-1);
						cmeanaux=CMEAN(data[,kpos:kpos+eqtot-1]`);
						data[,kpos]=cmeanaux[,1];
						resmat[,kpos]=eqtot*cmeanaux[,2]; 
					end;
					else do;
						do j=1 to nrow(data);
							alfapos=loc(data[j,kpos:kpos+eqtot-1]<2*pi);
							if ncol(alfapos)>0 then do;
								eqtotvec[j]=eqtotvec[j]+ncol(alfapos)-1;
								auxloc=kpos+alfapos-1; 
								auxexp=data[j,auxloc]; 
								cmeanaux=CMEAN(auxexp`);
								data[j,kpos]=cmeanaux[,1];
								resmat[j,kpos]=ncol(auxexp)*cmeanaux[,2];  
							end;
						end;
					end;
			end;
		end;
	end;
	data=DATA[,loc(selec2)]; 
	resmat=resmat[,loc(selec2)];
	CIREmat=J(nrow(data),ncol(data),0); 
	SCEmat=J(nrow(data),1,0);
	exp0=data[1,];
	exp=exp0; 
*print DATA;


	do k=1 to nrow(data);
		sce0=9999;

		exp=data[k,loc(data[k,]<2*pi)];  
		wexp=resmat[k,loc(data[k,]<2*pi)]; 
		swexp=sum(wexp); 
		ncolexp=ncol(exp); 
		init=J(1,ncol(exp),1);
		cire=J(1,ncol(exp),0);
		
		if ncol(exp)>1 then do;
			*Restrictions among the estimators;
			con=J(ncol(exp)+1,ncol(exp)+2,.);
			con[1,1:ncol(exp)]=0;
			con[2,1:ncol(exp)]=2*pi;
			do i=3 to nrow(con);
				con[i,i-2]=1; con[i,i-1]=-1;
			end;
			con[3:nrow(con),ncol(con)-1]=-1;
			con[3:nrow(con),ncol(con)]=0;

			*Computation of the estimators;
			do j=1 to 200;
				do i=1 to ncol(exp);
					init[i]=2*pi*ranuni(34669);
				end;
				optn={1 0};
				call nlpnrr(rc,xres,"F_MSCE",init,optn,con);
				sce=ngenexp[k]-F_MSCE(xres);
				if sce<sce0 then do;
					sce0=sce;
					cire=xres`;
				end;
			end;

			do sss=2 to ncol(exp);
					exp=exp[2:ncol(exp)]`||exp[1];
					wexp=wexp[2:ncol(wexp)]`||wexp[1];
					do j=1 to 200;
						do i=1 to ncol(exp);
							init[i]=2*pi*ranuni(34679);
						end;
						optn={1 0};
						call nlpnrr(rc,xres,"F_MSCE",init,optn,con);
						sce=ngenexp[k]-F_MSCE(xres);
						if sce<sce0 then do;
							sce0=sce;
							cire=xres[ncol(exp)-sss+2:ncol(exp)]//xres[1:ncol(exp)-sss+1];
						end;
					end;
			end;
		end;
		else do; cire=exp; sce0=0; end;

		auxi=cire;
		if data[k,1]>2*pi then auxi=data[k,1]//auxi;
		do ngen=2 to ncol(data)-1;
			if data[k,ngen]>2*pi then auxi=auxi[1:ngen-1]//data[k,ngen]//auxi[ngen:nrow(auxi)];
		end;
		if data[k,ncol(data)]>2*pi then auxi=auxi//data[k,ncol(data)];
		CIRE=auxi`;

	CIREmat[k,]=cire; SCEmat[k]=sce0;
	end;


* These commands perform the conditional test of the fixed level;
DATA=DATA`; 
SCEmat=SCEmat`;
CIREmat=CIREmat`;
res=CTEST(DATA); 

* These are the results;
CIRE=res[,1:nrow(DATA)]; SCE=res[,nrow(DATA)+1]; 
kappa=res[,nrow(DATA)+2]; pval=res[,nrow(DATA)+3]; DATA=DATA`; 
step=sel-initnum;
genestep=orden[sel];
gename=names[orden[sel]];



* FSA parameter checking v2;
*if min(pval)<FSAp1 then selec[orden[sel]]=0;
ch1=0; ch2=0;
do chp=1 to nrow(pval);
if pval[chp]<FSAp1 then ch1=ch1+1;
if pval[chp]<FSAp2 then ch2=ch2+1;
end;
if ch1>FSAn1-1 then selec[orden[sel]]=0;
if ch2>FSAn2 then selec[orden[sel]]=0;
if selec[orden[sel]]=1 then in=1;

solu=loc(selec);
finalgen=names[solu]`;

*These are the solutions in each step. step is the number of the step.
genestep is the number of the gene being considered in this step.
in equals 1 if the gene considered is selected, 0 if it is rejected.;
print step genestep gename in SCE kappa pval;
*print data CIRE;

end;

sel2=sel+2;

*Iterations for the possible selection of each of the non-initial genes;
do sel=sel2 to ncol(data0);


	selec[orden[sel]]=1; in=1;
	DATA=DATA0[,loc(selec)];
	pi=4*atan(1); 
	ngenexp=J(nrow(data),1,0);
	do j=1 to nrow(data);
		ngenexp[j]=ncol(loc(data[j,]<2*pi));
	end;
*print DATA; *print ngenexp;
	pi=4*atan(1);
	thmat=data;

	*Estimated values of kappa;
	kp=KAPPA(thmat); 

	*Correction for equalities;
	selec2=J(1,ncol(data),1);
	resmat=J(nrow(data),ncol(data),1);
	eqtotvec=J(nrow(data),1,0);

	if eq[1,1]>0 then do;
		do rr=1 to nrow(eq);
			eqtot=sum(selec[eq[rr,1]:eq[rr,2]]);
			if eqtot>1 then do;
				eqprim=loc(selec[eq[rr,1]:eq[rr,2]])[1];
				
					kmar=0;
					do j=1 to eq[rr,1]+eqprim-1 while (kmar=0);
						if data[,j]=data0[,eq[rr,1]+eqprim-1] then do; kpos=j; kmar=1; end;
					end;
					selec2[kpos+1:kpos+eqtot-1]=0;

					if ncol(loc(data[,kpos:kpos+eqtot-1]>2*pi))=0 then do;
						eqtotvec=eqtotvec+(eqtot-1);
						cmeanaux=CMEAN(data[,kpos:kpos+eqtot-1]`);
						data[,kpos]=cmeanaux[,1];
						resmat[,kpos]=eqtot*cmeanaux[,2]; 
					end;
					else do;
						do j=1 to nrow(data);
							alfapos=loc(data[j,kpos:kpos+eqtot-1]<2*pi);
							if ncol(alfapos)>0 then do;
								eqtotvec[j]=eqtotvec[j]+ncol(alfapos)-1;
								auxloc=kpos+alfapos-1; 
								auxexp=data[j,auxloc]; 
								cmeanaux=CMEAN(auxexp`);
								data[j,kpos]=cmeanaux[,1];
								resmat[j,kpos]=ncol(auxexp)*cmeanaux[,2];  
							end;
						end;
					end;
			end;
		end;
	end;

	data=DATA[,loc(selec2)]; 
	resmat=resmat[,loc(selec2)];
	CIREmat=J(nrow(data),ncol(data),0); 
	SCEmat=J(nrow(data),1,0);
	exp0=data[1,];
	exp=exp0; 
*print DATA;


	do k=1 to nrow(data);
		sce0=9999;

		exp=data[k,loc(data[k,]<2*pi)];  
		wexp=resmat[k,loc(data[k,]<2*pi)]; 
		swexp=sum(wexp); 
		ncolexp=ncol(exp); 
		init=J(1,ncol(exp),1);
		cire=J(1,ncol(exp),0);
		
		if ncol(exp)>1 then do;
			*Restrictions among the estimators;
			con=J(ncol(exp)+1,ncol(exp)+2,.);
			con[1,1:ncol(exp)]=0;
			con[2,1:ncol(exp)]=2*pi;
			do i=3 to nrow(con);
				con[i,i-2]=1; con[i,i-1]=-1;
			end;
			con[3:nrow(con),ncol(con)-1]=-1;
			con[3:nrow(con),ncol(con)]=0;

			*Computation of the estimators;
			do j=1 to 200;
				do i=1 to ncol(exp);
					init[i]=2*pi*ranuni(34669);
				end;
				optn={1 0};
				call nlpnrr(rc,xres,"F_MSCE",init,optn,con);
				sce=ngenexp[k]-F_MSCE(xres);
				if sce<sce0 then do;
					sce0=sce;
					cire=xres`;
				end;
			end;

			do sss=2 to ncol(exp);
					exp=exp[2:ncol(exp)]`||exp[1];
					wexp=wexp[2:ncol(wexp)]`||wexp[1];
					do j=1 to 200;
						do i=1 to ncol(exp);
							init[i]=2*pi*ranuni(34679);
						end;
						optn={1 0};
						call nlpnrr(rc,xres,"F_MSCE",init,optn,con);
						sce=ngenexp[k]-F_MSCE(xres);
						if sce<sce0 then do;
							sce0=sce;
							cire=xres[ncol(exp)-sss+2:ncol(exp)]//xres[1:ncol(exp)-sss+1];
						end;
					end;
			end;
		end;
		else do; cire=exp; sce0=0; end;

		auxi=cire;
		if data[k,1]>2*pi then auxi=data[k,1]//auxi;
		do ngen=2 to ncol(data)-1;
			if data[k,ngen]>2*pi then auxi=auxi[1:ngen-1]//data[k,ngen]//auxi[ngen:nrow(auxi)];
		end;
		if data[k,ncol(data)]>2*pi then auxi=auxi//data[k,ncol(data)];
		CIRE=auxi`;

	CIREmat[k,]=cire; SCEmat[k]=sce0;
	end;

* These commands perform the conditional test of the fixed level;
DATA=DATA`; *print ngenexp;
SCEmat=SCEmat`; *print SCEmat;
CIREmat=CIREmat`; *print CIREmat;
res=CTEST(DATA); 

* These are the results;
CIRE=res[,1:nrow(DATA)]; SCE=res[,nrow(DATA)+1]; 
kappa=res[,nrow(DATA)+2]; pval=res[,nrow(DATA)+3]; DATA=DATA`; 
step=sel-initnum;
genestep=orden[sel];
gename=names[orden[sel]];


* FSA parameter checking;
*if min(pval)<FSAp1 then selec[orden[sel]]=0;
ch1=0; ch2=0;
do chp=1 to nrow(pval);
if pval[chp]<FSAp1 then ch1=ch1+1;
if pval[chp]<FSAp2 then ch2=ch2+1;
end;
if ch1>FSAn1-1 then selec[orden[sel]]=0;
if ch2>FSAn2 then selec[orden[sel]]=0;
if selec[orden[sel]]=0 then in=0;

solu=loc(selec);
finalgen=names[solu]`;

if in=1 then do;
	finalSCE=SCE; finalpval=pval; finalkappa=kappa;
end;

*These are the solutions in each step. step is the number of the step.
genestep is the number of the gene being considered in this step.
in equals 1 if the gene considered is selected, 0 if it is rejected.;
print step genestep gename in SCE kappa pval;
*print data CIRE;
end;

*These are the final solutions.
selec is a vector containing 1 if the gene in that position is in the final model and 0 otherwise.
solu gives the numbers of the genes in the final model;
print selec solu finalgen;
print FSAp1 FSAn1 FSAp2 FSAn2 finalSCE finalkappa finalpval;

quit;
