library(MASS)

max.test<-function(all.fam.delta,permu.num=1000,minsize=10,effect=effect,use.missing=use.missing,
                    cutoff.snp=cutoff.snp, cutoff.global=cutoff.global, cutoff.test=cutoff.test)
{

  z2.permu<-NULL
  hot.permu<-NULL
     ############################################################
      ######                  Calculate Z                #######
      ############################################################

          z<-function(v)
          {
              v1<-v[!is.na(v) & v!=0]
              if (length(v1)>= minsize)
            {
            z<-mean(v1)/sqrt(var(v1)/(length(v1)))
           # z2[is.nan(z)]<-0
            }
            if (length(v1)< minsize) z<-0
            return (z)
          }

      ############################################################
      ######              Calculate Hotelling's            #######
      ############################################################

          hotelling<-function(m)
          {
            m[is.na(m)]<-0
            delta.mean<-apply(m,2,mean)
            hot_scr<- delta.mean%*%ginv(var(m))%*%delta.mean *dim(m)[1]

            return (hot_scr)
          }

  z.obs.all<- apply(all.fam.delta,MARGIN=2,FUN=z)
  z.mat<-(z.obs.all)^2
  z.obs<-max(abs(z.obs.all))
  z.snp<-which.max(abs(apply(all.fam.delta,MARGIN=2,FUN=z)))
  hot_scr<-hotelling(all.fam.delta)

  apply(all.fam.delta,2,function(v) {return(sum(v!=0,na.rm=T))})->info.ct
 if (sum(info.ct>=minsize)==0) {cat("Number of informative families does not meet the minsize=",minsize,
     "\nThe number of informative families for each SNP are:\n\n")
 for (k in 1:ceiling(length(z.obs.all)/10)) {
cat(" SNPs      :",format(paste('SNP_',(10*k-9):min((10*k),length(z.obs.all)),sep=''),digits=3,width=8,justify = "right"),"\n")
cat(" # INFO Fam:",format(info.ct[(10*k-9):min((10*k),length(z.obs.all))],digits=2,width=8,justify = "right"),"\n\n")
}
stop("\n\nERROR:  Try Setting the min.info to a smaller number\n\n")
}

    ################ Permutation test to evaluate significance ########
    for (i in 1:permu.num)
  {
     random<-(runif(dim(all.fam.delta)[1],0,1)>=0.5)*2-1
     delta<-all.fam.delta*(random)
     z.mat<-rbind(z.mat,(apply(delta,MARGIN=2,FUN=z))^2)
     z2.permu<-rbind(z2.permu,max(z.mat[i+1,]))
     hot.permu<-rbind(hot.permu,hotelling(delta))
  }

  z2.permu<-rbind(z.obs^2,z2.permu)
  hot.permu<-rbind(hot_scr,hot.permu)

  z2.p<-0

   rank.snp<-apply(z.mat,2,rank,ties.method='min')
  rank.snp<-apply(rank.snp,2,function(v){return(sum(v>=v[1])/length(v)) })
  rank.z2 <-rank(z2.permu,ties.method='min')
  rank.hot <-rank(hot.permu,ties.method='min')

  rank.z2[rank.z2>=rank.z2[1]]<-rank.z2[rank.z2>=rank.z2[1]]-1
  rank.hot[rank.hot>=rank.hot[1]]<-rank.hot[rank.hot>=rank.hot[1]]-1

  p.vec<- -(log(1-rank.z2/permu.num) + log(1-rank.hot/permu.num))
  rank.p.vec <-rank(p.vec,ties.method='min')
  rank.p.vec[rank.p.vec>=rank.p.vec[1]]<-rank.p.vec[rank.p.vec>=rank.p.vec[1]]-1

  tag.snp<-rep("",dim(all.fam.delta)[2])
  tag.snp[rank.snp<cutoff.snp & z.obs.all>0]<-"2"
  tag.snp[rank.snp<cutoff.snp & z.obs.all<0]<-"1"
  if (effect=='M') eff<-"Maternal Genetic Effect"
  if (effect=='C') eff<-"Fetal Genetic Effect"
  if (use.missing) missed<-"Using triad with missing genotype."  else missed<-"Using complete triad only."
  print.tag<-F
  if (cutoff.test == 'maxZ' & 1-max(rank.z2[1]-2,0)/permu.num < cutoff.global) print.tag<-T
  if (cutoff.test == 'sumlogP' & 1-max(rank.p.vec[1]-2,0)/permu.num < cutoff.global) print.tag<-T

cat("******************************************************************************************************","\n\n",
    "                              TESTING FOR: ",eff,"\n\n",
   "                         ###############################################","\n\n",
   "Testing conditions:\n",
   "                   ", missed,"\n",
   "                    Number of permutation = ",permu.num,"\n",
   "                    Minimum number of informative families required = ",minsize,"\n",
   "                    If p-value of the global test based on ",cutoff.test," test is less than ",cutoff.global,", print tagging alleles\n\n")

cat(
 " Global       test:\n",
 "                    Max_Z^2              value: ",z.obs^2," (max_Z=",z.obs,") at SNP ",z.snp,"\n",
 "                    Hotelling's T^2      value: ",hot_scr,"\n",
 "                    p-value for max Z2    test: ",1-max(rank.z2[1]-2,0)/permu.num,"\n",
 "                    p-value for Sum_logP  test: ",1-max(rank.p.vec[1]-2,0)/permu.num,"\n\n")
cat('Individual SNP scores:\n')
for (k in 1:ceiling(length(z.obs.all)/10)) {
cat(" SNP            :",format(paste('SNP_',(10*k-9):min((10*k),length(z.obs.all)),sep=''),digits=3,width=8,justify = "right"),"\n")
cat(" Z score        :",format(z.obs.all[(10*k-9):min((10*k),length(z.obs.all))],digits=3,width=8,justify = "right"),"\n")
cat(" p-value        :",format(rank.snp[(10*k-9):min((10*k),length(z.obs.all))],digits=2,width=8,justify = "right"),"\n")
if (print.tag)
cat(" Tagging allele :",format(tag.snp[(10*k-9):min((10*k),length(tag.snp))],digits=2,width=8,justify = "right"),"\n\n") else cat("\n")
}
cat("******************************************************************************************************","\n")

}

get.delta<-function(v,effect='C',use.missing=F)     # genotype order= M F C
{
  if (effect=='C') {
    if ((is.na(v[1]) & is.na(v[2]))| is.na(v[3]) ) delta<-NA else {
       if (!use.missing & (is.na(v[1]) | is.na(v[2])))  delta<-NA
       if (is.na(v[1]) & use.missing) delta<- v[3]-v[2]
       if (is.na(v[2]) & use.missing) delta<- v[3]-v[1]
       if (!is.na(v[1]) & !is.na(v[2])) delta<- 2*v[3]-v[1]-v[2]
  }
  }

  if (effect=='M') {
      if (is.na(v[1]) | is.na(v[2]) ) delta<-NA else delta<- v[1]-v[2]
  }
  return(delta)
}

Mend.Err<-function(m,f,c) {
err.m<-0
err.f<-0
err.mf<-0
err.mfc<-0
 if (!is.na(c) & !(is.na(f) & is.na(m)))  {
 if (is.na(m)) {

 if (abs(f-c)==2)  err.f<-2

 } else if (is.na(f)) {
   if (abs(m-c)==2)  err.m<-1

 } else {
 if (abs(m-c)==2)  err.m<-1
 if (abs(f-c)==2)  err.f<-2

 if ((c<floor(m/2)+floor(f/2) | c>ceiling(m/2)+ceiling(f/2) )& err.m==0 & err.f ==0) err.mfc<-4
}

}
return((err.m+err.f+err.mfc)>0)
}

trimm<-function(m.file="geno.m",f.file="geno.f",c.file="geno.c", sep = "", na.strings = 0, with.header=F
                ,use.missing = F, effect = 'C',min.info=10,permu.num=1000,cutoff.snp=0.1, cutoff.global=0.1, cutoff.test='maxZ' )
{

 read.table(m.file,header=with.header,sep=sep,na.strings=na.strings)->m
 read.table(f.file,header=with.header,sep=sep,na.strings=na.strings)->f
 read.table(c.file,header=with.header,sep=sep,na.strings=na.strings)->c
 if (dim(m)[2] !=  dim(f)[2]) stop("Error: Number of SNPs in mother's and father's genotype files are not the same!\n")
 if (dim(m)[2] !=  dim(c)[2] ) stop("Error: Number of SNPs in mother's and child's genotype files are not the same!\n")
 if (dim(f)[2] !=  dim(c)[2] ) stop("Error: Number of SNPs in father's and child's genotype files are not the same!\n")
 snp.num<-(dim(c)[2]-1 )/2

 c1 <- c[,-1]
 f1 <- f[,-1]
 m1 <- m[,-1]

 m<-cbind(m[,1],m1[,seq(1,(snp.num*2),by=2)]+m1[,seq(2,(snp.num*2),by=2)]-2)
 f<-cbind(f[,1],f1[,seq(1,(snp.num*2),by=2)]+f1[,seq(2,(snp.num*2),by=2)]-2)
 c<-cbind(c[,1],c1[,seq(1,(snp.num*2),by=2)]+c1[,seq(2,(snp.num*2),by=2)]-2)

 mf <- merge(m,f,by.x=1,by.y=1,all=T)
 mfc<- merge(mf,c,by.x=1,by.y=1,all=T)
 #######################################################################
 ####  More complicated than I thought.  The second allele could only appear in mother's genotype  and might be coded as 1
 ###  and the 'COMMON' allele is coded as 2. but in the child genotype, the 'Common' genotype might have been coded as 1
 ###   NOT FINISHED !!!
 mend<-NULL
for (i in 1:snp.num) {
 fam<-cbind(mfc[,i+1],mfc[,i+1+snp.num],mfc[,i+1+snp.num*2])
 mend<-cbind(mend,apply(fam,1,function(v) {return(Mend.Err(v[1],v[2],v[3]))}))
}

if (sum(mend)>0) stop("\n\nERROR: Mendelian Errors in the file!\nThe number of errors for the SNPs in order are: ",apply(mend,2,sum),"\n\n")

if (effect !='C' & effect !='M') stop("\n\nERROR:Effect tested should be either 'C' (child effect) \nor 'M' (global significance based on sum_log(p) test).  Note: CASE SENSITIVE\n\n")
if (cutoff.test !='maxZ' & cutoff.test !='sumlogP') stop("\n\nERROR:Effect tested should be either 'maxZ' (global significance based on max_Z2 test) or 'M' (maternal effect).  Note: CASE SENSITIVE\n\n")

if (use.missing & effect=='C') {
 cat("\n #################################################################################################\n",
     "# WARNING: Testing for child effect: 'use.missing' is set to 'T'.  If there is missing parents  #\n",
     "#          in the dataset, the tests are valid only when there is no maternal effect.           #\n"
    ,"#                                                                                               #\n"
    ,"#          Set 'use.missing' to 'F' if the no-maternal effect assumption does not hold.         #\n"
    ,"#################################################################################################\n\n")
}
if (use.missing & effect=='M') {
 cat("\n ###################################################################################################\n",
     "# WARNING: In testing maternal effect, only triad with no missing parental genotypes will be used #\n"
    ,"#          The option 'use.missing' has no effect in testing for maternal effect.                 #\n"
    ,"###################################################################################################\n\n")
}


  delta<-NULL
for (i in 1:snp.num) {
 fam<-cbind(mfc[,i+1],mfc[,i+1+snp.num],mfc[,i+1+snp.num*2])
 delta<-cbind(delta,apply(fam,1,function(v) {return(get.delta(v,effect,use.missing))}))

}
max.test(delta,minsize=min.info,permu.num=permu.num,effect=effect,use.missing=use.missing,cutoff.snp=cutoff.snp,
        cutoff.global=cutoff.global, cutoff.test=cutoff.test)


}

date()
trimm(effect='C',use.missing=T,min.info=30,permu.num=1000)
date()

