 function [beta_final,lamda_error,fval_out] = supnorm(train_in,test_in,log2lamda_in)

% Read in the training, tuning, testing and log2lamda data
% Return tables for a list of lamda

    global k;
    global d;
    global d1;
       
    % get input argument
    train = train_in;
    train_data = train(:,2:end);
    [row_train,col_train] = size(train_data);
    log2lamda = log2lamda_in;
    num_lamda = length(log2lamda);
    my_lamda = power(2,log2lamda);
    
    % initialize output argument and others
    beta_all = zeros(1+2*k*d+d1+row_train+1,num_lamda);
    beta_final = zeros(1+k*d,num_lamda);
    lamda_error = zeros(num_lamda,5); % have 5 columns: log2lamda,error,exit_flag,#iteration,minimum
    lamda_error(:,1) = log2lamda;
    
    % generate A matrix
    data1 = [train(:,1), repmat(train_data, 1, 2*k), ones(row_train,d1+row_train)];
    data1_data = data1(:,2:end);
    A_1 = []; % A[(k-1)*row_train,2*k*d+row_train] 
    for i = 1:row_train
      label = data1(i,1);
      for j = 1:k 
        if label==j
        else
            temp = zeros(1,2*k*d+d1+row_train);
            temp(1,(j-1)*d+1:j*d) = 1;
            temp(1,(k+j-1)*d+1:(k+j)*d) = -1;
            temp(1,(label-1)*d+1:label*d) = -1;
            temp(1,(k+label-1)*d+1:(k+label)*d) = 1;
            temp(1,2*k*d+d1+i) = -1;
            A_1 = [A_1; data1_data(i,:).*temp];
        end
      end
    end    
    A_1 = sparse(A_1);
    b_1 = ones(row_train*(k-1), 1)*(-1);

    % all abs(beta) less than ita

    diag_vec = [zeros(1,1);ones(d1,1)];
    diag_vec = repmat(diag_vec,k,1);
    diag_matrix = diag(diag_vec);
    diag_matrix2 = [];
    for i = 1:k
        diag_matrix2 = [diag_matrix2;diag_matrix(((i-1)*d+2):i*d,:)];
    end
    temp = repmat(diag_matrix2,1,2);
    diag_vec2 = ones(d1,1)*(-1);
    temp2 = diag(diag_vec2);
    temp3 = repmat(temp2,k,1);
    A_2 = [temp,temp3,zeros(k*d1,row_train)];
    b_2 = zeros(k*d1,1);
    
    A = [A_1;A_2];
    b = [b_1;b_2];
    
    % sum to zeros constraints
    diag_vec = ones(d,1);
    temp = diag(diag_vec);
    temp2 = diag(diag_vec*(-1));
    Aeq = [repmat(temp,1,k),repmat(temp2,1,k),zeros(d,d1+row_train)];
    beq = zeros(d,1);
    
    % generate other vectors      
    lb = zeros(2*k*d+d1+row_train,1);
    ub = [];
    xstart = [];    
        
    for i = 1:num_lamda
        
        f = [zeros(2*k*d,1);ones(d1,1)*my_lamda(i,1); ones(row_train,1)];

        [x,fvalue,exitflag,output] = linprog(f,A,b,Aeq,beq,lb);

        beta_all(:,i) = [log2lamda(i,1);x;fvalue];
        beta = x(1:k*d) - x(k*d+1:2*k*d);
        beta_final(:,i) = [log2lamda(i,1);beta];

        lamda_error(i,3) = exitflag;
        lamda_error(i,4) = output.iterations;
                
        % testing on the tune data set
        [fval,test_error] = test(beta,test_in);               
        lamda_error(i,2) = test_error;

    end

    if num_lamda == 1
        fval_out = fval;
    else
        fval_out = [];
    end    
