% This is the real data

global k;
global d;
global d1;

k = 4;
num_cv = 1; % the outer cross-validation to calculate the cross-validation error
num_cv2 = 5; % the inner cross-validation to tune the optimal regularization paramter, lambda. 

[row_mtrain_all,col_mtrain_all] = size(mtrain_all);
d = col_mtrain_all - 1;
d1 = d-1;
num_train = row_mtrain_all;

mlog2lamda = [10:-1:-10]';
mnum_lamda = length(mlog2lamda);
mlamda = power(2,mlog2lamda);

min_table = [];  
lamda_iterate = [];  
lamda_table = [];
beta_final_iterate = [];

for cv = 1:num_cv

    cv

[mtrain_set,mtune_set,mtrain_set_last,mtune_set_last] = cv_data(mtrain_all,num_cv2,cv+101);

for cv2 = 1:num_cv2
    
    cv2

        if cv2 < num_cv2
            mtrain = mtrain_set(:,:,cv2);
            mtune = mtune_set(:,:,cv2);
        else
            mtrain = mtrain_set_last;
            mtune = mtune_set_last;
        end   
            
        [mbeta_final, mlamda_error] = supnorm(mtrain,mtune,mlog2lamda);
        beta_final_iterate(:,:,cv2,cv) = mbeta_final;
        lamda_iterate(:,:,cv2,cv) = mlamda_error;
               
    end

    lamda_table(:,1,cv) = mlog2lamda;
    for q = 1:mnum_lamda
        lamda_table(q,2,cv) = mean(lamda_iterate(q,2,:,cv));
    end

    [Y,index] = min(lamda_table(:,2,cv));
    lamda_table(:,3,cv) = 0;
    lamda_table(index,3,cv) = 1;
    cv_error = Y;
      
    [mbeta_final_tune, mlamda_error_tune] = supnorm(mtrain_all,mtrain_all,mlog2lamda(index,1));
    min_table_tune(:,cv) = [cv; mlog2lamda(index,1); mlamda(index,1); cv_error; mlamda_error_tune(3); mbeta_final_tune(2:end)];

    [mbeta_final_test, mlamda_error_test, mfval_test] = supnorm(mtrain_all,mtest,mlog2lamda(index,1));      
    min_table_test(:,cv) = [cv; mlog2lamda(index,1); mlamda(index,1); mlamda_error_test(2); mlamda_error_test(3); mbeta_final_test(2:end)];
    mfval_test_final(:,:,cv) = mfval_test;

end

       
for cv = 1:num_cv

    min_table_tune2 = min_table_tune(5+1:5+k*d, cv); % for counting, only use beta final part in min_table[k*d,num_lamda]
% Count selected frequence and model size
    [count_separate,count_together,count_flag_separate,frequency_separate,frequency_together] = count_modelsize(min_table_tune2,1);
    mean_frequency_separate = mean(frequency_separate);
    std_frequency_separate = std(frequency_separate);
    mean_frequency_together = mean(frequency_together);
    std_frequency_together = std(frequency_together);
% average predict error
    pred_error_vec = min_table_tune(4,cv);
    mean_pred_error = mean(pred_error_vec);
    std_pred_error = std(pred_error_vec);
% average log2lamda value
    log2lamda_vec = min_table_tune(2,cv);
    mean_log2lamda = mean(log2lamda_vec);
    std_log2lamda = std(log2lamda_vec);

% SUMMARY TABLE
    summary_table_tune_temp = [mean_log2lamda,mean_pred_error,mean_frequency_together,k,d,num_train,cv,count_together',mean_frequency_separate];
               
    summary_table_tune(:,cv) = summary_table_tune_temp';
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% submit to cluster
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%dlmwrite('./output/Adapt_supnorm_realdata_tune_summary_table.txt', summary_table_tune, 'delimiter', '\t', 'precision', 6)
dlmwrite('./output/supnorm_tune_error_beta_lambda.txt', min_table_tune, 'delimiter', '\t', 'precision', 6)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% get summary table for all test data
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for cv = 1:num_cv

    min_table_test2 = min_table_test(5+1:5+k*d, cv); % for counting, only use beta final part in min_table[k*d,num_lamda]
    % Count selected frequence and model size
    [count_separate,count_together,count_flag_separate,frequency_separate,frequency_together] = count_modelsize(min_table_test2,1);
    mean_frequency_separate = mean(frequency_separate);
    std_frequency_separate = std(frequency_separate);
    mean_frequency_together = mean(frequency_together);
    std_frequency_together = std(frequency_together);
    % average predict error
    pred_error_vec = min_table_test(4,cv);
    mean_pred_error = mean(pred_error_vec);
    std_pred_error = std(pred_error_vec);
    % average log2lamda value
    log2lamda_vec = min_table_test(2,cv);
    mean_log2lamda = mean(log2lamda_vec);
    std_log2lamda = std(log2lamda_vec);

    % SUMMARY TABLE
    summary_table_test_temp = [mean_log2lamda,mean_pred_error,mean_frequency_together,k,d,num_train,num_cv,count_together',mean_frequency_separate];
 
    summary_table_test(:,cv) = summary_table_test_temp';
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% submit to cluster
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%dlmwrite('./output/Adapt_supnorm_realdata_test_summary_table.txt', summary_table_test, 'delimiter', '\t', 'precision', 6)
dlmwrite('./output/supnorm_test_error_beta_lambda.txt', min_table_test, 'delimiter', '\t', 'precision', 6)
dlmwrite('./output/supnorm_test_predictedClass.txt', mfval_test_final, 'delimiter', '\t', 'precision', 6)

disp('successful end of program')

