function [train_set,tune_set,train_set_last,tune_set_last] = cv_data(data_in,num_cv,seed)
    
% remmeber the row_data in train_data divide by num_cv should be an integer number.    

    train = data_in;
    train_data = train(:,2:end);
    [row_train,col_train] = size(train);
    row_train2 = ceil(row_train/num_cv);    
    
    train_set = [];
    tune_set = [];

    rand('state',seed)
    p = randperm(row_train);
    
    for i = 1:(num_cv-1)
        tune_set(:,:,i) = train(p((i-1)*row_train2+1:i*row_train2),:);
        if i == 1
            train_set(:,:,i) = train(p(i*row_train2+1:end),:);
        else
            train_set(:,:,i) = [train(p(1:(i-1)*row_train2),:);train(p(i*row_train2+1:end),:)];
        end
    end
    
    tune_set_last = train(p((num_cv-1)*row_train2+1:end),:);
    train_set_last = train(p(1:(num_cv-1)*row_train2),:);
    
