function [l1_beta_final,l1_lamda_error,fval_out] = Adapt_L1(train_in,test_in,log2lamda_in)

% Read in the training, tuning, testing and log2lamda data
% It works for k = 2 or 3 or 4 or 5

    global k;
    global d;
    global d1;
    
    % get input argument
    train = train_in;
    train_data = train(:,2:end);
    [row_train,col_train] = size(train_data);
    log2lamda = log2lamda_in;
    num_lamda = length(log2lamda);
    my_lamda = power(2,log2lamda);   

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % L2 initialization
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    % initialize output argument and others
    l2_beta_all = zeros(1+k*d+row_train+1,num_lamda);
    l2_beta_final = zeros(1+k*d,num_lamda);
    l2_lamda_error = zeros(num_lamda,5); % have 5 columns: log2lamda,error,exit_flag,#iterations,minimum
    l2_lamda_error(:,1) = log2lamda;
    
    % generate A matrix
    l2_data1 = [train(:,1), repmat(train_data, 1, k), ones(row_train,row_train)];
    l2_data1_data = l2_data1(:,2:end);
    l2_A = []; % A[k*row_train,k*d+row_train] 
    l2_b = []; % b[k*row_train,1]
    for i = 1:row_train
      label = l2_data1(i,1);
      for j = 1:k 
        if label==j
            temp = zeros(1,k*d+row_train);
            temp(1,k*d+i) = -1;
            l2_A = [l2_A; l2_data1_data(i,:).*temp];
            l2_b = [l2_b;0];
        else
            temp = zeros(1,k*d+row_train);
            temp(1,(j-1)*d+1:j*d) = 1;
            temp(1,(label-1)*d+1:label*d) = -1;
            temp(1,k*d+i) = -1;
            l2_A = [l2_A; l2_data1_data(i,:).*temp];
            l2_b = [l2_b;-1];
        end
      end
    end    
    l2_A = sparse(l2_A);
    
    % sum to zeros constraints

    diag_vec = ones(d,1);
    temp = diag(diag_vec);
    l2_Aeq = [repmat(temp,1,k),zeros(d,row_train)];
    l2_beq = zeros(d,1);

    %%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%  
    l2_A = [l2_A;l2_Aeq];
    l2_b_U = [l2_b;l2_beq];
    temp = -inf;
    l2_b2 = repmat(temp,size(l2_b));
    l2_b_L = [l2_b2;l2_beq];
    %%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%%%
    
        
    % generate other vectors      
    l2_lb = [];
    l2_ub = [];
    l2_xstart = [];    

    l2_options = optimset('LargeScale','off','display','on','MaxIter',10000);

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % L1 norm initialization
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    l1_beta_all = zeros(1+2*k*d+row_train+1,num_lamda);
    l1_beta_final = zeros(1+k*d,num_lamda);
    l1_lamda_error = zeros(num_lamda,5); % have 5 columns: log2lamda,error,exit_flag,#iteration,minimum
    l1_lamda_error(:,1) = log2lamda;
    
    % generate A matrix
    l1_data1 = [train(:,1), repmat(train_data, 1, 2*k), ones(row_train,row_train)];
    l1_data1_data = l1_data1(:,2:end);
    l1_A = []; % A[(k-1)*row_train,2*k*d+row_train] 
    for i = 1:row_train
      label = l1_data1(i,1);
      for j = 1:k 
        if label==j
        else
            temp = zeros(1,2*k*d+row_train);
            temp(1,(j-1)*d+1:j*d) = 1;
            temp(1,(k+j-1)*d+1:(k+j)*d) = -1;
            temp(1,(label-1)*d+1:label*d) = -1;
            temp(1,(k+label-1)*d+1:(k+label)*d) = 1;
            temp(1,2*k*d+i) = -1;
            l1_A = [l1_A; l1_data1_data(i,:).*temp];
        end
      end
    end    
    l1_A = sparse(l1_A);
    
    % sum to zeros constraints
    diag_vec = ones(d,1);
    temp = diag(diag_vec);
    temp2 = diag(diag_vec*(-1));
    l1_Aeq = [repmat(temp,1,k),repmat(temp2,1,k),zeros(d,row_train)];
    l1_beq = zeros(d,1);

    % generate other vectors      
    l1_b = ones(row_train*(k-1), 1)*(-1);
    l1_lb = zeros(2*k*d+row_train,1);
    l1_ub = [];
    l1_xstart = [];    
    
    for i = 1:num_lamda
        
        pre_H = [zeros(1,1);ones(d1,1)];
        diag_vec = [repmat(pre_H,k,1);zeros(row_train,1)]*my_lamda(i,1);

        l2_H = diag(diag_vec);
        l2_H = sparse(l2_H); % H[k*d+row_train,k*d+row_train] diagonal matrix       
        l2_f = [zeros(k*d,1);ones(row_train,1)];
        
       %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
       %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        Name = 'qpQG'; % Problem name, not required.

        Prob = qpAssign(l2_H,l2_f, l2_A, l2_b_L, l2_b_U, l2_lb, [], []);

         Result = tomRun('sqopt', Prob, 0);

        l2_x = Result.x_k;
        l2_fvalue = Result.f_k;
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                
        l2_beta_all(:,i) = [log2lamda(i,1);l2_x;l2_fvalue];
        l2_beta = l2_x(1:k*d);
        l2_beta_final(:,i) = [log2lamda(i,1);l2_beta];
        lamda_error(i,3) = Result.ExitFlag;
        lamda_error(i,4) = Result.Iter;
        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %end of l2 norm
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   
        temp = [l2_x(1:k*d);l2_x(1:k*d)];
        for j = 1:length(temp)
            if temp(j)==0
                temp(j) = 0.0001;
            end
        end

        temp2 = 1./abs(temp);

        l1_f_pre1 = [temp2*my_lamda(i,1); ones(row_train,1)];       
        pre_f = [zeros(1,1);ones(d1,1)];
        l1_f_pre2 = [repmat(pre_f,2*k,1);ones(row_train,1)];
        l1_f = l1_f_pre2.*l1_f_pre1;
        
        [l1_x,l1_fvalue,l1_exitflag,l1_output] = linprog(l1_f,l1_A,l1_b,l1_Aeq,l1_beq,l1_lb);

        l1_beta_all(:,i) = [log2lamda(i,1);l1_x;l1_fvalue];
        l1_beta = l1_x(1:k*d) - l1_x(k*d+1:2*k*d);
        l1_beta_final(:,i) = [log2lamda(i,1);l1_beta];

        l1_lamda_error(i,3) = l1_exitflag;
        l1_lamda_error(i,4) = l1_output.iterations;
        
           
        % testing on the tune data set
        [fval,tune_error] = test(l1_beta,test_in);               
        l1_lamda_error(i,2) = tune_error;

    end

    if num_lamda == 1
        fval_out = fval;
    else
        fval_out = [];
    end

