/*
JMP Genomics Analytical Process 

Name: DataCorrelation
Authors: John Bander and Russ Wolfinger, SAS Institute Inc.
Support: Tzu-Ming Chu, SAS Institute Inc.
History:
   sasjab 01Aug03 initial coding
   sasrdw 10Mar04 refinement
   sasrdw 21May05 added PCA

Description: 
This process computes correlations between 
numeric variables.  The default type is
standard Pearson product-moment correlations, 
but you may optionally specify Hoeffding D, 
Kendall tau-b, or Spearman rank-order correlations.
*/

/*
-----------------------------------------------------------
Copyright (C) 2004 SAS Institute, Inc. All rights reserved. 

Notice: 
The above copyright notice and this notice must appear in
any whole or partial copy of this code and any related
documentation. Permission to use, copy, and modify the
source code contained in this file is hereby granted, but
is limited to customers of SAS with a valid license for the
SAS software product with which this file was provided. 
Except as expressly set forth herein, the terms of such
license apply.
-----------------------------------------------------------
*/

*ProcessVariables;


%let InData=%nrbquote(N:\Pierres_Extranal_drive_files\Publications_old\Publications\Book_Chapters\Variance_Component_PCA\Data\ge_data_transformed_mvi.sas7bdat); #Data matrix
%let Variables= ;
%let WithVars= ;
%let ExpInData=%nrbquote(N:\Pierres_Extranal_drive_files\Publications_old\Publications\Book_Chapters\Variance_Component_PCA\Data\expinfo.sas7bdat); #experimental design
%let ColorVars= ;
%let ExpLabelVar= ;
%let OutPath=%nrbquote(N:\Pierres_Extranal_drive_files\Publications_old\Publications\Book_Chapters\Variance_Component_PCA\Data\);
%let MacroPath= D:\Program Files\SAS\JMP7\Genomics\MacroLib;
%let CenterRows= Yes;
%let ScaleRows= No;
%let OutType= Pearson;
%let NFactors= 3;
%let ClassVars= Time Treatment Batch;
%let RandomEffects=%nrbquote(time|treatment|batch);
%let FixedEffects=%nrbquote();
%let VCFirstPC= 1;
%let VCLastPC= 3;
%let VCListAll= Yes;
%let ProcCorrOptions= ;
%let DataCorrelation_OutData=%nrbquote();
%let DataCorrelation_OutDataEig=%nrbquote();
%let DataCorrelationScript=%nrbquote();
%let VCOutFile=%nrbquote();
%let VCTitle1=%nrbquote();
%let GENOMICS_HOME=%nrbquote(D:\Program Files\SAS\JMP7\Genomics\);
%let USER_HOME=%nrbquote(C:\Documents and Settings\bushel\Local Settings\Application Data\);

*ProcessBody;

%include "D:\Program Files\SAS\JMP7\Genomics\ProcessLibrary\DataCorrelation.sas"; 
