\name{pvacFilter}
\alias{pvacFilter}
\title{
  Filter genes by the proportion of variation accounted for by the first
  principal component (PVAC)
}
\description{
  Compute the PVAC scores, derive a filtering threshold value, and
  return the probesets that have passed the filter
}
\usage{
  pvacFilter(abatch, pct=0.99)
}
\arguments{
  \item{abatch}{an instance of
    \code{\link[affy:AffyBatch-class]{AffyBatch}} from the function call \code{\link[affy]{ReadAffy}}
  }
  \item{pct}{the percentile value of the emperical distribution of PVAC
    scores of a set of ``non-expressed'' genes. Used to select the
    filtering threshold. The default value is 0.99.
  }

}
\value{
A list with the following components,

  \item{aset }{Names of the probesets that have passed the filter}
  \item{nullset }{Names of the presumably ``non-expressed'' probesets
    (those with absent calls across all the study samples)}
  \item{pvac }{A named vector containing the PVAC scores}
  \item{cutoff }{The PVAC cutoff value. The maximum is set to 0.5 (which
  corresponds to 50\% of variation of the total variation)}

}
\author{
Jun Lu
}
\examples{
  library(affy)
  library(pvacExampleData)
  data(pvacExampleData)
  res = pvacFilter(pvacExampleData)
  res$aset  # names of probesets that have passed the filter
}
\keyword{ filter }

