\name{formatPed}
\alias{formatPed}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
%%  ~~function to do ... ~~
Format .ped data for PIX-LRT
}
\description{
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
\code{formatPed()} will format a pedigree file to be read into \code{\link{PIX}()}. Output is a matrix where the first, second and third columns are the number of minor allele copies in the mother, father and offspring, respectively. The fourth column is the sex of the offspring. Only the first SNP will be read within a file. Only one case offspring from a family will be kept.
}
\usage{
formatPed(pedFile)
}
\arguments{
  \item{pedFile}{
A .ped file. In the current verion, this file should contain only trios (mother, father and case). If other pedigree formats are input, \code{formatPed()} will not work properly. The format of the .ped file which is read into \code{formatPed()} must have 8 or more columns, please see details about specifics.
}
}
\details{
For the pedigree file, the columns must be organized as follows (refer to \code{data(test_famX.ped)} for an example):

\enumerate{
\item Family ID
\item Individual ID
\item Father's individual ID
\item Mother's individual ID	
\item Sex (1 = male, 2 = female) 
\item Phenotype status (0 = not a case)
\item Allele 1 (0 = NA, 1 = major allele, 2 = minor allele)	
\item Allele 2 (0 = NA, 1 = major allele, 2 = minor allele)
}

Any additional columns will be ignored.  Furthermore, cases must have non-zero (and non-missing) values for both column 3 and 4, even if genotype data are missing for that parent, otherwise, that case's information will not be used. The EM algorithm in \code{PIX()} will trios with missing parental genotypes to be used.
}
\value{
A matrix.
}
\references{
%% ~put references to the literature/web site here ~
Wise, A., Shi, M., Weinberg, CR. PIX-LRT: A Parent-Informed Test for SNPs on the X Chromosome Using Case-Parent Triads. TBD
}
\author{
%%  ~~who you are~~
Alison S. Wise
}

\examples{
## the dataset test_famX.ped is in a pedigree format.  
data(test_famX.ped)

##to format the data to be read into PIX the code can be run as follows:
formattedPed = formatPed(test_famX.ped)
output = PIX(formattedPed)
}

