\name{PIX}
\alias{PIX}
\title{
PIX-LRT
}
\description{
\code{PIX()} performs the parent-informed X chromosome likelihood ratio test for a SNP in case-parent triad data for a dichotomous trait. Output include relative risks and LRT statistics.
}
\usage{
PIX(dataMatrix, EM.use = TRUE, method = "pix")
}
\arguments{
  \item{dataMatrix}{
This is a matrix with four columns.  The columns 1-3 refer to the number of non-reference allele copies in the mother (0,1 or 2), father (0 or 1), and case (0,1 or 2 for daughters and 0 or 1 for sons), respectively. Column four refers to the sex of offspring (1 = male, 2 = female).
}
  \item{EM.use}{
A logical arguement. TRUE if missing data is to be used, in which case the EM algorithm is applied.  FALSE if only complete data is used.  In \code{method = "ssx"}, the code recognized that fathers of affected sons are non-informative (see reference), so complete data need only be the mother and son genotype.
}
  \item{method}{
\code{method = "pix"} results in analysis with the parent-infomed X-LRT.  \code{method = "ssx"}  results in analysis with the sex-stratified X-LRT (SSX-LRT).}

}
\details{
In the coded PIX-LRT, families with affected sons and daughters are analyzed seperately to remove bias and to allow a serepate risks among males and females.  PIX-LRT creates a composite chi-square test statistic from the from the  seperate test statistics calculated from families with with affected sons and daughters. SSX-LRT uses transmission from parents and creates a composite, as does PIX, however, it does not exploit the distribution of genotyoes in the parents. See reference for more details.

In its current form, \code{PIX} estimates a log additive relative risk for daughters and a relative risk for a single copy for sons.

\code{\link{formatPed}()} can be used to convert a .ped file into the \code{dataMatrix} format.
}
\value{
\item{RRboys}{The relative risk of of the outcome for boys with 1 vs 0 copies of the minor allele.}

\item{LRTboys}{The 1 df likelihood ratio test statistic for boys}

\item{PBoys}{The asymptotic-based p-value based on the one degree-of-freedom chi-squared test of \code{LRTboys}.}

\item{RR1girls}{The relative risk of the outcome for girls with 1 vs 0 copies of the minor allele.}

\item{RR2girls}{The relative risk of the outcome for girls with 2 vs 0 copies of the minor allele.}

\item{LRTgirls}{The 1 df likelihood ratio test statistic for girls. This is under a log additive model for RR.}

\item{Pgirls}{The asymptotic-based p-value based on the one degree-of-freedom chi-squared test of \code{LRTgirls}}
	
\item{CompLRT}{The composite 1 df LRT statistic formed from the two chi-squared statistics above (see reference).}

\item{Pcomp}{The asymptotic-based p-value based on the one degree-of-freedom chi-squared test of \code{CompLRT}}

}
\references{
Wise, A., Shi, M., Weinberg, CR. PIX-LRT: A Parent-Informed Test for SNPs on the X Chromosome Using Case-Parent Triads. TBD
}
\author{
Alison S. Wise
}

\examples{
## the dataset test_famX.ped is in a pedigree format.  
data(test_famX.ped)

##to format the data to be read into PIX the code can be run as follows:
formattedPed = formatPed(test_famX.ped)
output = PIX(formattedPed)
}

