formatPed <-
function(pedFile){
	pedFile[pedFile[,7]==0,c(7,8)]<-NA
	orderFam = pedFile[order(pedFile[,1]),1:8]
	orderFam[,7] = as.numeric(orderFam[,7])
	orderFam[,8] = as.numeric(orderFam[,8])
	casesID = intersect(which(orderFam[,4]!=0), which(orderFam[,3]!=0))
	caseFams = orderFam[casesID,1]
	dups = duplicated(caseFams)
	justUnique = which(dups==FALSE)
	cases = orderFam[casesID[justUnique],]
	
	momsID = cases[,c(1,4)]
	colnames(momsID)<-c("fam", "id")
	moms = merge(momsID, orderFam, by.x=c("fam","id"), by.y = c("V1","V2"), all.x = TRUE)	
	
	dadsID = cases[,c(1,3)]
	colnames(dadsID)<-c("fam", "id")
	dads = merge(dadsID, orderFam, by.x=c("fam","id"), by.y = c("V1","V2"), all.x = TRUE)	

	orderCases = cases[order(cases[,1]),1:8]
	orderMoms = moms[order(moms[,1]),1:8]
	orderDads = dads[order(dads[,1]),1:8]
	
	sex = orderCases[,5]
	caseSNP = orderCases[,7]+orderCases[,8]-2
	caseSNP[caseSNP==(-2)]=NA
	caseSNP[sex=="1"]=caseSNP[sex=="1"]/2
	momSNP = orderMoms[,7]+orderMoms[,8]-2
	momSNP[momSNP==(-2)]=NA
	dadSNP = (orderDads[,7]+orderDads[,8]-2)/2
	dadSNP[dadSNP==(-2)]=NA
	
	dataMatrix=cbind(momSNP, dadSNP, caseSNP, sex)
	return(dataMatrix)
}
