PIX <-
function(dataMatrix, EM.use=TRUE, method="pix"){
	mom = dataMatrix[,1]
	dad = dataMatrix[,2]
	case = dataMatrix[,3]
	sex = dataMatrix[,4]
	
	boy = which(sex ==1)
	outputBoys = rep(NA, 3)
	if(length(boy)>=1){
		momb = mom[boy]
		dadb = dad[boy]
		caseb = case[boy]		
		if(method=="SSX"||method=="ssx"){
			outputBoys = SSXboys.function(momb, dadb, caseb, EM.use)
		}else{
			outputBoys = PIXboys.function(momb, dadb, caseb, EM.use)
		}
	}
	
	girl = which(sex ==2)
	outputGirls = rep(NA, 3)
	if(length(girl)>=1){
		momg = mom[girl]
		dadg = dad[girl]
		caseg = case[girl]		
		if(method=="SSX"||method=="ssx"){
			outputGirls = SSXgirls.function(momg, dadg, caseg, EM.use)
		}else{
			outputGirls = PIXgirls.function(momg, dadg, caseg, EM.use)
		}
	}

	comp = NA
	if(is.na(outputGirls[1])==FALSE && is.na(outputBoys[1])==FALSE){
		signB = sign(log(outputBoys[1]))
		signG	 = sign(log(outputGirls[1]))	
		comp = (sqrt(outputGirls[3]*outputGirls[2])*signG+
		sqrt(outputBoys[3]*outputBoys[2])*signB)^2/(outputBoys[3]+outputGirls[3])
	}	
	list(RRboys = outputBoys[1],
		LRTboys = outputBoys[2],
		Pboys = 1-pchisq(outputBoys[2],1),
		RR1girls = outputGirls[1],
		RR2girls = outputGirls[1]^2,
		LRTgirls = outputGirls[2],
		Pgirls = 1-pchisq(outputGirls[2],1),
		CompLRT = comp,
		Pcomp = 1-pchisq(comp,1))
		
}
