
#  Usage:
#  build human RefGene transcript database:  Rscript buildTranscriptDB_fixed.R refGene txdb.mm9.refGene.sqlite
# or  Rscript buildTranscriptDB_fixed.R  refGene txdb.mm9.refGene.sqlite mm9

#  build human Ensembl transcript database:  Rscript buildTranscriptDB_fixed.R ensembl txdb.ensembl.sqlite mm9

#or R CMD BATCH "--args refGene txdb.mm9.refGene.sqlite mm9
#   " buildTranscriptDB_fixed.R &


args <- commandArgs(TRUE)

refGene.genome.build = ifelse(length(args)==3, args[3], 'mm9')

#refGene.genome.build <- 'mm9'
library(GenomicFeatures)

if(tolower(args[3])=="hg19"){
  myDataSet <- 'hsapiens_gene_ensembl'
}

if(tolower(args[3])=="mm9"){
  myDataSet <- 'mmusculus_gene_ensembl'
}

if(tolower(args[3])=="rn4"){
  myDataSet <- 'rnorvegicus_gene_ensembl'
}


if(tolower(args[1])=="refgene"){
  txdb <- makeTranscriptDbFromUCSC(genome = refGene.genome.build,
                                   tablename = "refGene")
}

if(tolower(args[1])=="ensembl"){
  txdb <- makeTranscriptDbFromBiomart(biomart="ensembl", dataset=myDataSet,
                                      transcript_ids=NULL)
}
saveFeatures(txdb, file=args[2])


