/* --------------------
 * XYBarChartDemo2.java
 * --------------------
 * (C) Copyright 2003, 2004, by Object Refinery Limited.
 *
 */

package edu.ucla.stat.SOCR.chart.demo;

import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.ClusteredXYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.IntervalXYDataset;

import edu.ucla.stat.SOCR.chart.ChartGenerator_JTable;
import edu.ucla.stat.SOCR.chart.SuperIntervalXYChart_Time;
import edu.ucla.stat.SOCR.chart.data.DateParser;
import edu.ucla.stat.SOCR.chart.gui.SOCRXYSeriesLabelGenerator;

/**
 * A simple demonstration application showing how to create a bar chart with a date axis for the domain values.
 */
public class XYBarChartDemo2 extends SuperIntervalXYChart_Time implements PropertyChangeListener {

	public void doTest(){
		 JFreeChart chart;
		 ChartGenerator_JTable chartMaker = new ChartGenerator_JTable();
		 
		 resetChart();
		 showMessageDialog(chartTitle+" doTest get called!");
		
		 int no_series = (dataTable.getColumnCount()-2)/2;
		 int[][] pairs = new int[no_series][2];
		 for (int i=0; i<no_series; i++){
			 pairs[i][0] = i*2;    //column 1 stores value
			 pairs[i][1] = i*2+1;    //column 0 stores time
		 }
		 chart = chartMaker.getXYChart("Bar",chartTitle, "Category", "value", dataTable, no_series, pairs,"Day");	
		 chartPanel = new ChartPanel(chart, false); 
			
		 setChart();
	 }

    protected IntervalXYDataset createDataset(boolean isDemo) {
		if (isDemo){
        TimeSeries series1 = new TimeSeries("Series 1", Day.class);
        series1.add(new Day(1, 1, 2003), 54.3);
        series1.add(new Day(2, 1, 2003), 20.3);
        series1.add(new Day(3, 1, 2003), 43.4);
        series1.add(new Day(4, 1, 2003), -12.0);

        TimeSeries series2 = new TimeSeries("Series 2", Day.class);
        series2.add(new Day(1, 1, 2003), 8.0);
        series2.add(new Day(2, 1, 2003), 16.0);
        series2.add(new Day(3, 1, 2003), 21.0);
        series2.add(new Day(4, 1, 2003), 5.0);

        TimeSeriesCollection dataset = new TimeSeriesCollection();
        //dataset.setDomainIsPointsInTime(false);
        dataset.addSeries(series1);
        dataset.addSeries(series2);
        return dataset;
		}
		else {
			setArrayFromTable();
			String[][] x = new String[xyLength][independentVarLength] ;
			double[][] y = new double[xyLength][dependentVarLength];


			for (int index=0; index<independentVarLength; index++)
				for (int i = 0; i < xyLength; i++) 
					x[i][index] = indepValues[i][index];
		   
			for (int index=0; index<dependentVarLength; index++)
				for (int i = 0; i < xyLength; i++) 
					y[i][index] = Double.parseDouble(depValues[i][index]);

			// create the dataset... 
			TimeSeriesCollection collection = new TimeSeriesCollection();
			TimeSeries series;
		
			for (int ind =0; ind<independentVarLength; ind++){
				int start_ind   = independentHeaders[ind].lastIndexOf(":");
				if 	(start_ind< 0)
					start_ind =0;
				
				String serieName = independentHeaders[ind].substring(0, start_ind);
				if (serieName.length()==0)
					serieName="Serie"+ind;
				
				series = new TimeSeries(serieName, Day.class);
				//TimeSeries("Executions", "Year", "Count", Year.class);

				for (int i=0; i<xyLength; i++){
					series.add(DateParser.parseDay(x[i][ind]), y[i][ind]);
				}	
				//collection.setDomainIsPointsInTime(false);
				collection.addSeries(series);
			}
            return collection;
		
		}
    }
    
    /** 
     * Creates a chart.
     * 
     * @param dataset  the dataset.
     * 
     * @return The chart.
     */
    protected  JFreeChart createChart(IntervalXYDataset dataset) {
        JFreeChart chart = ChartFactory.createXYBarChart(
           chartTitle,      // chart title
            "Date",                     // domain axis label
            true,
            "Y",                        // range axis label
            dataset,                    // data
            PlotOrientation.VERTICAL,
            true,                       // include legend
            true,
            false
        );

        // NOW DO SOME OPTIONAL CUSTOMISATION OF THE CHART...
        XYPlot plot = chart.getXYPlot();
        plot.setRenderer(new ClusteredXYBarRenderer());

		XYItemRenderer renderer = plot.getRenderer();
        renderer.setToolTipGenerator(
            new StandardXYToolTipGenerator(
                StandardXYToolTipGenerator.DEFAULT_TOOL_TIP_FORMAT,
                new SimpleDateFormat("d-MMM-yy"), new DecimalFormat("#,##0.00")
            )
        );
		renderer.setLegendItemLabelGenerator(new SOCRXYSeriesLabelGenerator());
        // OPTIONAL CUSTOMISATION COMPLETED.

		//setXSummary(dataset);  X is time
        return chart;        
    }
    
}
