/* ----------------------------
 * StackedXYAreaChartDemo2.java
 * ----------------------------
 * (C) Copyright 2005, by Object Refinery Limited.
 *
 */

package edu.ucla.stat.SOCR.chart.demo;

import java.beans.PropertyChangeListener;

import javax.swing.JOptionPane;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer2;
import org.jfree.data.xy.CategoryTableXYDataset;
import org.jfree.data.xy.TableXYDataset;

import edu.ucla.stat.SOCR.chart.ChartGenerator_JTable;
import edu.ucla.stat.SOCR.chart.SuperAreaChart_XY;
import edu.ucla.stat.SOCR.chart.gui.SOCRXYSeriesLabelGenerator;


/**
 * A demo showing a stacked area chart created with the 
 * <code>CategoryTableXYDataset</code>.
 */
public class StackedXYAreaChartDemo2 extends SuperAreaChart_XY implements PropertyChangeListener {

	public void doTest(){
		 JFreeChart chart;
		 ChartGenerator_JTable chartMaker = new ChartGenerator_JTable();
		 
		 resetChart();
		 showMessageDialog(chartTitle+" doTest get called!");
		
		 int no_series = (dataTable.getColumnCount()-2)/2;		 
		 int[][] pairs = new int[no_series][2];
		 for (int i=0; i<no_series; i++){
			 pairs[i][0] = 2*i;    //column x
			 pairs[i][1] = 2*i+1;    //column y
		 }
		 chart = chartMaker.getTableXYAreaChart("Area Chart", "X Vaue", "Y Value", dataTable, no_series, pairs, "");	
		 chartPanel = new ChartPanel(chart, false); 
			
		 setChart();
	 }
    
    /**
     * Creates a sample dataset.
     * 
     * @return a sample dataset.
     */
    protected TableXYDataset createDataset(boolean isDemo) {
		if (isDemo){
        CategoryTableXYDataset dataset = new CategoryTableXYDataset();
        dataset.add(0.0, 0.0, "Series 1");
        dataset.add(10.0, 20.0, "Series 1");
        dataset.add(20.0, 15.0, "Series 1");
        dataset.add(30.0, 25.0, "Series 1");
        dataset.add(40.0, 21.0, "Series 1");

        dataset.add(10.0, 9.0, "Series 2");
        dataset.add(20.0, -7.0, "Series 2");
        dataset.add(30.0, 15.0, "Series 2");
        dataset.add(40.0, 11.0, "Series 2");
        dataset.add(45.0, -10.0, "Series 2");  // no matching value in series 1
        dataset.add(50.0, 0.0, "Series 2");  // likewise
        return dataset;}
		else
			{
				
			setArrayFromTable();
			
			if (independentVarLength != dependentVarLength){
			JOptionPane.showMessageDialog(this, "The number of X and Y doesn't match!");
			resetChart();
			return null;
			}

			String[][] x= new String[xyLength][independentVarLength];
			double[][] y= new double[xyLength][dependentVarLength];

			for (int index=0; index<independentVarLength; index++)
				for (int i = 0; i < xyLength; i++)
					x[i][index] = indepValues[i][index];
			   
		   
			for (int index=0; index<dependentVarLength; index++)
				for (int i = 0; i < xyLength; i++) {
					if (depValues[i][index]=="null")
						y[i][index]=0.0;
					else  y[i][index] = Double.parseDouble(depValues[i][index]);
				}

			// create the dataset... 
			CategoryTableXYDataset dataset = new CategoryTableXYDataset();

			for (int i=0; i<independentVarLength; i++){
				for (int j=0; j<dataTable.getRowCount()-1; j++){
					dataset.add(Double.parseDouble(x[j][i]), y[j][i], independentHeaders[i]);
					//System.out.println("adding :("+x[j][i]+","+y[j][i]+","+independentHeaders[i]+")" );
				}
			}
		
            return dataset; 

			} 
    }
    
    /**
     * Creates a sample chart.
     * 
     * @param dataset  the dataset for the chart.
     * 
     * @return a sample chart.
     */
    protected JFreeChart createChart(TableXYDataset dataset) {

        JFreeChart chart = ChartFactory.createStackedXYAreaChart(
            chartTitle,  // chart title
            "X Value",                       // domain axis label
            "Y Value",                       // range axis label
            dataset,                         // data
            PlotOrientation.VERTICAL,        // the plot orientation
            true,                            // legend
            true,                            // tooltips
            false                            // urls
        );
        XYPlot plot = (XYPlot) chart.getPlot();
        StackedXYAreaRenderer2 renderer = new StackedXYAreaRenderer2(); 
        renderer.setToolTipGenerator(new StandardXYToolTipGenerator());
        plot.setRenderer(0, renderer);    

		renderer.setLegendItemLabelGenerator(new SOCRXYSeriesLabelGenerator()); 
		setXSummary(dataset);   
        return chart;
        
    }

}
