/* -------------------
 * LineChartDemo2.java
 * -------------------
 * (C) Copyright 2002-2005, by Object Refinery Limited.
 *
 */

package edu.ucla.stat.SOCR.chart.demo;

import java.awt.Color;
import java.lang.Math;
import java.beans.PropertyChangeListener;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleInsets;

import edu.ucla.stat.SOCR.chart.SuperXYChart_QQ;
import edu.ucla.stat.SOCR.chart.gui.SOCRXYSeriesLabelGenerator;

/**
 * A simple demonstration application showing how to create a line chart using
 * data from an {@link XYDataset}.  
 *
 */
/*not used*/
public class QQChartDemo2 extends SuperXYChart_QQ implements PropertyChangeListener {

	boolean is_dd;

     /**
     * Creates a sample dataset.
     * 
     * @return a sample dataset.
     */
    protected XYDataset createDataset(boolean isDemo) {

        if (isDemo){
			is_dd = true;	
			//is_lm =false;

			row_count = 10;
			raw_x= new String[row_count];
			raw_y= new String[row_count];

			
			raw_x[0]="95"; raw_x[1]="104";raw_x[2]="99";raw_x[3]="102";raw_x[4]="95";
			raw_x[5]="106"; raw_x[6]="100";raw_x[7]="108";raw_x[8]="104";raw_x[9]="97";

			raw_y[0]="97"; raw_y[1]="98";raw_y[2]="92";raw_y[3]="94";raw_y[4]="93";
			raw_y[5]="106"; raw_y[6]="94";raw_y[7]="109";raw_y[8]="102";raw_y[9]="96";
			
			//do_dd();

			XYSeries series1 = new XYSeries("QQ");
			for (int i=0; i<row_count; i++){
				System.out.println("i="+i+" x="+normalQuantiles[i]+" y="+stdResiduals[i]);
				series1.add(normalQuantiles[i], stdResiduals[i]);}
    
			XYSeries series2 = new XYSeries("Reference Line");
			min_x = Math.min(normalQuantiles[0], stdResiduals[0]);
			min_x = min_x-0.125;
			max_x = Math.max (normalQuantiles[9],stdResiduals[9]);
			max_x = max_x+0.125;
			series2.add(min_x,min_x);
			series2.add(max_x,max_x);

			XYSeriesCollection dataset = new XYSeriesCollection();
			dataset.addSeries(series1);
			dataset.addSeries(series2);
                
			return dataset;}
		else return super.createDataset(false);
        
    }
    
    /**
     * Creates a chart.
     * 
     * @param dataset  the data for the chart.
     * 
     * @return a chart.
     */
    protected JFreeChart createChart(XYDataset dataset) {
        
        // create the chart...
        JFreeChart chart = ChartFactory.createXYLineChart(
            "Data vs Data Q-Q plot",      // chart title
            "Group 1",                      // x axis label
            "Group 2",                      // y axis label
            dataset,                  // data
            PlotOrientation.VERTICAL,
            true,                     // include legend
            true,                     // tooltips
            false                     // urls
        );

        // NOW DO SOME OPTIONAL CUSTOMISATION OF THE CHART...
        chart.setBackgroundPaint(Color.white);
        
       // get a reference to the plot for further customisation...
        XYPlot plot = (XYPlot) chart.getPlot();
        plot.setBackgroundPaint(Color.white);
		plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setDomainGridlinePaint(Color.lightGray);
        plot.setRangeGridlinePaint(Color.lightGray);
        
        XYLineAndShapeRenderer renderer 
            = (XYLineAndShapeRenderer) plot.getRenderer();
		// renderer.setShapesVisible(true);
		renderer.setShapesFilled(true);
		//  renderer.setLinesVisible(false);
		renderer.setSeriesLinesVisible(1, true);
        renderer.setSeriesShapesVisible(1, false);
        renderer.setSeriesLinesVisible(0, false);
        renderer.setSeriesShapesVisible(0, true);
       
		//renderer.setLegendItemLabelGenerator(new SOCRXYSeriesLabelGenerator());

        // change the auto tick unit selection to integer units only...
        NumberAxis rangeAxis = (NumberAxis) plot.getRangeAxis();
        rangeAxis.setAutoRangeIncludesZero(false);
        rangeAxis.setUpperMargin(0);
        rangeAxis.setLowerMargin(0);

		// rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        NumberAxis domainAxis = (NumberAxis) plot.getDomainAxis();
        domainAxis.setAutoRangeIncludesZero(false);
        domainAxis.setUpperMargin(0);
        domainAxis.setLowerMargin(0);

		// domainAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());

        // OPTIONAL CUSTOMISATION COMPLETED.
		setQQSummary(dataset);     
        return chart;
        
    }

}
