/* -------------------
 * LineChartDemo2.java
 * -------------------
 * (C) Copyright 2002-2005, by Object Refinery Limited.
 *
 */

package edu.ucla.stat.SOCR.chart.demo;

import java.awt.Color;
import java.lang.Math;
import java.beans.PropertyChangeListener;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleInsets;

import edu.ucla.stat.SOCR.chart.SuperXYChart_QQ;
import edu.ucla.stat.SOCR.chart.gui.SOCRXYSeriesLabelGenerator;

/**
 * A simple demonstration application showing how to create a line chart using
 * data from an {@link XYDataset}.  
 * 
 */

/*not used*/
public class QQChartDemo1 extends SuperXYChart_QQ implements PropertyChangeListener {

     /**
     * Creates a sample dataset.
     * 
     * @return a sample dataset.
     */
    protected XYDataset createDataset(boolean isDemo) {
        if (isDemo){
			//is_dd = false; // not a data_to_data QQ plot
			//is_lm = true;

			row_count = 10;
			raw_x= new String[row_count];
			raw_y= new String[row_count];

			raw_x[0]="1.0"; raw_x[1]="1.0";raw_x[2]="1.0";raw_x[3]="1.0";raw_x[4]="1.0";
			raw_x[5]="2.0"; raw_x[6]="2.0";raw_x[7]="2.0";raw_x[8]="2.0";raw_x[9]="2.0";

			raw_y[0]="20.0"; raw_y[1]="30.0";raw_y[2]="40.0";raw_y[3]="30.0";raw_y[4]="50.0";
			raw_y[5]="20.0"; raw_y[6]="30.0";raw_y[7]="40.0";raw_y[8]="38.0";raw_y[9]="59.0";
			
			do_lm();

			XYSeries series1 = new XYSeries("QQ");
			for (int i=0; i<row_count; i++){
				//System.out.println("i="+i+" normalQ="+normalQuantiles[i]+" stdRes="+stdResiduals[i]);
				series1.add(normalQuantiles[i], stdResiduals[i]);}
    
			XYSeries series2 = new XYSeries("Reference Line");
			min_x = Math.min(normalQuantiles[0], stdResiduals[0]);
			min_x = min_x-0.125;
			max_x = Math.max (normalQuantiles[9],stdResiduals[9]);
			max_x = max_x+0.125;
			series2.add(min_x,min_x);
			series2.add(max_x,max_x);

			XYSeriesCollection dataset = new XYSeriesCollection();
			dataset.addSeries(series1);
			dataset.addSeries(series2);
                
			return dataset;}
		else return super.createDataset(false);
        
    }
    
    /**
     * Creates a chart.
     * 
     * @param dataset  the data for the chart.
     * 
     * @return a chart.
     */
    protected JFreeChart createChart(XYDataset dataset) {
        
        // create the chart...
        JFreeChart chart = ChartFactory.createXYLineChart(
            "Normal Q-Q plot",      // chart title
            "Theoretical Quantiles lm(y~x)",                      // x axis label
            "Standardized Residuals",                      // y axis label
            dataset,                  // data
            PlotOrientation.VERTICAL,
            true,                     // include legend
            true,                     // tooltips
            false                     // urls
        );

        // NOW DO SOME OPTIONAL CUSTOMISATION OF THE CHART...
        chart.setBackgroundPaint(Color.white);
        
       // get a reference to the plot for further customisation...
        XYPlot plot = (XYPlot) chart.getPlot();
        plot.setBackgroundPaint(Color.white);
		plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setDomainGridlinePaint(Color.lightGray);
        plot.setRangeGridlinePaint(Color.lightGray);
        
        XYLineAndShapeRenderer renderer 
            = (XYLineAndShapeRenderer) plot.getRenderer();
		// renderer.setShapesVisible(true);
		renderer.setShapesFilled(true);
		//  renderer.setLinesVisible(false);
		renderer.setSeriesLinesVisible(1, true);
        renderer.setSeriesShapesVisible(1, false);
        renderer.setSeriesLinesVisible(0, false);
        renderer.setSeriesShapesVisible(0, true);
       
		//renderer.setLegendItemLabelGenerator(new SOCRXYSeriesLabelGenerator());

        // change the auto tick unit selection to integer units only...
        NumberAxis rangeAxis = (NumberAxis) plot.getRangeAxis();
        rangeAxis.setAutoRangeIncludesZero(false);
        rangeAxis.setUpperMargin(0);
        rangeAxis.setLowerMargin(0);

		// rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        NumberAxis domainAxis = (NumberAxis) plot.getDomainAxis();
        domainAxis.setAutoRangeIncludesZero(false);
        domainAxis.setUpperMargin(0);
        domainAxis.setLowerMargin(0);

		// domainAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());

        // OPTIONAL CUSTOMISATION COMPLETED.
		setQQSummary(dataset);     
        return chart;
        
    }

}
