/* -------------------
 * LineChartDemo2.java
 * -------------------
 * (C) Copyright 2002-2005, by Object Refinery Limited.
 *
 */

package edu.ucla.stat.SOCR.chart.demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.util.Observable;
import java.util.Observer;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleInsets;

import edu.ucla.stat.SOCR.chart.ChartGenerator_JTable;
import edu.ucla.stat.SOCR.chart.SuperXYChart;
import edu.ucla.stat.SOCR.chart.gui.SOCRXYSeriesLabelGenerator;
import edu.ucla.stat.SOCR.util.EditableHeader;
import edu.ucla.stat.SOCR.util.ValueSliderFloat;  

/**
 * A simple demonstration application showing how to create a line chart using
 * data from an {@link XYDataset}.  
 * 
 */
public class PowerTransformXYScatterChart extends SuperXYChart implements PropertyChangeListener, ActionListener, Observer  {

	protected int row_count;
	protected String[] raw_x, raw_y;
	private double powerX=1.0, powerY=1.0;
	protected double[] transformed_x, transformed_y;
	protected double[] norm_x, norm_y;
	JPanel sliderPanel;
	ValueSliderFloat  powerXSlider, powerYSlider;

	
	public void init(){

		sliderPanel = new JPanel();
		// ValueSetter(String title, int type int min, int max, int initial,boolean minimumRange10) 
         powerXSlider = new ValueSliderFloat("PowerX", -10.0, 10.0, 1.0, true);	
         powerXSlider.setPreferredSize(new Dimension(CHART_SIZE_X/2+150,80));
         powerXSlider.addObserver(this);
         powerXSlider.setToolTipText("Slider for adjusting the value of power for the axis.");
         sliderPanel.add(this.powerXSlider);
		
         powerYSlider = new edu.ucla.stat.SOCR.util.ValueSliderFloat("PowerY", -10.0, 10.0, 1.0, true);	
         powerYSlider.setPreferredSize(new Dimension(CHART_SIZE_X/2+150,80));
         powerYSlider.addObserver(this);
         powerYSlider.setToolTipText("Slider for adjusting the value of power for the Y axis.");
         sliderPanel.add(this.powerYSlider);
		
         super.init();
     
		 toolBar = new JToolBar();
		 createActionComponents(toolBar);
		 JPanel toolBarContainer  = new JPanel();
		 toolBarContainer.add(toolBar);
		 JSplitPane	toolContainer = new JSplitPane(JSplitPane.VERTICAL_SPLIT, toolBarContainer, new JScrollPane(sliderPanel));
		 toolContainer.setContinuousLayout(true);
		 toolContainer.setDividerLocation(0.6);
		 this.getContentPane().add(toolContainer,BorderLayout.NORTH);
	}
	
	protected void createActionComponents(JToolBar toolBar){
		super.createActionComponents(toolBar);
		JButton button;
		
		/**************** wiki Tab ****************/
        Action linkAction = new AbstractAction(){
			public void actionPerformed(ActionEvent e){
			
		    		try {
		    			parentApplet.getAppletContext().showDocument(
		                        new java.net.URL("http://wiki.stat.ucla.edu/socr/index.php/SOCR_EduMaterials_Activities_PowerTransformFamily_Graphs"), 
		                			"SOCR: Power Transform Graphing Activity");
		               } catch (MalformedURLException Exc) {
		            	   JOptionPane.showMessageDialog(null, Exc,
		           				"MalformedURL Error",JOptionPane.ERROR_MESSAGE);
		                        Exc.printStackTrace();
		               }
		    	
			}
		};
	
		button = toolBar.add(linkAction);
       	button.setText(" WIKI_Activity ");
       	button.setToolTipText("Press this Button to go to SOCR_POWER_Activity wiki page");  
	}
	
	
	public void update(Observable arg0, Object arg1) {
		//	System.out.println("update called: power="+power+" slider="+this.powerSlider.getValue());
			if (this.powerX!=this.powerXSlider.getValue() || this.powerY!=this.powerYSlider.getValue()){
				setPowerX(this.powerXSlider.getValue());
				setPowerY(this.powerYSlider.getValue());
				redoChart();
			}
		}

	protected void redoChart(){
		XYDataset ds = applyPowerTransform(raw_x, raw_y, row_count);
		setTable(ds);
		JFreeChart chart = createChart(ds);	
		chartPanel = new ChartPanel(chart, false); 
		setChart();
	}
	
	protected void setChart(){
			// update graph

			graphPanel.removeAll();
			graphPanel.add(chartPanel);
			graphPanel.validate();

			// don't get the GRAPH panel to the front
			if (tabbedPanelContainer.getTitleAt(tabbedPanelContainer.getSelectedIndex())!=ALL) {
				//tabbedPanelContainer.setSelectedIndex(tabbedPanelContainer.indexOfComponent(graphPanel));
			}
			else {
				graphPanel2.removeAll();
				chartPanel.setPreferredSize(new Dimension(CHART_SIZE_X*2/3,CHART_SIZE_Y*2/3));
				graphPanel2.add(chartPanel);
				graphPanel2.validate();	
				summaryPanel.validate();
			}
	    }
	 

	protected void setTable(XYDataset ds){
			
		   convertor.Y2Table(raw_x, raw_y, transformed_x, transformed_y, row_count);			
			JTable tempDataTable = convertor.getTable();

			resetTableRows(tempDataTable.getRowCount()+1);
			resetTableColumns(tempDataTable.getColumnCount());
					
	     for(int i=0;i<tempDataTable.getColumnCount();i++) {
	         columnModel.getColumn(i).setHeaderValue(tempDataTable.getColumnName(i));
				//  System.out.println("updateExample tempDataTable["+i+"] = " +tempDataTable.getColumnName(i));
	         }

			columnModel = dataTable.getColumnModel();
			dataTable.setTableHeader(new EditableHeader(columnModel));

	     for(int i=0;i<tempDataTable.getRowCount();i++)
	         for(int j=0;j<tempDataTable.getColumnCount();j++) {
	             dataTable.setValueAt(tempDataTable.getValueAt(i,j),i,j);
			 }
	   
	       dataPanel.removeAll();
	       dataPanel.add(new JScrollPane(dataTable));
	       dataTable.setGridColor(Color.gray);
	       dataTable.setShowGrid(true);
	       dataTable.doLayout();
			// this is a fix for the BAD SGI Java VM - not up to date as of dec. 22, 2003
			try { 
				dataTable.setDragEnabled(true);  
			} catch (Exception e) {
			}

	        dataPanel.validate();
	     
	        // don't bring graph to the front
	        if (tabbedPanelContainer.getTitleAt(tabbedPanelContainer.getSelectedIndex())!=ALL) {
			//	tabbedPanelContainer.setSelectedIndex(tabbedPanelContainer.indexOfComponent(graphPanel));
	        }
	        else{
	        	dataPanel2.removeAll();
	        	dataPanel2.add(new JLabel(" "));
	    		dataPanel2.add(new JLabel("Data"));
	    		JScrollPane dt = new JScrollPane(dataTable);
	    		dt.setPreferredSize(new Dimension(CHART_SIZE_X/3, CHART_SIZE_Y*3/8));

	    		dataPanel2.add(dt);
	    		JScrollPane st = new JScrollPane(summaryPanel);
	    		st.setPreferredSize(new Dimension(CHART_SIZE_X/3,CHART_SIZE_Y/6));
	    		dataPanel2.add(st);
	    		st.validate();

	    		dataPanel2.add(new JLabel(" "));
	    		dataPanel2.add(new JLabel("Mapping"));
	    		mapPanel.setPreferredSize(new Dimension(CHART_SIZE_X/3, CHART_SIZE_Y/2));
	    		dataPanel2.add(mapPanel);

	    		dataPanel2.validate();
	        }
		}
	
     /**
     * Creates a sample dataset.
     * 
     * @return a sample dataset.
     */
    protected XYDataset createDataset(boolean isDemo) {
        if (isDemo){
        	row_count = 8;
        	
        	raw_x = new String[row_count];
        	raw_y = new String[row_count];
        	transformed_x = new double[row_count];
        	transformed_y = new double[row_count];
		
        	raw_x[0]= "1.0"; raw_x[1]= "2.0"; raw_x[2]= "3.0"; raw_x[3]= "4.0"; raw_x[4]= "5.0"; raw_x[5]= "6.0"; raw_x[6]= "7.0"; raw_x[7]= "8.0"; 
        	raw_y[0]= "1.0"; raw_y[1]= "4.0"; raw_y[2]= "3.0"; raw_y[3]= "5.0"; raw_y[4]= "5.0"; raw_y[5]= "7.0"; raw_y[6]= "7.0"; raw_y[7]= "8.0"; 
			reset_slider();
			XYDataset  dataset = applyPowerTransform(raw_x, raw_y, row_count);       
     
        return dataset;}		//else return super.createDataset(false);
        else {
        	setArrayFromTable();
        	
			row_count = xyLength;
			
			raw_x= new String[row_count];
			raw_y= new String[row_count];

			//only take first 2 columns
			independentVarLength =1;
			dependentVarLength =1;
			for (int index=0; index<independentVarLength; index++)
				for (int i = 0; i < xyLength; i++) {
					raw_x[i] = indepValues[i][index];
				}

			for (int index=0; index<dependentVarLength; index++)
				for (int i = 0; i < xyLength; i++)
					if (depValues[i][index]!="null") {
						raw_y[i] = depValues[i][index];
					}
			

			if (independentVarLength != dependentVarLength){
			showMessageDialog("The number of X and Y doesn't match!");
			resetChart();
			return null;
		}

			String[][] x= new String[xyLength][independentVarLength];
			double[][] y= new double[xyLength][dependentVarLength];


			for (int index=0; index<independentVarLength; index++)
				for (int i = 0; i < xyLength; i++) 
					x[i][index] = indepValues[i][index];
		   
			try{
				for (int index=0; index<dependentVarLength; index++)
					for (int i = 0; i < xyLength; i++) 
						if (depValues[i][index]!="null") 
							y[i][index] = Double.parseDouble(depValues[i][index]);
			}catch(NumberFormatException e)
				{
					showMessageDialog("Date format error!");
					return null;}

			// create the dataset... 
			XYSeriesCollection dataset = new XYSeriesCollection(); 
			XYSeries series;	

			//dependent 
			try{
			for (int i=0; i<independentVarLength; i++){
				String serieName = independentHeaders[i].substring(0, independentHeaders[i].lastIndexOf(":"));
				series = new XYSeries(serieName);
				for (int j=0; j<xyLength; j++){
					if (x[j][i]!="null"&&x[j][i]!="NaN")
						series.add(Double.parseDouble(x[j][i]), y[j][i]);
					//System.out.println("adding :("+x[j][i]+","+y[j][i]+","+independentHeaders[i]+")" );
				}
				dataset.addSeries(series);
			}}catch(NumberFormatException e)
				{
					showMessageDialog("Date format error!");
					return null;}
		
            return dataset; 
			
        }
        
    }
    
    protected void reset_slider(){
		powerX = 1.0;
		powerXSlider.setValue(powerX);	
		powerY = 1.0;
		powerYSlider.setValue(powerY);	
}
    
	/**
	* This method sets the PowerX parameter. 
	* @param p the change event
	*/
	protected void setPowerX(double pX){
		powerX = pX;
	}
	/**
	* This method gets the current PowerX parameter. 
	*/
	protected double getPowerX(){
		return powerX;
	}

	/**
	* This method sets the PowerY parameter. 
	* @param p the change event
	*/
	protected void setPowerY(double pY){
		powerY = pY;
	}
	/**
	* This method gets the current PowerY parameter. 
	*/
	protected double getPowerY(){
		return powerY;
	}

	protected XYDataset applyPowerTransform(String[] raw_x, String[] raw_y, int row_count) {
    	
		XYSeriesCollection dataset = new XYSeriesCollection();
		XYSeries series1 = new XYSeries("Data");
		for (int i=0; i<row_count; i++){
			//System.out.println("i="+i+" normalQ="+normalQuantiles[i]+" stdRes="+stdResiduals[i]);
			series1.add(Double.parseDouble(raw_x[i]), Double.parseDouble(raw_y[i]));}
	
		dataset.addSeries(series1);
		transformed_x = calculate_power(raw_x, row_count, powerX);
		transformed_y = calculate_power(raw_y, row_count, powerY);
		norm_x= normalize(raw_x,transformed_x, row_count);  
		norm_y= normalize(raw_y,transformed_y, row_count);   
		
		XYSeries series2 = new XYSeries("Transformed Data");
		for (int i=0; i<row_count; i++){
			//System.out.println("i="+i+" normalQ="+normalQuantiles[i]+" stdRes="+stdResiduals[i]);
			series2.add(norm_x[i], norm_y[i]);}
	    	
		dataset.addSeries(series2);
		return dataset;
    }

	

	
    /**
     * Creates a chart.
     * 
     * @param dataset  the data for the chart.
     * 
     * @return a chart.
     */
    protected JFreeChart createChart(XYDataset dataset) {
        
        // create the chart...
        JFreeChart chart = ChartFactory.createXYLineChart(
            "Power Transformed XYScatter Chart",      // chart title
            "X",                      // x axis label
            "Y",                      // y axis label
            dataset,                  // data
            PlotOrientation.VERTICAL,
            true,                     // include legend
            true,                     // tooltips
            false                     // urls
        );

        // NOW DO SOME OPTIONAL CUSTOMISATION OF THE CHART...
        chart.setBackgroundPaint(Color.white);
        
       // get a reference to the plot for further customisation...
        XYPlot plot = (XYPlot) chart.getPlot();
        plot.setBackgroundPaint(Color.lightGray);
		plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setDomainGridlinePaint(Color.white);
        plot.setRangeGridlinePaint(Color.white);
        
        XYLineAndShapeRenderer renderer 
            = (XYLineAndShapeRenderer) plot.getRenderer();
        renderer.setShapesVisible(true);
        renderer.setShapesFilled(true);
       // renderer.setLinesVisible(false);
        renderer.setSeriesLinesVisible(1, true);
        renderer.setSeriesShapesVisible(1, true);
        renderer.setSeriesLinesVisible(0, false);
        renderer.setSeriesShapesVisible(0, true);
		renderer.setLegendItemLabelGenerator(new SOCRXYSeriesLabelGenerator());

        // change the auto tick unit selection to integer units only...
        NumberAxis rangeAxis = (NumberAxis) plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
		rangeAxis.setAutoRangeIncludesZero(false);
		rangeAxis.setUpperMargin(0);
        rangeAxis.setLowerMargin(0);

        NumberAxis domainAxis = (NumberAxis) plot.getDomainAxis();
        domainAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        domainAxis.setAutoRangeIncludesZero(false);
        domainAxis.setUpperMargin(0);
        domainAxis.setLowerMargin(0);

        // OPTIONAL CUSTOMISATION COMPLETED.
		setXSummary(dataset);     
        return chart;
        
    }
    
 
    public void resetExample() {

    	reset_slider();
	    XYDataset dataset= createDataset(true);	
			    
		JFreeChart chart = createChart(dataset);	
		chartPanel = new ChartPanel(chart, false); 
		setChart();

        hasExample = true;
		//		convertor.dataset2Table((TimeSeriesCollection)dataset);				
		//convertor.dataset2Table(dataset);	
      
        setTable(dataset);

		// do the mapping
			
        addButtonIndependent();
        addButtonDependent();
	
		updateStatus(url);
  }


}
