/* ------------------
 * PieChartDemo4.java
 * ------------------
 * (C) Copyright 2003, 2004, by Object Refinery Limited.
 *
 */

package edu.ucla.stat.SOCR.chart.demo;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;

import javax.swing.Timer;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

import edu.ucla.stat.SOCR.chart.ChartGenerator_JTable;
import edu.ucla.stat.SOCR.chart.SuperPieChart;
import edu.ucla.stat.SOCR.chart.gui.Rotator;


/**
 * A simple demonstration application showing how to create a pie chart using data from a
 * {@link DefaultPieDataset}.  This chart has a lot of labels and rotates, so it is useful for
 * testing the label distribution algorithm.
 */
public class PieChartDemo4 extends SuperPieChart implements PropertyChangeListener {

	public void doTest(){
		 JFreeChart chart;
		 ChartGenerator_JTable chartMaker = new ChartGenerator_JTable();
		 
		 resetChart();
		 showMessageDialog("PieChartDemo4 doTest get called!");
		
		 int[][] pairs = new int[1][2];
		 pairs[0][0] = 1;   // value
		 pairs[0][1] = 0;   // name
		 chart = chartMaker.getPieChart("Pie Chart Demo4", dataTable, pairs,"2D clockwise");	
		 chartPanel = new ChartPanel(chart, false); 
			
		 setChart();
	 }
	
   protected JFreeChart createChart(PieDataset dataset) {
        // create the chart...
        JFreeChart chart = ChartFactory.createPieChart(
            chartTitle,  // chart title
            dataset,             // dataset
            false,               // include legend
            true,
            false
        );

        // set the background color for the chart...
        chart.setBackgroundPaint(new Color(222, 222, 255));
        PiePlot plot = (PiePlot) chart.getPlot();
        plot.setBackgroundPaint(Color.white);
        plot.setCircular(true);
        for (int i=0; i<pulloutFlag.length; i++){
        	//System.out.println("\""+pulloutFlag[i]+"\"");
        	if (pulloutFlag[i].equals("1")){
        		Comparable key = dataset.getKey(i);
        		plot.setExplodePercent(key, 0.30);
        	}
        }
        plot.setLabelGenerator(new StandardPieSectionLabelGenerator("{0} = {2}",
                NumberFormat.getNumberInstance(), 
                NumberFormat.getPercentInstance()));
        plot.setNoDataMessage("No data available");

		Rotator rotator = new Rotator(plot);
        rotator.start();

		setCategorySummary(dataset);
		return chart;
    }

    /**
     * Creates a sample dataset.
     * 
     * @param sections  the number of sections.
     * 
     * @return A sample dataset.
     */
    protected  DefaultPieDataset createDataset(boolean isDemo) {
       	if (isDemo){
			DefaultPieDataset dataset = createDataset(14);
			pulloutFlag = new String[14];
		        for (int i=0; i<14; i++)
		        	pulloutFlag[i]="0";
		        pulloutFlag[2]="1";
        return dataset;	
		}else 
			return super.createDataset(false);
    }

    protected DefaultPieDataset createDataset(int sections) {
        DefaultPieDataset result = new DefaultPieDataset();
        for (int i = 0; i < sections; i++) {
            double value = 100.0 * Math.random();
            result.setValue("Section " + i, value);
        }
        return result;
    }
}
 