/* ------------------
 * PieChartDemo3.java
 * ------------------
 * (C) Copyright 2003-2005, by Object Refinery Limited.
 *
 */

package edu.ucla.stat.SOCR.chart.demo;

import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeListener;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.PieDataset;

import edu.ucla.stat.SOCR.chart.ChartGenerator_JTable;
import edu.ucla.stat.SOCR.chart.SuperPieChart;

/**
 * A pie chart with no data, to demonstrate the use of the setNoDataMessage() 
 * method.
 */
public class PieChartDemo3 extends SuperPieChart implements PropertyChangeListener {

/**
 * sample code showing how to use ChartGenerator_JTable to create chart
 */
	public void doTest(){
		 JFreeChart chart;
		 ChartGenerator_JTable chartMaker = new ChartGenerator_JTable();
		 
		 resetChart();
		 showMessageDialog(chartTitle+" doTest get called!");
		
		 int[][] pairs = new int[1][2];
		 pairs[0][0] = 1;   // value
		 pairs[0][1] = 0;   // name
		 chart = chartMaker.getPieChart(chartTitle, dataTable, pairs,"");	
		 chartPanel = new ChartPanel(chart, false); 
			
		 setChart();
	 }
		
    /**
     * Creates a demo chart.
     * 
     * @param dataset  the dataset.
     * 
     * @return A chart.
     */
    protected JFreeChart createChart(PieDataset dataset) {
		dataset = null;

        JFreeChart chart = ChartFactory.createPieChart(
           chartTitle,  // chart title
            dataset,                // data
            true,                // include legend
            true,
            false
        );

        PiePlot plot = (PiePlot) chart.getPlot();
        plot.setNoDataMessage(
            "No data available so we go into this really "
            + "long spiel about what that means and it runs off the end of the "
            + "line but what can you do about that!"
        );
        plot.setNoDataMessageFont(new Font("Serif", Font.ITALIC, 10));
        plot.setNoDataMessagePaint(Color.red);

		setCategorySummary(dataset);
        return chart;
    }

}
