/* --------------------
 * PieChart3DDemo3.java
 * --------------------
 * (C) Copyright 2004, by Object Refinery Limited.
 *
 */

package edu.ucla.stat.SOCR.chart.demo;

import java.beans.PropertyChangeListener;
import java.text.AttributedString;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.util.Rotation;

import edu.ucla.stat.SOCR.chart.ChartGenerator_JTable;
import edu.ucla.stat.SOCR.chart.SuperPieChart;
import edu.ucla.stat.SOCR.chart.gui.CustomPieSectionLabelGenerator;
/**
 * A pie chart with a custom label generator.
 */
public class PieChart3DDemo3  extends SuperPieChart implements PropertyChangeListener {

	public void init(){
		ThreeDPie= true;
		super.init();
	}
	
	
	/**
 * 
 * sample code showing how to creat chart using ChartGenerator_JTable
 */
	public void doTest(){
		 JFreeChart chart;
		 ChartGenerator_JTable chartMaker = new ChartGenerator_JTable();
		 
		 resetChart();
		 showMessageDialog(chartTitle+" doTest get called!");
		
		 int[][] pairs = new int[1][2];
		 pairs[0][0] = 1;   // value
		 pairs[0][1] = 0;   // name
		 chart = chartMaker.getPieChart(chartTitle, dataTable, pairs,"3D");	
		 chartPanel = new ChartPanel(chart, false); 
			
		 setChart();
	 }
		
      /**
     * Creates a sample dataset for the demo.
     * @param isDemo  true use demo data, false use data from JTable
     * @return A sample dataset.
     */
    protected DefaultPieDataset createDataset(boolean isDemo) {
        if(isDemo){
        DefaultPieDataset result = new DefaultPieDataset();
        result.setValue("Java", new Double(43.2));
        result.setValue("Visual Basic", new Double(10.0));
        result.setValue("C/C++", new Double(17.5));
        result.setValue("PHP", new Double(32.5));
        result.setValue("Perl", new Double(1.0));
        pulloutFlag = new String[5];
        for (int i=0; i<5; i++)
        	pulloutFlag[i]="0";
        pulloutFlag[2]="1";
        
        return result;
		}
		else return super.createDataset(isDemo);
        
    }
    
    /**
     * Creates a sample chart.
     * 
     * @param dataset  the dataset.
     * 
     * @return A chart.
     */
    protected JFreeChart createChart(PieDataset dataset) {
        
        JFreeChart chart = ChartFactory.createPieChart3D(
            chartTitle,  // chart title
            dataset,                // data
            true,                   // include legend
            true,
            false
        );

        PiePlot3D plot = (PiePlot3D) chart.getPlot();
        plot.setStartAngle(290);
        plot.setDirection(Rotation.CLOCKWISE);
        plot.setForegroundAlpha(0.5f);
        plot.setNoDataMessage("No data to display");
        plot.setLabelGenerator(new CustomPieSectionLabelGenerator());
      
        for (int i=0; i<pulloutFlag.length; i++){
        	//System.out.println("\""+pulloutFlag[i]+"\"");
        	if (pulloutFlag[i].equals("1")){
        		Comparable key = dataset.getKey(i);
        		plot.setExplodePercent(key, 0.30);
        	}
        }
        
		setCategorySummary(dataset);
        return chart;
        
    }
  

}
