/* -------------------
 * LineChartDemo3.java
 * -------------------
 * (C) Copyright 2003-2005, by Object Refinery Limited.
 *
 */

package edu.ucla.stat.SOCR.chart.demo;
import java.beans.PropertyChangeListener;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

import edu.ucla.stat.SOCR.chart.ChartGenerator_JTable;
import edu.ucla.stat.SOCR.chart.SuperXYChart;
import edu.ucla.stat.SOCR.chart.gui.SOCRXYSeriesLabelGenerator;

/**
 * This line chart demo shows many series, each displaying a different shape.
 */
public class LineChartDemo3 extends SuperXYChart implements PropertyChangeListener {
	public void doTest(){
		 JFreeChart chart;
		 ChartGenerator_JTable chartMaker = new ChartGenerator_JTable();
		 
		 resetChart();
		 showMessageDialog(chartTitle+"doTest get called!");
		
		 int no_series = (dataTable.getColumnCount()-2)/2;		 
		 int[][] pairs = new int[no_series][2];
		 for (int i=0; i<no_series; i++){
			 pairs[i][0] = 2*i;    //column x
			 pairs[i][1] = 2*i+1;    //column y
		 }
		 chart = chartMaker.getXYChart("Line",chartTitle, "X", "Y", dataTable, no_series, pairs,"");	
		 chartPanel = new ChartPanel(chart, false); 
			
		 setChart();
	 }
     
	/**
	 * creaets XYDataset
	 *  @param isDemo true use the demo data, false use data from the JTable
	 *  @return XYDataset
	 */
    protected  XYDataset createDataset(boolean isDemo) {
		if (isDemo){
        XYSeriesCollection dataset = new XYSeriesCollection();
        for (int i = 0; i < 4; i++) {
            XYSeries series = new XYSeries("S" + i);
            for (int j = 0; j < 4; j++) {
                series.add(j, Math.random() * 100);
            }
            dataset.addSeries(series);
        }
        return dataset; 
		}	else return super.createDataset(false);       
    }
    
    /**
     * Creates a chart.
     * 
     * @param dataset  a dataset.
     * 
     * @return A chart based on the supplied dataset.
     */
    protected JFreeChart createChart(XYDataset dataset) {
    
        JFreeChart chart = ChartFactory.createXYLineChart(
            chartTitle,      // chart title
            "X",                      // x axis label
            "Y",                      // y axis label
            dataset,                  // data
            PlotOrientation.VERTICAL, 
            true,                     // include legend
            true,                     // tooltips
            false                     // urls
        );

        // NOW DO SOME OPTIONAL CUSTOMISATION OF THE CHART...

        // get a reference to the plot for further customisation...
        XYPlot plot = (XYPlot) chart.getPlot();
        XYLineAndShapeRenderer renderer 
            = (XYLineAndShapeRenderer) plot.getRenderer();
        renderer.setShapesVisible(true);
        renderer.setBaseShapesFilled(true);
        renderer.setDrawOutlines(true);
		renderer.setLegendItemLabelGenerator(new SOCRXYSeriesLabelGenerator());

        // change the auto tick unit selection to integer units only...
        NumberAxis rangeAxis = (NumberAxis) plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
		NumberAxis domainAxis = (NumberAxis) plot.getDomainAxis();
		domainAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
		setXSummary(dataset);
        return chart;
    }
    

}
