/* -----------------
 * CompassDemo1.java
 * -----------------
 * (C) Copyright 2002-2004, by Object Refinery Limited.
 *
 */

package edu.ucla.stat.SOCR.chart.demo;

import java.awt.Color;
import java.beans.PropertyChangeListener;

import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CompassPlot;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.data.general.ValueDataset;

import edu.ucla.stat.SOCR.chart.ChartGenerator_JTable;
import edu.ucla.stat.SOCR.chart.SuperValueChart;

/**
 * A simple demonstration application showing how to create a compass chart
 */
public class CompassDemo1 extends SuperValueChart implements PropertyChangeListener {

	protected ValueDataset createDateset(boolean isDemo){
		if (isDemo){
			ValueDataset dataset = new DefaultValueDataset(new Double(45.0));
		return dataset;
		}	
		else return super.createDataset(false);
		
    }
	/**
	 * sample code showing how to create a  chart using ChartGenerator_JTable class
	 */
	public void doTest(){
		 JFreeChart chart;
		 ChartGenerator_JTable chartMaker = new ChartGenerator_JTable();
		 
		 resetChart();
		 showMessageDialog(chartTitle+" doTest get called!");
		
		 int no_series = dataTable.getColumnCount();		 
		 int[][] pairs = new int[no_series][1];
		 for (int i=0; i<no_series; i++){
			 pairs[i][0] = i;    //column x
		 }
	
		 chart = chartMaker.getCompassChart("CompassChart",  dataTable, no_series, pairs, "");	
		 chartPanel = new ChartPanel(chart, false); 
			
		 setChart();
	 }
	
    /**
     * Creates a chart.
     * 
     * @param dataset  the dataset.
     * 
     * @return The chart.
     */
    protected JFreeChart createChart(ValueDataset dataset) {
       

        CompassPlot plot = new CompassPlot(dataset);
        plot.setSeriesNeedle(7);
        plot.setSeriesPaint(0, Color.red);
        plot.setSeriesOutlinePaint(0, Color.red);
        plot.setRoseHighlightPaint(Color.CYAN);
        JFreeChart chart = new JFreeChart(plot);
        return chart;
        
    }

}
