/* ---------------------
 * BubbleChartDemo1.java
 * ---------------------
 * (C) Copyright 2003-2005, by Object Refinery Limited.
 */

package edu.ucla.stat.SOCR.chart.demo;

import java.awt.Color;
import java.beans.PropertyChangeListener;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYZDataset;

import edu.ucla.stat.SOCR.chart.ChartGenerator_JTable;
import edu.ucla.stat.SOCR.chart.SuperXYZChart;
import edu.ucla.stat.SOCR.chart.data.SampleXYZDataset;
import edu.ucla.stat.SOCR.chart.gui.SOCRXYZSeriesLabelGenerator;

/**
 * A bubble chart demo.
 */
public class BubbleChartDemo1 extends SuperXYZChart implements PropertyChangeListener {

	protected XYZDataset createDataset(boolean isDemo){
		if (isDemo){
		 return new SampleXYZDataset();
		}
		else return super.createDataset(false); 
	}
	
	/**
	 * sample code showing how to create a  bubble chart using ChartGenerator_JTable class
	 */
	public void doTest(){
		 JFreeChart chart;
		 ChartGenerator_JTable chartMaker = new ChartGenerator_JTable();
		 
		 resetChart();
		 showMessageDialog("SuperXYZChart doTest get called!");
		
		 int no_series = (dataTable.getColumnCount())/3;		 
		 int[][] pairs = new int[no_series][3];
		 for (int i=0; i<no_series; i++){
			 pairs[i][0] = 3*i;    //column x
			 pairs[i][1] = 3*i+1;    //column y
			 pairs[i][2] = 3*i+2;    //column y
		 }
	
		 chart = chartMaker.getXYZBubbleChart("Bubble Chart", "X", "Y", dataTable, no_series, pairs,"");	
		 chartPanel = new ChartPanel(chart, false); 
			
		 setChart();
	 }
	
    /**
     * Creates a chart.
     * 
     * @param dataset  the dataset.
     * 
     * @return The chart.
     */
    protected JFreeChart createChart(XYZDataset dataset) {
        JFreeChart chart = ChartFactory.createBubbleChart(
			chartTitle,
            "X", 
            "Y", 
            dataset, 
            PlotOrientation.HORIZONTAL,
            true, 
            true, 
            false
        );
        XYPlot plot = (XYPlot) chart.getPlot();
        plot.setForegroundAlpha(0.65f);
        
        XYItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(0, Color.blue);
		renderer.setLegendItemLabelGenerator(new SOCRXYZSeriesLabelGenerator());           

        // increase the margins to account for the fact that the auto-range 
        // doesn't take into account the bubble size...
        NumberAxis domainAxis = (NumberAxis) plot.getDomainAxis();
        domainAxis.setLowerMargin(0.15);
        domainAxis.setUpperMargin(0.15);
        NumberAxis rangeAxis = (NumberAxis) plot.getRangeAxis();
        rangeAxis.setLowerMargin(0.15);
        rangeAxis.setUpperMargin(0.15);
        return chart;
    }

}
