/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.stat.SOCR.core;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ValueSetter
extends JPanel {
    private int type;
    private Observable observable = new Observable(){

        public void notifyObservers() {
            this.setChanged();
            super.notifyObservers(ValueSetter.this);
        }
    };
    private double dvalue;
    private double minv;
    private double maxv;
    private double scale = 1.0;
    private DecimalFormat formatter = new DecimalFormat("#0.0##");
    private JSlider slider;
    private JTextField valueText = new JTextField(5);
    private boolean enterTyped = false;

    public ValueSetter(String string, int n, int n2, double d) {
        this(string, n, n2, (n + n2) / 2, d);
    }

    public ValueSetter(String string, int n, int n2, int n3, double d) {
        this.scale = d;
        this.type = 1;
        this.constructing(string, n, n2, n3);
    }

    public ValueSetter(String string, int n, int n2, int n3) {
        this(string, n, n2, n3, (n2 + n3) / 2);
    }

    public ValueSetter(String string, int n, int n2, int n3, int n4) {
        this.type = n;
        if (n == 1 && n3 - n2 < 10) {
            n3 *= 10;
            n2 *= 10;
            n4 *= 10;
            this.scale = 0.1;
        }
        this.constructing(string, n2, n3, n4);
    }

    private void constructing(String string, int n, int n2, int n3) {
        this.setLayout(new BoxLayout(this, 1));
        this.initializeSlider(n, n2, n3);
        this.add(this.slider);
        this.add(Box.createVerticalStrut(8));
        this.add(this.valueText);
        TitledBorder titledBorder = new TitledBorder(new EtchedBorder(), string);
        this.setBorder(titledBorder);
        this.valueText.setMaximumSize(this.valueText.getPreferredSize());
        this.valueText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ValueSetter.this.textAreaPeformAction();
            }
        });
    }

    private void initializeSlider(int n, int n2, int n3) {
        this.dvalue = n3;
        this.minv = n;
        this.maxv = n2;
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        if (this.type == 0) {
            hashtable.put(new Integer(n), new JLabel(String.valueOf(n)));
            hashtable.put(new Integer(n2), new JLabel(String.valueOf(n2)));
        } else {
            hashtable.put(new Integer(n), new JLabel(this.formatter.format((double)n * this.scale)));
            hashtable.put(new Integer(n2), new JLabel(this.formatter.format((double)n2 * this.scale)));
            this.dvalue *= this.scale;
        }
        this.slider = new JSlider(n, n2, n3);
        this.slider.setMajorTickSpacing((n2 - n) / 10);
        this.slider.setMinorTickSpacing((n2 - n) / 20);
        this.slider.setPreferredSize(new Dimension(70, 50));
        this.slider.setPaintTicks(true);
        this.slider.setSnapToTicks(true);
        this.slider.setLabelTable(hashtable);
        this.slider.setPaintLabels(true);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (ValueSetter.this.enterTyped) {
                    return;
                }
                ValueSetter.this.dvalue = (double)ValueSetter.this.slider.getValue() * ValueSetter.this.scale;
                ValueSetter.this.setTextAreaValue();
            }
        });
        this.setTextAreaValue();
    }

    public void addObserver(Observer observer) {
        this.observable.addObserver(observer);
    }

    public double getValue() {
        return this.dvalue;
    }

    public int getValueAsInt() {
        return (int)this.dvalue;
    }

    public void setValue(double d) {
        String string = this.type == 0 ? String.valueOf((int)d) : String.valueOf(d);
        this.valueText.setText(string);
        this.textAreaPeformAction();
    }

    public void setRange(int n, int n2) {
        this.setRange(n, n2, (n + n2) / 2);
    }

    public void setRange(int n, int n2, int n3) {
        if (n >= n2) {
            return;
        }
        if (n3 < n) {
            n3 = n;
        } else if (n3 > n2) {
            n3 = n2;
        }
        this.remove(this.slider);
        this.initializeSlider(n, n2, n3);
        this.add((Component)this.slider, 0);
        this.revalidate();
        this.repaint();
    }

    public void setTitle(String string) {
        ((TitledBorder)this.getBorder()).setTitle(string);
    }

    public void setEnabled(boolean bl) {
        this.slider.setEnabled(bl);
        this.valueText.setEnabled(bl);
        super.setEnabled(bl);
    }

    private void setTextAreaValue() {
        String string;
        String string2 = this.valueText.getText();
        String string3 = string = this.type == 0 ? String.valueOf((int)this.dvalue) : this.formatter.format(this.dvalue);
        if (string2.equals(string)) {
            return;
        }
        this.valueText.setText(string);
        this.observable.notifyObservers();
    }

    private void setSliderValue() {
        this.slider.setValue((int)(this.dvalue / this.scale));
    }

    private void textAreaPeformAction() {
        try {
            this.dvalue = Double.parseDouble(this.valueText.getText());
            if (this.dvalue < this.minv && this.minv >= 0.0) {
                this.valueText.selectAll();
                return;
            }
            if (this.dvalue < this.minv) {
                this.setRange((int)this.dvalue, (int)this.maxv, (int)this.dvalue);
            } else if (this.dvalue > this.maxv) {
                this.setRange((int)this.minv, (int)this.dvalue, (int)this.dvalue);
            }
            this.enterTyped = true;
            this.setSliderValue();
            this.observable.notifyObservers();
            this.enterTyped = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.valueText.selectAll();
        }
    }
}

