/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.stat.SOCR.core;

import edu.ucla.stat.SOCR.core.Modeler;
import edu.ucla.stat.SOCR.core.ModelerGui;
import edu.ucla.stat.SOCR.core.SOCRApplet;
import edu.ucla.stat.SOCR.core.SOCRCodeBase;
import edu.ucla.stat.SOCR.modeler.ModelerColor;
import edu.ucla.stat.SOCR.modeler.ModelerDimension;
import edu.ucla.stat.SOCR.util.OKDialog;
import edu.ucla.stat.SOCR.util.ObservableWrapper;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class SOCRModeler
extends SOCRApplet
implements Observer,
AdjustmentListener,
ChangeListener,
ActionListener,
ItemListener {
    private static final String ABOUT = "ABOUT";
    private static final String HELP = "HELP";
    private static final String SNAPSHOT = "SNAPSHOT";
    private static final String BIN_SLIDER_LABEL = "  Number of Bins.  Less Bins. ";
    private static final String BIN_SLIDER_LABEL_RIGHT = "  More Bins.  ";
    private static final String X_SLIDER_LABEL = "  Horizontal Scale. (X) ";
    private static final String Y_SLIDER_LABEL = "  Vertical Scale. (Y)  ";
    public String buffer = "";
    private boolean initClicked = true;
    private boolean rescaleClicked = false;
    private JPanel rightPanel = new JPanel();
    private JPanel toolPanel = new JPanel();
    private JPanel centerPanel = new JPanel();
    private JPanel choicePanel = new JPanel();
    private JScrollPane choiceScrollPane = new JScrollPane();
    private JSplitPane fSOCRPane = null;
    private JToolBar ccpBar = new JToolBar(0);
    private JToolBar aboutBar = new JToolBar(0);
    private JToolBar toolBarButton = new JToolBar(" ", 0);
    private JToolBar toolBarScrolls = new JToolBar(" ", 0);
    private JToolBar zoomBar = new JToolBar(" ", 0);
    private JScrollBar bins = null;
    private JScrollBar xScale = null;
    private JScrollBar yScale = null;
    private JButton pasteButton = new JButton("PASTE");
    private JButton copyButton = new JButton("COPY");
    private JButton resetButton = new JButton("RESET");
    private JButton aboutButton = new JButton("ABOUT");
    private JButton helpButton = new JButton("HELP");
    private JButton snapShotButton = new JButton("SNAPSHOT");
    private JButton zoomOut = new JButton("ZOOM OUT");
    private JButton zoomIn = new JButton("ZOOM IN");
    private JButton usePosNegX = new JButton("USE +/- X");
    private JButton usePosX = new JButton("USE + X");
    private JButton fileButton = new JButton("FILE OPEN");
    private JButton reinit = new JButton("RE-INITIALIZE");
    public JCheckBox rawData = new JCheckBox("Raw Data", false);
    public JCheckBox rescale = new JCheckBox("Scale Up", false);
    public JTextField histBins = new JTextField("10", 3);
    public JLabel histLabel = new JLabel("Bins");
    private DefaultTableModel tModel;
    private TableColumn clm2;
    private TitledBorder titleBorder;
    public Clipboard clipboard;
    public File file;
    public FileInputStream Fileip;
    public FileDialog FileLocate;
    public Frame fDialog = new Frame();
    private JFileChooser jfc;
    private ModelerGui modeler;
    private ObservableWrapper observablewrapper = new ObservableWrapper();
    static /* synthetic */ Class class$javax$swing$JPanel;

    public void initGUI() {
        JPanel jPanel;
        ModelerDimension.initScreenSize();
        this.controlPanelTitle = "Distributions/Parameters";
        this.implementedFile = "implementedModelers.txt";
        SOCRCodeBase.setCodeBase(this.getCodeBase());
        this.addJCheckBox(this.rescale);
        this.addJCheckBox(this.rawData);
        this.rescale.setBackground(ModelerColor.CHECKBOX_RESCALE_BACKGROUND);
        this.rawData.setBackground(ModelerColor.CHECKBOX_RAWDATA_BACKGROUND);
        this.rawData.addItemListener(this);
        this.rescale.addActionListener(this);
        this.addJPanel(this.choicePanel);
        this.choicePanel.add(this.choiceScrollPane);
        this.choicePanel.setLayout(new BoxLayout(this.choicePanel, 1));
        this.choicePanel.setBackground(ModelerColor.PANEL_CHOICE_BACKGROUND);
        this.titleBorder = new TitledBorder(new EtchedBorder(), "Parameters");
        this.choicePanel.setBorder(this.titleBorder);
        this.choicePanel.add(new JButton("trial"));
        this.choicePanel.validate();
        this.choicePanel.repaint();
        this.modeler = new ModelerGui();
        this.modeler.setCodeBase(this.codeBase);
        this.modeler.init();
        this.observablewrapper.addObserver((Observer)this);
        this.observablewrapper.addJCheckBox(this.rescale);
        this.observablewrapper.addJButton(this.reinit);
        try {
            this.toolBarScrolls.setFloatable(false);
            this.toolBarScrolls.setLayout(new BorderLayout());
            this.toolBarButton.setFloatable(false);
            this.toolBarButton.add(this.fileButton);
            this.fileButton.addActionListener(this);
            this.toolBarButton.add(this.resetButton);
            this.resetButton.addActionListener(this);
            this.aboutBar.setFloatable(false);
            this.aboutBar.add(this.aboutButton);
            this.aboutBar.add(this.helpButton);
            this.aboutBar.add(this.snapShotButton);
            this.aboutButton.addActionListener(this);
            this.helpButton.addActionListener(this);
            this.snapShotButton.addActionListener(this);
            jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new BorderLayout());
            this.toolBarScrolls.setBackground(ModelerColor.BAR_BACKGROUND);
            this.toolBarButton.setBackground(ModelerColor.BUTTON_BACKGROUND);
            jPanel.setBackground(ModelerColor.BUTTON_BACKGROUND);
            this.zoomBar.setFloatable(false);
            this.zoomBar.add(this.zoomOut);
            this.zoomOut.addActionListener(this);
            this.zoomBar.add(this.zoomIn);
            this.zoomIn.addActionListener(this);
            this.usePosX.addActionListener(this);
            this.usePosNegX.addActionListener(this);
            this.bins = new JScrollBar(0, 100, 1, 100, 500);
            jPanel2.setBackground(ModelerColor.BAR_BACKGROUND);
            jPanel2.add((Component)new JLabel(BIN_SLIDER_LABEL), "West");
            jPanel2.add((Component)this.bins, "Center");
            jPanel2.add((Component)new JLabel(BIN_SLIDER_LABEL_RIGHT), "East");
            this.bins.addAdjustmentListener(this);
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.setBackground(ModelerColor.BAR_BACKGROUND);
            this.xScale = new JScrollBar(0, 5, 5, 1, (int)Math.ceil(501.0));
            jPanel3.add((Component)new JLabel(X_SLIDER_LABEL), "West");
            jPanel3.add((Component)this.xScale, "Center");
            this.xScale.addAdjustmentListener(this);
            this.xScale.setValue(this.xScale.getMaximum() - 5);
            try {
                if (this.modeler.modelObject.getModelType() == 101 || this.modeler.modelObject.getModelType() == 102) {
                    this.modeler.setXScale(this.xScale.getMaximum() - this.xScale.getValue(), false);
                } else {
                    this.modeler.setXScale(this.xScale.getMaximum() - this.xScale.getValue(), false);
                }
            }
            catch (Exception exception) {
                this.modeler.setXScale(this.xScale.getMaximum() - this.xScale.getValue(), false);
            }
            JPanel jPanel4 = new JPanel(new BorderLayout());
            jPanel4.setBackground(ModelerColor.BAR_BACKGROUND);
            this.yScale = new JScrollBar(0, 5, 2, 1, 201);
            jPanel4.add((Component)new JLabel(Y_SLIDER_LABEL), "West");
            jPanel4.add((Component)this.yScale, "Center");
            this.yScale.addAdjustmentListener(this);
            this.yScale.setValue(this.yScale.getMaximum() - 10);
            this.modeler.setYScale(this.yScale.getMaximum() - this.yScale.getValue());
            this.toolBarScrolls.add((Component)jPanel2, "North");
            this.toolBarScrolls.add((Component)jPanel3, "South");
            this.toolBarScrolls.add((Component)jPanel4, "Center");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.ccpBar.setFloatable(false);
        this.ccpBar.add(this.pasteButton);
        this.ccpBar.add(this.copyButton);
        this.pasteButton.addActionListener(this);
        this.copyButton.addActionListener(this);
        this.rightPanel.setLayout(new BorderLayout());
        this.rightPanel.setBackground(ModelerColor.BLUE);
        this.toolPanel.setLayout(new BorderLayout());
        this.toolPanel.setBackground(ModelerColor.BLACK);
        jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.modeler.getContentPane(), "Center");
        this.rightPanel.add((Component)jPanel, "Center");
        this.rightPanel.add((Component)this.toolPanel, "North");
        this.toolPanel.add((Component)this.toolBarButton, "North");
        this.toolPanel.add((Component)this.toolBarScrolls, "Center");
        this.toolBarButton.add((Component)this.ccpBar, "East");
        this.toolBarButton.add((Component)this.aboutBar, "Center");
        this.toolBarButton.add((Component)this.zoomBar, "West");
        this.fPresentPanel.setViewportView(this.rightPanel);
        this.fPresentPanel.setBackground(ModelerColor.PANEL_PRESENT_BACKGROUND);
        this.fSOCRPane = new JSplitPane(1, this.fControlPanel, this.fPresentPanel);
        this.fSOCRPane.setDividerLocation(ModelerDimension.PANEL_DIVISION_PROPORTION);
        this.fSOCRPane.resetToPreferredSizes();
        this.fPresentPanel.validate();
        this.fPresentPanel.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2;
        Object object3 = actionEvent.getSource();
        if (actionEvent.getSource() == this.resetButton) {
            this.modeler.clearData();
            this.modeler.graph.clear();
        }
        if (actionEvent.getSource() == this.fileButton) {
            this.FileLocate = new FileDialog(this.fDialog);
            this.FileLocate.setVisible(true);
            this.fDialog.setVisible(true);
            if (this.FileLocate.getFile() != null) {
                this.loadFileData();
            }
        }
        if (actionEvent.getSource() == this.copyButton) {
            Object object4;
            String string = "";
            if (this.modeler.tabbedPanelContainer.getSelectedIndex() == 0) {
                object4 = this.modeler.dataTable.getSelectedRows();
                object2 = this.modeler.dataTable.getSelectedColumns();
                if (((int[])object2).length < 1 || ((int[])object4).length < 1) {
                    object = new OKDialog(null, true, "Make a selection to copy data");
                    object.setVisible(true);
                } else {
                    for (int i = 0; i < ((int[])object4).length; ++i) {
                        for (int j = 0; j < ((int[])object2).length; ++j) {
                            string = this.modeler.dataTable.getValueAt(object4[i], object2[j]) == null ? string + " \t" : string + this.modeler.dataTable.getValueAt(object4[i], object2[j]) + "\t";
                        }
                        string = string.substring(0, string.length() - 1) + "\n";
                    }
                }
            } else if (this.modeler.tabbedPanelContainer.getSelectedIndex() == 2 && this.modeler.resultPanelTextArea.getSelectedText() != null) {
                string = this.modeler.resultPanelTextArea.getSelectedText();
            }
            try {
                object4 = new StringSelection(string);
                this.clipboard.setContents((Transferable)object4, (ClipboardOwner)object4);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (actionEvent.getSource() == this.pasteButton) {
            int n = this.modeler.dataTable.getSelectedRow();
            int n2 = this.modeler.dataTable.getSelectedColumn();
            if (n == -1) {
                object2 = new OKDialog(null, true, "Select a row to paste data");
                object2.setVisible(true);
            } else {
                try {
                    this.clipboard.getContents(this);
                    object2 = this.clipboard.getContents(this).getTransferDataFlavors();
                    int cfr_ignored_0 = object2[0];
                    object = this.clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor).toString();
                    StringTokenizer stringTokenizer = new StringTokenizer((String)object, "\n");
                    int n3 = stringTokenizer.countTokens();
                    if (n + n3 > this.modeler.dataTable.getRowCount()) {
                        this.modeler.dataTable.appendTableRows(n + n3 - this.modeler.dataTable.getRowCount());
                    }
                    int n4 = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        String string = stringTokenizer.nextToken();
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string, "\t\r\f");
                        int n5 = 0;
                        while (stringTokenizer2.hasMoreTokens()) {
                            this.modeler.dataTable.setValueAt((Object)stringTokenizer2.nextToken(), n + n4, n5 + n2);
                            ++n5;
                        }
                        ++n4;
                    }
                }
                catch (Exception exception) {
                    object = new OKDialog(null, true, "Unalbe to paste. Check the datatype.\nNumber of columns from PASTE data cannot exceed number of columns in Table");
                    object.setVisible(true);
                    exception.printStackTrace();
                }
            }
        }
        if (actionEvent.getActionCommand().equals(HELP)) {
            try {
                this.getAppletContext().showDocument(new URL(this.modeler.getOnlineDescription()), "SOCR: Modeler Online Help");
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
        if (actionEvent.getActionCommand().equals(SNAPSHOT)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BufferedImage bufferedImage = SOCRModeler.this.capture();
                    if (SOCRModeler.this.jfc == null) {
                        SOCRModeler.this.jfc = new JFileChooser();
                    } else {
                        SOCRModeler.this.jfc.setVisible(true);
                    }
                    File file = SOCRModeler.this.jfc.getSelectedFile();
                    SOCRModeler.this.jfc.setVisible(false);
                    if (!file.getName().endsWith(".jpg")) {
                        file = new File(file.getAbsolutePath() + ".jpg");
                    }
                    String string = file.getName().substring(file.getName().lastIndexOf(46) + 1);
                    try {
                        ImageIO.write((RenderedImage)bufferedImage, string, file);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            });
        }
        if (object3 == this.zoomIn) {
            this.modeler.zoomIn(this.bins.getValue(), false);
        }
        if (object3 == this.zoomOut) {
            this.modeler.zoomOut(this.bins.getValue(), false);
        }
        if (object3 == this.usePosX) {
            this.modeler.usePosX();
        }
        if (object3 == this.usePosNegX) {
            this.modeler.usePosNegX();
        }
        if (object3 == this.reinit) {
            this.initClicked = true;
            this.rescaleClicked = false;
            this.modeler.fitC(this.rescaleClicked, this.rescale.isSelected(), this.initClicked);
        }
        if (object3 == this.rescale) {
            this.initClicked = false;
            this.rescaleClicked = true;
            this.modeler.fitC(this.rescaleClicked, this.rescale.isSelected(), this.initClicked);
        }
    }

    protected void itemChanged(String string) {
        try {
            this.choicePanel.removeAll();
            this.choicePanel.setLayout(new BoxLayout(this.choicePanel, 1));
            this.choicePanel.setBorder(this.titleBorder);
            Object[] objectArray = new Object[]{this.choicePanel};
            this.modeler.modelObject = (Modeler)Class.forName(string).getConstructor(class$javax$swing$JPanel == null ? (class$javax$swing$JPanel = SOCRModeler.class$("javax.swing.JPanel")) : class$javax$swing$JPanel).newInstance(objectArray);
            this.modeler.modelObject.registerObservers(this.observablewrapper);
            if (this.modeler.modelObject.useInitButton()) {
                this.choicePanel.add(this.reinit);
                this.reinit.setBackground(ModelerColor.WHITE);
                this.reinit.addActionListener(this);
                this.observablewrapper.addJCheckBox(this.rescale);
                this.choicePanel.repaint();
            }
            this.modeler.fitC(this.rescaleClicked, this.rescale.isSelected(), this.initClicked);
            double d = this.modeler.modelObject.getLowerLimit();
            double d2 = this.modeler.modelObject.getUpperLimit();
            if (d == Double.NEGATIVE_INFINITY) {
                d = -501.0;
            }
            if (d2 == Double.POSITIVE_INFINITY) {
                d2 = 501.0;
            }
            this.modeler.setUpperLimit(d2);
            this.modeler.setLowerLimit(d);
            String string2 = "Description: \n" + this.modeler.modelObject.getDescription() + "\n\nInstructions: \n" + this.modeler.modelObject.getInstructions() + "\n\nReferences: \n" + this.modeler.modelObject.getResearch();
            this.modeler.infoPanelTextArea.setText(string2);
            this.addJPanel(this.choicePanel);
            this.choicePanel.validate();
            this.choicePanel.repaint();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.rawData) {
            this.modeler.fitC();
            this.setColumns();
            this.modeler.syncMouseData();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.bins) {
            this.modeler.setBins(this.bins.getValue());
        }
        if (adjustmentEvent.getSource() == this.xScale) {
            try {
                if (this.modeler.modelObject.getModelType() == 101 || this.modeler.modelObject.getModelType() == 102) {
                    this.modeler.setXScale(this.xScale.getMaximum() - this.xScale.getValue(), false);
                } else {
                    this.modeler.setXScale(this.xScale.getMaximum() - this.xScale.getValue(), false);
                }
            }
            catch (Exception exception) {
                this.modeler.setXScale(this.xScale.getMaximum() - this.xScale.getValue(), false);
            }
        }
        if (adjustmentEvent.getSource() == this.yScale) {
            this.modeler.setYScale(this.yScale.getMaximum() - this.yScale.getValue());
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.bins) {
            this.modeler.setBins(this.bins.getValue());
        }
        if (changeEvent.getSource() == this.xScale) {
            this.modeler.setXScale(this.xScale.getMaximum() - this.xScale.getValue(), false);
        }
        if (changeEvent.getSource() == this.yScale) {
            this.modeler.setYScale(this.yScale.getMaximum() - this.yScale.getValue());
        }
    }

    public void update(Observable observable, Object object) {
        this.modeler.fitC(this.rescaleClicked, this.rescale.isSelected(), false);
    }

    public Object getCurrentItem() {
        return this;
    }

    public void setColumns() {
        if (this.rawData.isSelected()) {
            this.clm2 = this.modeler.dataTable.getColumn((Object)"Frequency");
            this.modeler.dataTable.removeColumn(this.clm2);
        } else {
            this.modeler.dataTable.addColumn(this.clm2);
        }
    }

    private void loadFileData() {
        try {
            this.file = new File(this.FileLocate.getDirectory(), this.FileLocate.getFile());
            this.Fileip = new FileInputStream(this.file);
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            n = this.Fileip.read();
            while (n != -1) {
                if (n == 59 || n == 44) {
                    this.modeler.dataTable.setValueAt((Object)this.buffer, n2, n3);
                    n3 = n3 == 1 ? 0 : 1;
                    this.buffer = "";
                } else if (n == 13) {
                    this.modeler.dataTable.setValueAt((Object)this.buffer, n2, n3);
                    this.buffer = "";
                    this.Fileip.read();
                    n3 = 0;
                    if (++n2 == this.modeler.dataTable.getRowCount()) {
                        this.tModel = (DefaultTableModel)this.modeler.dataTable.getModel();
                        this.tModel.addRow(new Vector(2));
                        this.modeler.dataTable.setModel((TableModel)this.tModel);
                    }
                } else {
                    this.buffer = this.buffer + Character.toString((char)n);
                }
                n = this.Fileip.read();
            }
            n3 = this.modeler.dataTable.getColumnCount() == 1 ? 0 : 1;
            this.modeler.dataTable.setValueAt((Object)this.buffer, n2, n3);
            this.buffer = "";
            this.Fileip.close();
            this.modeler.fitC(this.rescaleClicked, this.rescale.isSelected(), this.initClicked);
        }
        catch (Exception exception) {
            this.modeler.resultPanelTextArea.setText(exception.getMessage());
            OKDialog oKDialog = new OKDialog((Frame)new JFrame(), true, exception.getMessage());
            oKDialog.setVisible(true);
        }
    }

    public String getOnlineDescription() {
        return new String("http://socr.stat.ucla.edu/");
    }

    public String getLocalHelp() {
        return "Introduction: The SOCRChart applet is a collection of data plotting tool, and it allows you to:\n\t1. Visualize your own data graphically.\n\t2. Generate some statistical plots such as:\n\t    StatisticalBarChart(BoxPlot), StatisticalLineChart(ScatterPlot), NormalDistributionPlot, BoxAndWhiskerChart.\n\nHow to use the SOCRChart Applets:\n\t1. Select a chart from the SOCRChart list from the left control panel, a demo of the selected chart type will be\n\t    shown in the right display panel.\n\t2. Click on the \"DATA\" tab in the right display panel to view the data used in the demo in a table form. \n\t   The data and the headings are all editable for you to enter your own data. \n\t3. For each chart type, the \"MAPPING\" is set for the demo data.  You can make change as needed using the \n\t   \"Add\"/\"Remove\" button.\n\t4. After making data/mapping changes, click on the \"UPDATE_CHART\" button to get the plot updated.\n\t5. Click the \"DEMO\" button will reset everything to the demo state.\n\t6. Click the \"CLEAR\" button will clear all for you to start entering your own data.\n\nNotes: \n\t1.You can select table cells and use the \"COPY\"/\"PASTE\" button to copy/paste data in the data table.\n\t2.The \"SNAPSHOT\" button can be used to save a snapshot of the graph to your own computer.\n\t3.To add a extra row to the data table, hit \"enter\" key in the last cell. Hit \"tab\" key in the last cell will add a extra \n\t   column.\n\t4. To report bugs or make recommendations please visit: http://www.socr.ucla.edu/\n\n SOCRChart is based on JFreeChart and uses it's rendering engine to render the chart image. See www.jfree.org/jfreechart/ \n \t   for more information.";
    }

    private BufferedImage capture() {
        Robot robot;
        try {
            robot = new Robot();
        }
        catch (AWTException aWTException) {
            throw new RuntimeException(aWTException);
        }
        Rectangle rectangle = this.getContentPane().getBounds();
        Point point = rectangle.getLocation();
        SwingUtilities.convertPointToScreen(point, this.getContentPane());
        rectangle.setLocation(point);
        return robot.createScreenCapture(rectangle);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

