/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.stat.SOCR.core;

import edu.ucla.stat.SOCR.core.Game;
import edu.ucla.stat.SOCR.core.IGame;
import edu.ucla.stat.SOCR.core.SOCRApplet;
import edu.ucla.stat.SOCR.core.SOCRCodeBase;
import java.awt.AWTException;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class SOCRGames
extends SOCRApplet
implements ActionListener {
    IGame game;
    JFileChooser jfc;
    public final String ABOUT = "About";
    public final String RESET = "Reset";
    public final String SNAPSHOT = "Snapshot";

    public void initGUI() {
        SOCRCodeBase.setCodeBase(this.getCodeBase());
        this.controlPanelTitle = "Virtual Games";
        this.implementedFile = "implementedGames.txt";
        this.addButton("Reset", "Reset the Outcome of the Games!", this);
        this.addButton("About", "About this Game?", this);
        this.addButton("Snapshot", "Take a Snapshot and save this Applet as JPG image", this);
    }

    public void itemChanged(String string) {
        try {
            this.game = Game.getInstance(string);
            this.game.setApplet(this);
            Container container = this.game.getDisplayPane();
            this.fPresentPanel.setViewportView(container);
            container.validate();
        }
        catch (Throwable throwable) {
            JOptionPane.showMessageDialog(this, "Sorry, not implemented yet");
            throwable.printStackTrace();
        }
    }

    public Object getCurrentItem() {
        return this.game;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("About")) {
            JOptionPane.showMessageDialog(this, this.game.getName() + ": " + this.game.getOnlineDescription(), "About: " + this.game.getName(), 1);
        } else if (actionEvent.getActionCommand().equals("Reset")) {
            this.game.reset();
        } else if (actionEvent.getActionCommand().equals("Snapshot")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BufferedImage bufferedImage = SOCRGames.this.capture();
                    if (SOCRGames.this.jfc == null) {
                        SOCRGames.this.jfc = new JFileChooser();
                    } else {
                        SOCRGames.this.jfc.setVisible(true);
                    }
                    int n = SOCRGames.this.jfc.showSaveDialog(null);
                    File file = SOCRGames.this.jfc.getSelectedFile();
                    SOCRGames.this.jfc.setVisible(false);
                    if (!file.getName().endsWith(".jpg")) {
                        file = new File(file.getAbsolutePath() + ".jpg");
                    }
                    String string = file.getName().substring(file.getName().lastIndexOf(46) + 1);
                    System.out.println("type " + string);
                    try {
                        ImageIO.write((RenderedImage)bufferedImage, string, file);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        JOptionPane.showMessageDialog(null, iOException, "Error Writing File", 0);
                    }
                }
            });
        }
    }

    private BufferedImage capture() {
        Robot robot;
        try {
            robot = new Robot();
        }
        catch (AWTException aWTException) {
            throw new RuntimeException(aWTException);
        }
        Rectangle rectangle = this.getContentPane().getBounds();
        Point point = rectangle.getLocation();
        SwingUtilities.convertPointToScreen(point, this.getContentPane());
        rectangle.setLocation(point);
        return robot.createScreenCapture(rectangle);
    }
}

