/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.stat.SOCR.core;

import edu.ucla.stat.SOCR.core.Experiment;
import edu.ucla.stat.SOCR.core.IExperiment;
import edu.ucla.stat.SOCR.core.SOCRApplet;
import java.awt.AWTException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class SOCRExperiments
extends SOCRApplet
implements ActionListener {
    IExperiment experiment;
    public final String ABOUT = "About";
    public final String RESET = "Reset";
    public final String SNAPSHOT = "Snapshot";
    JFileChooser jfc;
    String _className;

    public void stop() {
        this.experiment.stop();
    }

    public void initGUI() {
        this.controlPanelTitle = "Virtual Experiments";
        this.implementedFile = "implementedExperiments.txt";
        this.addButton("Reset", "Reset the Outcome of the Experiments!", this);
        this.addButton("About", "About this Experiment?", this);
        this.addButton("Snapshot", "Take a Snapshot and save this Applet as JPG image", this);
    }

    public void itemChanged(String string) {
        this._className = string;
        try {
            this.experiment = Experiment.getInstance(string);
            this.experiment.setApplet(this);
            this.experiment.initialize();
            this.fPresentPanel.setViewportView(this.experiment.getDisplayPane());
        }
        catch (Throwable throwable) {
            JOptionPane.showMessageDialog(this, string + "\nnot implemented yet");
            throwable.printStackTrace();
        }
    }

    public Object getCurrentItem() {
        return this.experiment;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("About")) {
            try {
                JOptionPane.showMessageDialog(this, this.experiment.getName() + Experiment.getInstance(this._className).getAppletInfo(), "About " + this.experiment.getName(), 1);
            }
            catch (MalformedURLException malformedURLException) {
                JOptionPane.showMessageDialog(this, malformedURLException.getMessage());
                malformedURLException.printStackTrace();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, exception.getMessage());
                exception.printStackTrace();
            }
        } else if (actionEvent.getActionCommand().equals("Reset")) {
            this.experiment.reset();
        } else if (actionEvent.getActionCommand().equals("Snapshot")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BufferedImage bufferedImage = SOCRExperiments.this.capture();
                    if (SOCRExperiments.this.jfc == null) {
                        SOCRExperiments.this.jfc = new JFileChooser();
                    } else {
                        SOCRExperiments.this.jfc.setVisible(true);
                    }
                    int n = SOCRExperiments.this.jfc.showSaveDialog(null);
                    File file = SOCRExperiments.this.jfc.getSelectedFile();
                    SOCRExperiments.this.jfc.setVisible(false);
                    if (!file.getName().endsWith(".jpg")) {
                        file = new File(file.getAbsolutePath() + ".jpg");
                    }
                    String string = file.getName().substring(file.getName().lastIndexOf(46) + 1);
                    try {
                        ImageIO.write((RenderedImage)bufferedImage, string, file);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        JOptionPane.showMessageDialog(null, iOException, "Error Writing File", 0);
                    }
                }
            });
        }
    }

    private BufferedImage capture() {
        Robot robot;
        try {
            robot = new Robot();
        }
        catch (AWTException aWTException) {
            throw new RuntimeException(aWTException);
        }
        Rectangle rectangle = this.getContentPane().getBounds();
        Point point = rectangle.getLocation();
        SwingUtilities.convertPointToScreen(point, this.getContentPane());
        rectangle.setLocation(point);
        return robot.createScreenCapture(rectangle);
    }
}

