/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.stat.SOCR.core;

import edu.ucla.stat.SOCR.core.Distribution;
import edu.ucla.stat.SOCR.core.GraphPanel;
import edu.ucla.stat.SOCR.core.SOCRApplet;
import edu.ucla.stat.SOCR.core.ValueSetter;
import java.awt.AWTException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SOCRDistributions
extends SOCRApplet
implements ActionListener,
Observer {
    private GraphPanel graphPanel;
    private SOCRApplet.SOCRTextArea statusTextArea = new SOCRApplet.SOCRTextArea();
    JSplitPane container;
    protected Distribution dist;
    public static String ABOUT = "About";
    public static String HELP = "Help";
    public static String SNAPSHOT = "Snapshot";
    public JTextField leftCutOff;
    public JTextField rightCutOff;
    public JLabel leftCutOffLabel;
    public JLabel rightCutOffLabel;
    private JFileChooser jfc;

    public Object getCurrentItem() {
        return this.dist;
    }

    public void initGUI() {
        this.controlPanelTitle = "Distributions/Parameters";
        this.implementedFile = "implementedDistributions.txt";
        this.addButton(ABOUT, "Learn More About This Distribution!", this);
        this.addButton(HELP, "How to Use the Distribution Applets?", this);
        this.addButton(SNAPSHOT, "Take a Snapshot and save this Applet as JPG image", this);
        this.graphPanel = new GraphPanel(this);
        this.container = new JSplitPane(0, this.graphPanel, new JScrollPane(this.statusTextArea));
        this.leftCutOff = new JTextField(14);
        this.leftCutOffLabel = new JLabel("Left Cut Off");
        this.leftCutOffLabel.setLabelFor(this.leftCutOff);
        this.leftCutOff.setToolTipText("Left Cut Off for Computing Probability");
        this.leftCutOff.setActionCommand("leftCutOff");
        this.leftCutOff.addActionListener(this);
        this.addJTextField(this.leftCutOff, this.leftCutOffLabel);
        this.rightCutOff = new JTextField(14);
        this.rightCutOffLabel = new JLabel("Right Cut Off");
        this.rightCutOffLabel.setLabelFor(this.rightCutOff);
        this.rightCutOff.setToolTipText("Right Cut Off for Computing Probability");
        this.rightCutOff.setActionCommand("rightCutOff");
        this.rightCutOff.addActionListener(this);
        this.addJTextField(this.rightCutOff, this.rightCutOffLabel);
        this.fPresentPanel.setViewportView(this.container);
    }

    public void start() {
        this.container.setDividerLocation(0.6);
    }

    protected void itemChanged(String string) {
        try {
            this.dist = Distribution.getInstance(string);
            this.dist.addObserver(this);
            this.dist.initialize();
            this.graphPanel.setDistribution(this.dist);
            try {
                ValueSetter valueSetter = this.dist.getValueSetter(0);
                if (valueSetter != null) {
                    valueSetter.setValue(valueSetter.getValue());
                }
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            JOptionPane.showMessageDialog(this, "Sorry, not implemented yet");
            throwable.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(ABOUT)) {
            try {
                this.getAppletContext().showDocument(new URL(this.dist.getOnlineDescription()), "SOCR: Distribution Online Help (Mathematica)");
            }
            catch (MalformedURLException malformedURLException) {
                JOptionPane.showMessageDialog(this, malformedURLException.getMessage());
                malformedURLException.printStackTrace();
            }
        } else if (actionEvent.getActionCommand().equals(HELP)) {
            try {
                JOptionPane.showMessageDialog(this, this.dist.getLocalHelp());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, exception.getMessage());
                exception.printStackTrace();
            }
        } else if (actionEvent.getActionCommand().equals("leftCutOff")) {
            try {
                double d = new Double(this.leftCutOff.getText());
                System.out.println("LeftCutOff set at: " + d);
                this.graphPanel.setLeftCutOff(d);
            }
            catch (NumberFormatException numberFormatException) {
                double d = this.graphPanel.getLeftCutOff();
                this.leftCutOff.setText(new Double(d).toString());
                JOptionPane.showMessageDialog(this, "You must enter a Double numeric value!!!");
                numberFormatException.printStackTrace();
            }
        } else if (actionEvent.getActionCommand().equals("rightCutOff")) {
            try {
                double d = new Double(this.rightCutOff.getText());
                System.out.println("RightCutOff set at: " + d);
                this.graphPanel.setRightCutOff(d);
            }
            catch (NumberFormatException numberFormatException) {
                double d = this.graphPanel.getRightCutOff();
                this.rightCutOff.setText(new Double(d).toString());
                JOptionPane.showMessageDialog(this, "You must enter a Double numeric value!!!");
                numberFormatException.printStackTrace();
            }
        } else if (actionEvent.getActionCommand().equals(SNAPSHOT)) {
            SwingUtilities.invokeLater(new Runnable(){
                BufferedImage image;
                File f;
                String type;

                public void run() {
                    this.image = SOCRDistributions.this.capture();
                    if (SOCRDistributions.this.jfc == null) {
                        SOCRDistributions.this.jfc = new JFileChooser();
                    } else {
                        SOCRDistributions.this.jfc.setVisible(true);
                    }
                    int n = SOCRDistributions.this.jfc.showSaveDialog(null);
                    this.f = SOCRDistributions.this.jfc.getSelectedFile();
                    SOCRDistributions.this.jfc.setVisible(false);
                    if (!this.f.getName().endsWith(".jpg")) {
                        this.f = new File(this.f.getAbsolutePath() + ".jpg");
                    }
                    this.type = this.f.getName().substring(this.f.getName().lastIndexOf(46) + 1);
                    System.out.println("type " + this.type);
                    try {
                        ImageIO.write((RenderedImage)this.image, this.type, this.f);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        JOptionPane.showMessageDialog(null, iOException, "Error Writing File", 0);
                    }
                }
            });
        }
    }

    private BufferedImage capture() {
        Robot robot;
        try {
            robot = new Robot();
        }
        catch (AWTException aWTException) {
            throw new RuntimeException(aWTException);
        }
        Rectangle rectangle = this.getContentPane().getBounds();
        Point point = rectangle.getLocation();
        SwingUtilities.convertPointToScreen(point, this.getContentPane());
        rectangle.setLocation(point);
        return robot.createScreenCapture(rectangle);
    }

    public void update(Observable observable, Object object) {
        this.graphPanel.setDistribution(this.dist);
    }

    public void updateStatus() {
        if (this.dist == null) {
            return;
        }
        String string = "Mean: " + SOCRDistributions.format(this.dist.getMean());
        String string2 = "Median: " + SOCRDistributions.format(this.dist.getMedian());
        String string3 = "Variance: " + SOCRDistributions.format(this.dist.getVariance());
        String string4 = "Standard Deviation: " + SOCRDistributions.format(this.dist.getSD());
        String string5 = "Max Density: " + SOCRDistributions.format(this.dist.getMaxDensity());
        String string6 = "Left: " + SOCRDistributions.format(this.graphPanel.getLeftCDF());
        String string7 = "Right: " + SOCRDistributions.format(this.graphPanel.getRightCDF());
        String string8 = "Between: " + SOCRDistributions.format(this.graphPanel.getBetweenCDF());
        this.statusTextArea.setText(this.dist.getName() + "\n" + string + "\t\t\t" + string6 + '\n' + string2 + "\t\t\t" + string8 + '\n' + string3 + "\t\t\t" + string7 + '\n' + string4 + "\t\t" + string5);
    }
}

