/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.stat.SOCR.core;

import edu.ucla.stat.SOCR.chart.Chart;
import edu.ucla.stat.SOCR.chart.ChartTree_dynamic;
import edu.ucla.stat.SOCR.chart.DemoDescription;
import edu.ucla.stat.SOCR.core.SOCRApplet2;
import edu.ucla.stat.SOCR.gui.OKDialog;
import edu.ucla.stat.SOCR.gui.SOCROptionPane;
import edu.ucla.stat.SOCR.util.EditableHeader;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.JApplet;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SOCRChart
extends SOCRApplet2
implements ActionListener,
TreeSelectionListener,
AdjustmentListener {
    private SOCRApplet2.SOCRTextArea statusTextArea = new SOCRApplet2.SOCRTextArea();
    private Chart chart;
    private static final String baseCode = "edu.ucla.stat.SOCR.chart.demo.";
    protected JPanel rPanel;
    public static String ABOUT = "ABOUT";
    public static String SNAPSHOT = "SNAPSHOT";
    public static String HELP = "HELP";
    public static String COPY = "COPY";
    public static String PASTE = "PASTE";
    public static String SEARCH = "SEARCH";
    public static String FILE = "FILE OPEN";
    public File file;
    public FileInputStream Fileip;
    public FileDialog FileLocate;
    public Frame fDialog = new Frame();
    JFileChooser jfc;
    public Clipboard clipboard;
    public DefaultTableModel tModel;
    JTree tree;

    public Object getCurrentItem() {
        return this.chart;
    }

    public void init() {
        super.init();
        this.fControlPaneScrollBar.addAdjustmentListener(this);
        try {
            this.chart = Chart.getInstance((String)"edu.ucla.stat.SOCR.chart.demo.NoChart");
            this.chart.init();
            this.fPresentPanel.setViewportView(this.chart.getDisplayPane());
            this.fPresentPaneScrollBar.addAdjustmentListener((AdjustmentListener)this.chart);
        }
        catch (Throwable throwable) {
            SOCROptionPane.showMessageDialog((Component)this, (String)"Sorry, not implemented yet");
            throwable.printStackTrace();
        }
    }

    public void initGUI() {
        this.controlPanelTitle = "SOCR Charts/";
        this.implementedFile = "implementedCharts.txt";
        this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.addButton2(ABOUT, "Find Details about this Type of Chart", this);
        this.addButton2(HELP, "Help with This type of Chart", this);
        this.addButton2(SEARCH, "Searc for the right type of Chart", this);
        this.addButton(SNAPSHOT, "Save a Snapshot/Image of this SOCRChart Applet", this);
        this.addButton(COPY, "Copy data from table to mouse buffer", this);
        this.addButton(PASTE, "Paste in Data", this);
        this.addButton(FILE, "Open File", this);
        this.north.add(Box.createVerticalStrut(8));
        this.packControlPane();
        this.tree = new ChartTree_dynamic(this.implementedFile, this.codeBase).getTree();
        this.tree.addTreeSelectionListener(this);
        Color color = this.fControlPanel.getBackground();
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setBackgroundNonSelectionColor(color);
        this.tree.setCellRenderer(defaultTreeCellRenderer);
        this.tree.setOpaque(true);
        this.tree.setBackground(color);
        this.north.add(this.tree);
        this.north.add(Box.createVerticalStrut(8));
        super.initGUI();
    }

    protected TreePath[] findByName(JTree jTree, String string) {
        TreeNode treeNode = (TreeNode)jTree.getModel().getRoot();
        return this.find(jTree, new TreePath(treeNode), string);
    }

    private TreePath[] find(JTree jTree, TreePath treePath, String string) {
        Object object;
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        String string2 = treeNode.toString();
        if (string2.toLowerCase().indexOf(string) != -1) {
            arrayList.add(treePath);
        }
        if (treeNode.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                TreePath treePath2 = treePath.pathByAddingChild(object);
                TreePath[] treePathArray = this.find(jTree, treePath2, string);
                if (treePathArray == null) continue;
                for (int i = 0; i < treePathArray.length; ++i) {
                    arrayList.add(treePathArray[i]);
                }
            }
        }
        arrayList.trimToSize();
        int n = arrayList.size();
        object = new TreePath[n];
        for (int i = 0; i < n; ++i) {
            object[i] = (TreePath)arrayList.get(i);
        }
        return object;
    }

    protected TreePath findByNamePath(JTree jTree, String[] stringArray) {
        TreeNode treeNode = (TreeNode)jTree.getModel().getRoot();
        return this.find2(jTree, new TreePath(treeNode), stringArray, 0, true);
    }

    private TreePath find2(JTree jTree, TreePath treePath, Object[] objectArray, int n, boolean bl) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        Object object = treeNode;
        if (bl) {
            object = object.toString();
        }
        if (object.equals(objectArray[n])) {
            if (n == objectArray.length - 1) {
                return treePath;
            }
            if (treeNode.getChildCount() >= 0) {
                Enumeration<? extends TreeNode> enumeration = treeNode.children();
                while (enumeration.hasMoreElements()) {
                    TreeNode treeNode2 = enumeration.nextElement();
                    TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                    TreePath treePath3 = this.find2(jTree, treePath2, objectArray, n + 1, bl);
                    if (treePath3 == null) continue;
                    return treePath3;
                }
            }
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block29: {
            block34: {
                block33: {
                    block32: {
                        block31: {
                            TreePath[] treePathArray;
                            block30: {
                                block28: {
                                    if (!actionEvent.getActionCommand().equals(ABOUT)) break block28;
                                    try {
                                        this.popInfo(this.chart.getLocalAbout(), new URL(this.chart.getWikiAbout()), "SOCRChart: About");
                                    }
                                    catch (MalformedURLException malformedURLException) {
                                        malformedURLException.printStackTrace();
                                    }
                                    break block29;
                                }
                                if (!actionEvent.getActionCommand().equals(HELP)) break block30;
                                try {
                                    this.popInfo(this.chart.getLocalHelp(), new URL(this.chart.getWikiHelp()), "SOCRChart: Help");
                                }
                                catch (MalformedURLException malformedURLException) {
                                    malformedURLException.printStackTrace();
                                }
                                break block29;
                            }
                            if (!actionEvent.getActionCommand().equals(SEARCH)) break block31;
                            String string = (String)JOptionPane.showInputDialog(this, "Enter the search term:", "Search SOCRCharts list", -1, null, null, "Pie");
                            if (string.length() <= 0) break block29;
                            this.tree.clearSelection();
                            TreeNode treeNode = (TreeNode)this.tree.getModel().getRoot();
                            TreePath treePath = new TreePath(treeNode);
                            if (treeNode.getChildCount() >= 0) {
                                treePathArray = treeNode.children();
                                while (treePathArray.hasMoreElements()) {
                                    TreeNode treeNode2 = (TreeNode)treePathArray.nextElement();
                                    TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                                    this.tree.collapsePath(treePath2);
                                }
                            }
                            if ((treePathArray = this.findByName(this.tree, string.toLowerCase())).length > 0) {
                                for (int i = treePathArray.length - 1; i >= 0; --i) {
                                    this.tree.addSelectionPath(treePathArray[i]);
                                }
                            } else {
                                this.tree.setSelectionPath(treePath);
                            }
                            break block29;
                        }
                        if (!actionEvent.getActionCommand().equals(FILE)) break block32;
                        this.FileLocate = new FileDialog(this.fDialog);
                        this.FileLocate.setVisible(true);
                        this.fDialog.setVisible(true);
                        if (this.FileLocate.getFile() == null) break block29;
                        this.loadFileData(this.chart.dataTable);
                        break block29;
                    }
                    if (!actionEvent.getActionCommand().equals(SNAPSHOT)) break block33;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            BufferedImage bufferedImage = SOCRChart.this.capture();
                            if (SOCRChart.this.jfc == null) {
                                SOCRChart.this.jfc = new JFileChooser();
                            } else {
                                SOCRChart.this.jfc.setVisible(true);
                            }
                            int n = SOCRChart.this.jfc.showSaveDialog(null);
                            File file = SOCRChart.this.jfc.getSelectedFile();
                            SOCRChart.this.jfc.setVisible(false);
                            if (!file.getName().endsWith(".jpg")) {
                                file = new File(file.getAbsolutePath() + ".jpg");
                            }
                            String string = file.getName().substring(file.getName().lastIndexOf(46) + 1);
                            System.out.println("type " + string);
                            try {
                                ImageIO.write((RenderedImage)bufferedImage, string, file);
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                                JOptionPane.showMessageDialog(null, iOException, "Error Writing File", 0);
                            }
                        }
                    });
                    break block29;
                }
                if (!actionEvent.getActionCommand().equals(COPY)) break block34;
                String string = "";
                if (this.chart.tabbedPanelContainer.getTitleAt(this.chart.tabbedPanelContainer.getSelectedIndex()) != "DATA" && this.chart.tabbedPanelContainer.getTitleAt(this.chart.tabbedPanelContainer.getSelectedIndex()) != "SHOW ALL") break block29;
                int[] nArray = this.chart.dataTable.getSelectedRows();
                int[] nArray2 = this.chart.dataTable.getSelectedColumns();
                if (nArray2.length < 1 || nArray.length < 1) {
                    OKDialog oKDialog = new OKDialog(null, true, "Make a selection to copy data");
                    oKDialog.setVisible(true);
                } else {
                    for (int i = 0; i < nArray.length; ++i) {
                        for (int j = 0; j < nArray2.length; ++j) {
                            string = this.chart.dataTable.getValueAt(nArray[i], nArray2[j]) == null ? string + " \t" : string + this.chart.dataTable.getValueAt(nArray[i], nArray2[j]) + "\t";
                        }
                        string = string.substring(0, string.length() - 1) + "\n";
                    }
                }
                try {
                    StringSelection stringSelection = new StringSelection(string);
                    this.clipboard.setContents(stringSelection, stringSelection);
                }
                catch (Exception exception) {}
                break block29;
            }
            if (!actionEvent.getActionCommand().equals(PASTE)) break block29;
            int n = this.chart.dataTable.getSelectedRow();
            int n2 = this.chart.dataTable.getSelectedColumn();
            if (n == -1) {
                try {
                    this.clipboard.getContents(this);
                    DataFlavor[] dataFlavorArray = this.clipboard.getContents(this).getTransferDataFlavors();
                    String string = this.clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor).toString();
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "\t\f");
                    int n3 = stringTokenizer.countTokens();
                    if (n2 + n3 > this.chart.dataTable.getColumnCount()) {
                        this.chart.appendTableColumns(n2 + n3 - this.chart.dataTable.getColumnCount());
                    }
                    int n4 = 0;
                    TableColumnModel tableColumnModel = this.chart.dataTable.getColumnModel();
                    while (stringTokenizer.hasMoreTokens()) {
                        tableColumnModel.getColumn(n4 + n2 + 1).setHeaderValue(stringTokenizer.nextToken());
                        ++n4;
                    }
                    this.chart.dataTable.setTableHeader((JTableHeader)new EditableHeader(tableColumnModel));
                }
                catch (Exception exception) {
                    OKDialog oKDialog = new OKDialog(null, true, "Unalbe to paste header. Check the datatype.\n");
                    oKDialog.setVisible(true);
                    exception.printStackTrace();
                }
            } else {
                try {
                    this.clipboard.getContents(this);
                    DataFlavor[] dataFlavorArray = this.clipboard.getContents(this).getTransferDataFlavors();
                    String string = this.clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor).toString();
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
                    int n5 = stringTokenizer.countTokens();
                    if (n + n5 > this.chart.dataTable.getRowCount()) {
                        this.chart.appendTableRows(n + n5 - this.chart.dataTable.getRowCount());
                    }
                    int n6 = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        String[] stringArray = string2.split("\t");
                        int n7 = stringArray.length;
                        if (n2 + n7 > this.chart.dataTable.getColumnCount()) {
                            this.chart.appendTableColumns(n2 + n7 - this.chart.dataTable.getColumnCount());
                        }
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (stringArray[i].length() == 0) {
                                stringArray[i] = "0";
                            }
                            this.chart.dataTable.setValueAt(stringArray[i], n + n6, i + n2);
                        }
                        ++n6;
                    }
                }
                catch (Exception exception) {
                    OKDialog oKDialog = new OKDialog(null, true, "Unalbe to paste. Check the datatype.\n");
                    oKDialog.setVisible(true);
                    exception.printStackTrace();
                }
            }
        }
    }

    private void loadFileData(JTable jTable) {
        String string = "";
        try {
            this.file = new File(this.FileLocate.getDirectory(), this.FileLocate.getFile());
            this.Fileip = new FileInputStream(this.file);
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = this.chart.dataTable.getColumnCount();
            n = this.Fileip.read();
            String string2 = Character.toString((char)n);
            while (n != -1) {
                TableColumnModel tableColumnModel;
                if (n == 59 || n == 44 || n == 9) {
                    if (n3 == n4) {
                        this.tModel = (DefaultTableModel)jTable.getModel();
                        this.tModel.addColumn((Object)("C" + (n4 + 1)), new Vector(n4));
                        jTable.setModel(this.tModel);
                        tableColumnModel = jTable.getColumnModel();
                        jTable.setTableHeader((JTableHeader)new EditableHeader(tableColumnModel));
                        ++n4;
                    }
                    jTable.setValueAt(string, n2, n3);
                    ++n3;
                    string = "";
                } else {
                    if (n == 32) {
                        n = this.Fileip.read();
                        continue;
                    }
                    if (n == 13) {
                        if (n3 == n4) {
                            this.tModel = (DefaultTableModel)jTable.getModel();
                            this.tModel.addColumn((Object)("C" + (n4 + 1)), new Vector(n4));
                            jTable.setModel(this.tModel);
                            tableColumnModel = jTable.getColumnModel();
                            jTable.setTableHeader((JTableHeader)new EditableHeader(tableColumnModel));
                            ++n4;
                        }
                        jTable.setValueAt(string, n2, n3);
                        string = "";
                        ++n3;
                        while (n3 < jTable.getColumnCount()) {
                            jTable.setValueAt("", n2, n3);
                            ++n3;
                        }
                        n3 = 0;
                        if (++n2 == jTable.getRowCount()) {
                            this.tModel = (DefaultTableModel)jTable.getModel();
                            this.tModel.addRow(new Vector(2));
                            jTable.setModel(this.tModel);
                        }
                        if ((n = this.Fileip.read()) != 10) {
                            continue;
                        }
                    } else {
                        string = string + Character.toString((char)n);
                    }
                }
                n = this.Fileip.read();
            }
            while (n2 < jTable.getRowCount()) {
                for (n3 = 0; n3 < jTable.getColumnCount(); ++n3) {
                    jTable.setValueAt("", n2, n3);
                }
                ++n2;
            }
            this.Fileip.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            OKDialog oKDialog = new OKDialog((Frame)new JFrame(), true, "Exception caught");
            oKDialog.setVisible(true);
        }
    }

    private BufferedImage capture() {
        Robot robot;
        System.err.println("Before Robot! ");
        try {
            robot = new Robot();
        }
        catch (AWTException aWTException) {
            throw new RuntimeException(aWTException);
        }
        System.err.println("After Robot! ");
        Rectangle rectangle = this.getContentPane().getBounds();
        Point point = rectangle.getLocation();
        SwingUtilities.convertPointToScreen(point, this.getContentPane());
        System.err.println("Before screen.setLocation! ");
        rectangle.setLocation(point);
        return robot.createScreenCapture(rectangle);
    }

    public void updateStatus() {
        this.statusTextArea.setText(" status about the chart should go here!");
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getPath();
        Object object = treePath.getLastPathComponent();
        if (object != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            try {
                if (object2 instanceof DemoDescription) {
                    this.chart = Chart.getInstance((String)((DemoDescription)object2).getClassName());
                    this.chart.setApplet((JApplet)this);
                } else {
                    this.chart = Chart.getInstance((String)"edu.ucla.stat.SOCR.chart.demo.NoChart");
                }
                this.chart.init();
                this.fPresentPanel.setViewportView(this.chart.getDisplayPane());
                this.fPresentPaneScrollBar.addAdjustmentListener((AdjustmentListener)this.chart);
            }
            catch (Throwable throwable) {
                SOCROptionPane.showMessageDialog((Component)this, (String)("Sorry, " + this.chart.getClass().getName() + " not implemented yet"));
                throwable.printStackTrace();
            }
        }
        this.tree.scrollPathToVisible(treePath);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.tree.repaint();
    }
}

