/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.stat.SOCR.core;

import edu.ucla.stat.SOCR.core.IValueSettable;
import edu.ucla.stat.SOCR.core.SOCRJComboBox;
import edu.ucla.stat.SOCR.core.ValueSetter;
import edu.ucla.stat.SOCR.gui.SOCROptionPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.URL;
import java.text.DecimalFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public abstract class SOCRApplet
extends JApplet {
    public static final Color textColor = new Color(194, 215, 134);
    public static final Font textFont = new Font("SansSerif", 0, 12);
    protected URL codeBase;
    protected JSplitPane fSOCRPane;
    public JPanel fControlPanel = new JPanel(new BorderLayout());
    protected JScrollPane fPresentPanel = new JScrollPane();
    public String controlPanelTitle = "controlPanelTitle";
    public String implementedFile = null;
    private Box north = Box.createVerticalBox();
    private SOCRJComboBox implementedCombo;
    public JPanel buttonP;
    public JPanel jTextAreaPane;
    public JPanel valueSetterPane = new JPanel();
    private static DecimalFormat decimalFormat = new DecimalFormat("#.000000");

    public void init() {
        if (this.codeBase == null) {
            this.codeBase = this.getCodeBase();
        }
        this.initGUI();
        this.packControlPane();
        this.fSOCRPane = new JSplitPane(1, new JScrollPane(this.fControlPanel), this.fPresentPanel);
        this.fSOCRPane.setOneTouchExpandable(true);
        this.setContentPane(this.fSOCRPane);
        this.fireItemChanged();
    }

    public void setSOCRAppletCodeBase(URL uRL) {
        this.codeBase = uRL;
    }

    public URL getSOCRAppletCodeBase() {
        return this.codeBase;
    }

    public void start() {
    }

    protected void initGUI() {
    }

    protected void itemChanged(String string) {
    }

    public abstract Object getCurrentItem();

    public void packControlPaneExternalCall() {
        this.packControlPane();
    }

    private void packControlPane() {
        if (this.implementedFile != null) {
            try {
                this.implementedCombo = new SOCRJComboBox(new URL(this.codeBase, this.implementedFile).openStream());
                this.north.add(this.implementedCombo);
                this.implementedCombo.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SOCRApplet.this.fireItemChanged();
                    }
                });
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, exception.getMessage());
                exception.printStackTrace();
            }
            this.north.add(Box.createVerticalStrut(8));
        }
        if (this.buttonP != null) {
            this.north.add(this.buttonP);
        }
        this.fControlPanel.add((Component)this.north, "North");
        this.fControlPanel.add((Component)this.valueSetterPane, "Center");
        this.valueSetterPane.setLayout(new BoxLayout(this.valueSetterPane, 1));
        this.fControlPanel.setBorder(new TitledBorder(new EtchedBorder(), this.controlPanelTitle));
    }

    private void fireItemChanged() {
        this.valueSetterPane.removeAll();
        this.itemChanged(this.implementedCombo.getSelectedClassName());
        Object object = this.getCurrentItem();
        if (object instanceof IValueSettable) {
            ValueSetter[] valueSetterArray = ((IValueSettable)object).getValueSetters();
            for (int i = 0; i < valueSetterArray.length; ++i) {
                this.valueSetterPane.add(Box.createVerticalStrut(8));
                this.valueSetterPane.add(valueSetterArray[i]);
            }
            this.valueSetterPane.add(Box.createVerticalGlue());
        }
        this.valueSetterPane.validate();
        this.valueSetterPane.repaint();
    }

    public SOCRJComboBox getImplementedCombo() {
        return this.implementedCombo;
    }

    public void addButton(String string, ActionListener actionListener) {
        JButton jButton = new JButton(string);
        jButton.setName(string);
        jButton.addActionListener(actionListener);
        if (this.buttonP == null) {
            this.buttonP = new JPanel();
            this.buttonP.add(Box.createVerticalGlue());
        }
        this.buttonP.add(jButton);
    }

    public void addButton(String string, String string2, ActionListener actionListener) {
        JButton jButton = new JButton(string);
        jButton.setName(string);
        jButton.setToolTipText(string2);
        jButton.addActionListener(actionListener);
        if (this.buttonP == null) {
            this.buttonP = new JPanel();
            this.buttonP.add(Box.createVerticalGlue());
        }
        this.buttonP.add(jButton);
    }

    public void removeComponent(int n) {
        this.buttonP.remove(this.buttonP.getComponent(n));
    }

    public void addJScrollPane(JScrollPane jScrollPane) {
        if (this.buttonP == null) {
            this.buttonP = new JPanel();
            this.buttonP.add(Box.createHorizontalGlue());
        }
        this.buttonP.add(jScrollPane);
    }

    public void addButton(JButton jButton) {
        if (this.buttonP == null) {
            this.buttonP = new JPanel();
            this.buttonP.add(Box.createVerticalGlue());
        }
        this.buttonP.add(jButton);
    }

    public void addJCheckBox(JCheckBox jCheckBox) {
        if (this.buttonP == null) {
            this.buttonP = new JPanel();
            this.buttonP.add(Box.createHorizontalGlue());
        }
        this.buttonP.add(jCheckBox);
    }

    public void addJTextField(JTextField jTextField) {
        if (this.buttonP == null) {
            this.buttonP = new JPanel();
            this.buttonP.add(Box.createVerticalBox());
        }
        this.buttonP.add(jTextField);
    }

    public void addJTextField(JTextField jTextField, JLabel jLabel) {
        if (this.buttonP == null) {
            this.buttonP = new JPanel();
            this.buttonP.add(Box.createVerticalBox());
        }
        if (this.jTextAreaPane == null) {
            this.jTextAreaPane = new JPanel(new GridLayout(2, 2));
        }
        this.jTextAreaPane.add(jLabel);
        this.jTextAreaPane.add(jTextField);
        this.fControlPanel.add((Component)this.jTextAreaPane, "South");
    }

    public void addJLabel(String string) {
        if (this.buttonP == null) {
            this.buttonP = new JPanel();
            this.buttonP.add(Box.createHorizontalGlue());
        }
        this.buttonP.add(new JLabel(string));
    }

    public void addJPanel(JPanel jPanel) {
        if (this.buttonP == null) {
            this.buttonP = new JPanel();
            this.buttonP.add(Box.createHorizontalGlue());
        }
        this.valueSetterPane.add(Box.createVerticalStrut(8));
        this.valueSetterPane.add(jPanel);
        this.valueSetterPane.validate();
        this.valueSetterPane.repaint();
    }

    public void clearvalueSetterPane() {
        this.valueSetterPane.removeAll();
    }

    public String getAppletInfo() {
        return "Name: Statistics Online Compute Resource (SOCR)\r\nAuthor: Ivo Dinov, Ph.D.\r\nInstitution: UCLA Statistics/Neurology\r\nVersion: 1.0\r\nDate: 2000-2006 (06/29/2003)\r\nURL: http://www.socr.ucla.edu";
    }

    public static String format(double d) {
        return decimalFormat.format(d);
    }

    public void popInfo(String string, URL uRL, String string2) {
        try {
            boolean bl = InetAddress.getLocalHost().isLoopbackAddress();
            if (bl) {
                SOCROptionPane.showMessageDialog((Component)this, (String)string);
            } else {
                this.getAppletContext().showDocument(uRL, string2);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage());
            exception.printStackTrace();
        }
    }

    public static class SOCRTextArea
    extends JTextArea {
        public SOCRTextArea() {
            this.setBackground(textColor);
            this.setFont(textFont);
            this.setEditable(false);
        }
    }
}

