/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.stat.SOCR.core;

import edu.ucla.stat.SOCR.analyses.gui.Analysis;
import edu.ucla.stat.SOCR.analyses.gui.AnalysisPanel;
import edu.ucla.stat.SOCR.core.SOCRApplet;
import edu.ucla.stat.SOCR.gui.OKDialog;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

public class SOCRAnalyses
extends SOCRApplet
implements ActionListener {
    private JSplitPane container;
    private JPanel rightPanel;
    private AnalysisPanel graphPanel;
    private SOCRApplet.SOCRTextArea statusTextArea = new SOCRApplet.SOCRTextArea();
    private Analysis analysis;
    public static String ABOUT = "ABOUT";
    public static String SNAPSHOT = "SNAPSHOT";
    public static String HELP = "HELP";
    public static String COPY = "COPY";
    public static String PASTE = "PASTE";
    public static int PRESENT_PANEL_DEFAULT_WIDTH = 700;
    public static int PRESENT_PANEL_DEFAULT_HEIGHT = 700;
    JFileChooser jfc;
    public Clipboard clipboard;
    public DefaultTableModel tModel;

    public Object getCurrentItem() {
        return this.analysis;
    }

    public void init() {
        super.init();
    }

    public void initGUI() {
        this.controlPanelTitle = "Analysis/Parameters";
        this.implementedFile = "implementedAnalysis.txt";
        this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.addButton(ABOUT, "Find Details about this Type of Statistical Analysis", this);
        this.addButton(HELP, "Help with This type of Analysis", this);
        this.addButton(SNAPSHOT, "Save a Snapshot/Image of this SOCRAnalysis Applet", this);
        this.addButton(COPY, "Copy data from table to mouse buffer", this);
        this.addButton(PASTE, "Paste in Data", this);
        this.graphPanel = new AnalysisPanel(this);
        this.container = new JSplitPane(0, (Component)this.graphPanel, new JScrollPane(this.statusTextArea));
        this.fPresentPanel.setViewportView(this.container);
        this.fPresentPanel.setPreferredSize(new Dimension(PRESENT_PANEL_DEFAULT_WIDTH, PRESENT_PANEL_DEFAULT_HEIGHT));
    }

    protected void itemChanged(String string) {
        try {
            this.analysis = Analysis.getInstance((String)string);
            this.analysis.init();
            this.fPresentPanel.setViewportView(this.analysis.getDisplayPane());
        }
        catch (Throwable throwable) {
            JOptionPane.showMessageDialog(this, "Sorry, not implemented yet");
            throwable.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        System.out.println("SOCRAnalyses actionPerformed");
        if (actionEvent.getActionCommand().equals(ABOUT)) {
            System.out.println("SOCRAnalyses actionPerformed evt.getActionCommand().equals(ABOUT");
            try {
                this.getAppletContext().showDocument(new URL(this.analysis.getOnlineDescription()), "SOCR: Analysis Online Help (Mathematica)");
            }
            catch (MalformedURLException malformedURLException) {
                JOptionPane.showMessageDialog(this, malformedURLException.getMessage());
                malformedURLException.printStackTrace();
            }
        } else if (actionEvent.getActionCommand().equals(HELP)) {
            System.out.println("SOCRAnalyses actionPerformed evt.getActionCommand().equals(HELP");
            try {
                this.getAppletContext().showDocument(new URL(this.analysis.getOnlineHelp()), "SOCR: Analysis Online Help (Mathematica)");
            }
            catch (MalformedURLException malformedURLException) {
                JOptionPane.showMessageDialog(this, malformedURLException.getMessage());
                malformedURLException.printStackTrace();
            }
        } else if (actionEvent.getActionCommand().equals(SNAPSHOT)) {
            System.out.println("SOCRAnalyses actionPerformed evt.getActionCommand().equals(SNAPSHOT");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BufferedImage bufferedImage = SOCRAnalyses.this.capture();
                    if (SOCRAnalyses.this.jfc == null) {
                        SOCRAnalyses.this.jfc = new JFileChooser();
                    } else {
                        SOCRAnalyses.this.jfc.setVisible(true);
                    }
                    int n = SOCRAnalyses.this.jfc.showSaveDialog(null);
                    File file = SOCRAnalyses.this.jfc.getSelectedFile();
                    SOCRAnalyses.this.jfc.setVisible(false);
                    if (!file.getName().endsWith(".jpg")) {
                        file = new File(file.getAbsolutePath() + ".jpg");
                    }
                    String string = file.getName().substring(file.getName().lastIndexOf(46) + 1);
                    System.out.println("type " + string);
                    try {
                        ImageIO.write((RenderedImage)bufferedImage, string, file);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        JOptionPane.showMessageDialog(null, iOException, "Error Writing File", 0);
                    }
                }
            });
        } else if (actionEvent.getActionCommand().equals(COPY)) {
            System.out.println("SOCRAnalyses actionPerformed evt.getActionCommand().equals(COPY");
            String string = "";
            if (this.analysis.tabbedPanelContainer.getSelectedIndex() == 0) {
                Object object;
                int[] nArray = Analysis.dataTable.getSelectedRows();
                int[] nArray2 = Analysis.dataTable.getSelectedColumns();
                if (nArray2.length < 1 || nArray.length < 1) {
                    object = new OKDialog(null, true, "Make a selection to copy data");
                    object.setVisible(true);
                } else {
                    for (int i = 0; i < nArray.length; ++i) {
                        for (int j = 0; j < nArray2.length; ++j) {
                            if (Analysis.dataTable.getValueAt(nArray[i], nArray2[j]) == null) {
                                string = string + " \t";
                                continue;
                            }
                            string = string + Analysis.dataTable.getValueAt(nArray[i], nArray2[j]) + "\t";
                        }
                        string = string.substring(0, string.length() - 1) + "\n";
                    }
                }
                try {
                    object = new StringSelection(string);
                    this.clipboard.setContents((Transferable)object, (ClipboardOwner)object);
                }
                catch (Exception exception) {}
            }
        } else if (actionEvent.getActionCommand().equals(PASTE)) {
            System.out.println("SOCRAnalyses actionPerformed evt.getActionCommand().equals(PASTE");
            int n = Analysis.dataTable.getSelectedRow();
            int n2 = Analysis.dataTable.getSelectedColumn();
            if (n == -1) {
                OKDialog oKDialog = new OKDialog(null, true, "Select a row to paste data");
                oKDialog.setVisible(true);
            } else {
                try {
                    this.clipboard.getContents(this);
                    DataFlavor[] dataFlavorArray = this.clipboard.getContents(this).getTransferDataFlavors();
                    DataFlavor cfr_ignored_0 = dataFlavorArray[0];
                    String string = this.clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor).toString();
                    System.err.println(string);
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
                    int n3 = stringTokenizer.countTokens();
                    if (n + n3 > Analysis.dataTable.getRowCount()) {
                        this.appendTableRows(n + n3 - Analysis.dataTable.getRowCount());
                    }
                    int n4 = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "\t\f");
                        int n5 = 0;
                        while (stringTokenizer2.hasMoreTokens()) {
                            Analysis.dataTable.setValueAt(stringTokenizer2.nextToken(), n + n4, n5 + n2);
                            ++n5;
                        }
                        ++n4;
                    }
                }
                catch (Exception exception) {
                    OKDialog oKDialog = new OKDialog(null, true, "Unalbe to paste. Check the datatype.\nNumber of columns from PASTE data cannot exceed number of columns in Table");
                    oKDialog.setVisible(true);
                    exception.printStackTrace();
                }
            }
        }
    }

    public void appendTableRows(int n) {
        int n2 = Analysis.dataTable.getSelectedColumn();
        int n3 = Analysis.dataTable.getColumnCount();
        this.tModel = (DefaultTableModel)Analysis.dataTable.getModel();
        for (int i = 0; i < n; ++i) {
            this.tModel.addRow(new Vector(n3));
        }
        Analysis.dataTable.setModel(this.tModel);
    }

    private BufferedImage capture() {
        Robot robot;
        System.err.println("Before Robot! ");
        try {
            robot = new Robot();
        }
        catch (AWTException aWTException) {
            throw new RuntimeException(aWTException);
        }
        System.err.println("After Robot! ");
        Rectangle rectangle = this.getContentPane().getBounds();
        Point point = rectangle.getLocation();
        SwingUtilities.convertPointToScreen(point, this.getContentPane());
        System.err.println("Before screen.setLocation! ");
        rectangle.setLocation(point);
        return robot.createScreenCapture(rectangle);
    }
}

