/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.stat.SOCR.core;

import JSci.awt.DefaultGraph2DModel;
import edu.ucla.stat.SOCR.core.Modeler;
import edu.ucla.stat.SOCR.core.sampler;
import edu.ucla.stat.SOCR.modeler.ModelerColor;
import edu.ucla.stat.SOCR.modeler.ModelerDimension;
import edu.ucla.stat.SOCR.util.ModelerHistogram;
import edu.ucla.stat.SOCR.util.OKDialog;
import edu.ucla.stat.SOCR.util.PluginLoader;
import edu.ucla.stat.SOCR.util.SOCRJTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.text.DecimalFormat;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

public class ModelerGui
extends JApplet
implements FocusListener,
KeyListener,
ActionListener,
MouseListener,
MouseMotionListener {
    private ButtonGroup buttonGroup = new ButtonGroup();
    private int time = 0;
    private int toolbarCount = 0;
    private int graphCount = 0;
    private int tabbedPaneCount = 0;
    private int tableCount = 0;
    private URL codeBase;
    private JPanel modelerApplet = new JPanel();
    private JPanel tables = new JPanel();
    public Clipboard clipboard;
    private JButton resetButton = new JButton("Reset");
    private JButton topAboutButton = new JButton("About");
    private JButton fitButton = new JButton("Fit Model");
    public float[] xhist;
    public float[] yhist;
    public float[] rawDat;
    public int histBinNos = 10;
    public int scale = 0;
    public double[] modelXData;
    public double[] modelYData;
    public DefaultGraph2DModel model;
    public boolean scaleUp = false;
    static int CURVE_FIT = 0;
    public int modelType = 1;
    public Modeler modelObject;
    private JTextArea recordTable = new JTextArea(5, 15);
    private JFrame appletFrame;
    private DecimalFormat decimalFormat = new DecimalFormat();
    protected JPanel dataPanel;
    protected JPanel resultPanel;
    protected JPanel graphPanel;
    protected JPanel datGenPanel;
    protected JPanel infoPanel;
    public JTabbedPane tabbedPanelContainer;
    public JTextArea resultPanelTextArea;
    public JTextArea infoPanelTextArea;
    public SOCRJTable dataTable;
    public JTextField DataPts = new JTextField("10", 3);
    public JLabel lDataPts = new JLabel("Number of Data Points");
    private JButton fillTable = new JButton("Fill Table");
    public DefaultTableModel tModel;
    public Object[][] dataObject;
    protected String dataText = "";
    public int columnNumber = 2;
    public int rowNumber = 100;
    public String[] columnNames;
    public static final double GUI_UPPER_LIMIT = 501.0;
    public static final double GUI_LOWER_LIMIT = -501.0;
    public double modelUpperlimit = 501.0;
    public double modelLowerlimit = -501.0;
    public double defaultXMax = 10.0;
    public double defaultXMin = -10.0;
    public double defaultYMin = 0.0;
    public double defaultYMax = 10.0;
    private double xScaleMin;
    private double xScaleMax;
    private double yScaleMax;
    private boolean xIsPos = false;
    public ModelerHistogram graph = null;
    private Dimension tabbedPaneDim = new Dimension(ModelerDimension.TABBED_PANE_WIDTH, ModelerDimension.TABBED_PANE_HEIGHT);
    public sampler samplePanel;
    public PluginLoader pLoader;
    private TableColumnModel columnModel;
    public static final String VALUE_COLUMN_NAME = "Value";
    public static final String FREQUENCY_COLUMN_NAME = "Frequency";
    private boolean reinitMixtureModel = true;
    private boolean rescaleClicked = false;

    public ModelerGui() {
        this.graph = new ModelerHistogram(-501.0, 501.0, 1.0);
    }

    public void setCodeBase(URL uRL) {
        this.codeBase = uRL;
    }

    public void init() {
        this.graph.setType(0);
        this.setName("ModelerGui");
        this.setBackground(ModelerColor.GRAPH_BACKGROUND);
        this.getContentPane().setLayout(new BorderLayout());
        this.resultPanel = new JPanel();
        this.resultPanelTextArea = new JTextArea(ModelerDimension.RESULT_ROW, ModelerDimension.RESULT_COL);
        this.resultPanel.add(new JScrollPane(this.resultPanelTextArea));
        this.infoPanel = new JPanel();
        this.infoPanelTextArea = new JTextArea(ModelerDimension.INFO_ROW, ModelerDimension.INFO_COL);
        this.infoPanel.add(new JScrollPane(this.infoPanelTextArea));
        this.graphPanel = new JPanel(new BorderLayout());
        this.graph.addMouseListener((MouseListener)this);
        this.graphPanel.add((Component)this.graph, "Center");
        this.dataObject = new Object[this.rowNumber][this.columnNumber];
        this.columnNames = new String[this.columnNumber];
        this.columnNames[0] = new String(VALUE_COLUMN_NAME);
        this.columnNames[1] = new String(FREQUENCY_COLUMN_NAME);
        this.dataTable = new SOCRJTable(this.dataObject, this.columnNames);
        this.dataPanel = new JPanel();
        int n = 20;
        int n2 = 30;
        this.dataPanel.add(new JScrollPane((Component)this.dataTable, n, n2));
        this.tabbedPanelContainer = new JTabbedPane();
        this.datGenPanel = new JPanel();
        this.datGenPanel.add(this.lDataPts);
        this.datGenPanel.add(this.DataPts);
        this.fillTable.addActionListener(this);
        this.datGenPanel.add(this.fillTable);
        this.samplePanel = new sampler(this.dataTable, this.codeBase);
        this.infoPanelTextArea.setText("Data Modeler \n Specific information unavailable");
        JPanel jPanel = this.samplePanel.getPanel();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        this.dataPanel.setBackground(ModelerColor.PANEL_DATA_BACKGROUND);
        this.graphPanel.setBackground(ModelerColor.PANEL_GRAPH_BACKGROUND);
        this.resultPanel.setBackground(ModelerColor.PANEL_RESULT_BACKGROUND);
        this.infoPanel.setBackground(ModelerColor.PANEL_ABOUT_BACKGROUND);
        jPanel.setBackground(ModelerColor.PANEL_SAMPLE_BACKGROUND);
        this.graphPanel.setForeground(ModelerColor.PANEL_DATA_FOREGROUND);
        this.resultPanel.setForeground(ModelerColor.PANEL_RESULT_FOREGROUND);
        this.infoPanel.setForeground(ModelerColor.PANEL_ABOUT_FOREGROUND);
        jPanel.setForeground(ModelerColor.PANEL_SAMPLE_BACKGROUND);
        this.addTabbedPane("Data", this.dataPanel);
        this.addTabbedPane("Graphs", this.graphPanel);
        this.addTabbedPane("Results", this.resultPanel);
        this.addTabbedPane("About the Model", this.infoPanel);
        this.addTabbedPane("Data Generation", jPanel2);
        this.getContentPane().setBackground(ModelerColor.WHITE);
        this.getContentPane().add((Component)this.tabbedPanelContainer, "North");
        this.recordTable.setEditable(false);
        this.dataTable.addFocusListener((FocusListener)this);
        this.dataPanel.addFocusListener(this);
        this.columnModel = this.dataTable.getColumnModel();
    }

    public static Modeler getInstance(String string) throws Exception {
        Class<?> clazz = Class.forName(string);
        if (clazz == null) {
            return null;
        }
        return (Modeler)clazz.newInstance();
    }

    public void fitC(boolean bl, boolean bl2, boolean bl3) {
        this.rescaleClicked = bl;
        this.scaleUp = bl2;
        this.reinitMixtureModel = bl3;
        this.fitC();
    }

    public void fitC(boolean bl) {
        this.fitC();
    }

    public void fitC() {
        double d = 0.0;
        double d2 = 0.0;
        if (this.rawDat != null && this.rawDat.length > 0 && this.modelObject != null) {
            this.setScale(this.graph, this.modelObject);
            d = this.modelObject.getGraphLowerLimit();
            d2 = this.modelObject.getGraphUpperLimit();
            this.modelObject.fitCurve(this.rawDat, (float)d, (float)d2, this.resultPanelTextArea, this.rescaleClicked, this.scaleUp, this.reinitMixtureModel);
            this.modelXData = this.modelObject.returnModelX();
            this.modelYData = this.modelObject.returnModelY();
            this.modelType = this.modelObject.getModelType();
            int n = this.modelXData.length;
            if (this.modelObject.getModelType() == 102) {
                // empty if block
            }
            if (this.scaleUp && (this.modelType == 1 || this.modelType == 2)) {
                int n2;
                float f;
                float f2 = 0.0f;
                if (this.dataTable.getColumnCount() == 2) {
                    f = this.xhist[1] - this.xhist[0];
                    for (n2 = 1; n2 < this.yhist.length; ++n2) {
                        f2 += this.yhist[n2];
                    }
                    f2 *= f;
                } else {
                    f = this.xhist[1] - this.xhist[0];
                    for (n2 = 1; n2 < this.yhist.length; ++n2) {
                        f2 += this.yhist[n2];
                    }
                    f2 *= f;
                }
                for (int i = 0; i < this.modelYData.length; ++i) {
                    this.modelYData[i] = this.modelYData[i] * (double)f2;
                }
            }
            this.graph.setModelCount(this.modelObject.getModelCount());
            this.graph.setModel(this.modelXData.length, this.modelXData, this.modelYData);
            this.repaint();
            if (this.modelType == 5 || this.modelType == 6) {
                this.resultPanelTextArea.append("\n Chi-Square not implemented");
            }
            this.graph.validate();
            this.graph.setModelType(this.modelObject.getModelType());
            this.graph.repaint();
            this.graphPanel.validate();
            this.graphPanel.repaint();
        }
    }

    public void syncMouseData() {
        if (this.graph.getdataCursor() > 0 && this.modelObject.getModelType() != 101 && this.modelObject.getModelType() != 102) {
            this.xhist = this.graph.getXData();
            this.yhist = this.graph.getYData();
            this.histToRaw();
            this.dataTable.clearTable();
            if (this.dataTable.getColumnCount() == 1) {
                if (this.dataTable.getRowCount() < this.rawDat.length) {
                    this.dataTable.appendTableRows(this.rawDat.length - this.dataTable.getRowCount());
                }
                for (int i = 0; i < this.rawDat.length; ++i) {
                    this.dataTable.setValueAt((Object)Float.toString(this.rawDat[i]), i, 0);
                }
            } else {
                if (this.dataTable.getRowCount() < this.xhist.length) {
                    this.dataTable.appendTableRows(this.xhist.length - this.dataTable.getRowCount());
                }
                for (int i = 0; i < this.xhist.length; ++i) {
                    this.dataTable.setValueAt((Object)Float.toString(this.xhist[i]), i, 0);
                    this.dataTable.setValueAt((Object)Float.toString(this.yhist[i]), i, 1);
                }
            }
        }
        if (this.graph.getdataCursor() > 1) {
            this.fitC();
        }
    }

    public void syncData() {
        this.rawDat = null;
        this.xhist = null;
        this.yhist = null;
        if (this.modelObject == null) {
            if (this.dataTable.getColumnCount() == 1) {
                this.rawDat = this.dataTable.getTableVal(0);
                if (this.rawDat != null) {
                    this.graph.clear();
                    this.graph.setxy(this.rawDat);
                    this.xhist = this.graph.getXData();
                    this.yhist = this.graph.getYData();
                    this.fitC();
                }
            } else {
                this.xhist = this.dataTable.getTableVal(0);
                this.yhist = this.dataTable.getTableVal(1);
                if (this.xhist != null && this.yhist != null && this.xhist.length == this.yhist.length) {
                    this.histToRaw();
                    this.graph.clear();
                    this.graph.setxy(this.rawDat);
                    this.fitC();
                }
            }
        } else if (this.modelObject.getModelType() != 5 && this.modelObject.getModelType() != 6) {
            if (this.dataTable.getColumnCount() == 1) {
                this.rawDat = this.dataTable.getTableVal(0);
                if (this.rawDat != null) {
                    this.graph.clear();
                    this.graph.setxy(this.rawDat);
                    this.xhist = this.graph.getXData();
                    this.yhist = this.graph.getYData();
                    this.fitC();
                }
            } else {
                this.xhist = this.dataTable.getTableVal(0);
                this.yhist = this.dataTable.getTableVal(1);
                if (this.xhist != null && this.yhist != null && this.xhist.length == this.yhist.length) {
                    this.histToRaw();
                    this.graph.clear();
                    this.graph.setxy(this.rawDat);
                    this.fitC();
                }
            }
        } else {
            this.rawDat = this.dataTable.getTableVal(0);
            if (this.rawDat != null) {
                this.graph.clear();
                this.graph.setxy(this.rawDat);
                this.fitC();
            }
        }
    }

    public String getAppletInfo() {
        return "\n UCLA Department of Statistics: SOCR Resource:: Modeler\n\n";
    }

    public void start() {
        this.appletFrame = ModelerGui.getFrame(this.getContentPane());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.resetButton) {
            this.reset();
        }
        if (actionEvent.getSource() == this.topAboutButton) {
            // empty if block
        }
        if (actionEvent.getSource() == this.fillTable) {
            if (this.dataTable.getColumnCount() > 1) {
                OKDialog oKDialog = new OKDialog(null, true, "Only raw data can be filled. Check Raw Data box and try again");
                oKDialog.setVisible(true);
            } else {
                this.clearData();
                int n = Integer.parseInt(this.DataPts.getText());
                if (n < 1) {
                    OKDialog oKDialog = new OKDialog(null, true, "Number of points must be greater than 0");
                    oKDialog.setVisible(true);
                } else if (this.dataTable.getRowCount() < n) {
                    this.dataTable.appendTableRows(n - this.dataTable.getRowCount());
                }
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.graph) {
            this.syncMouseData();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void reset() {
        this.reinitMixtureModel = true;
        this.time = 0;
    }

    private static JFrame getFrame(Container container) {
        JFrame jFrame = null;
        while ((container = container.getParent()) != null) {
            if (!(container instanceof JFrame)) continue;
            jFrame = (JFrame)container;
        }
        return jFrame;
    }

    public String getOnlineDescription() {
        return new String("http://socr.stat.ucla.edu/");
    }

    public void addTabbedPane(String string, JComponent jComponent) {
        this.tabbedPanelContainer.addTab(string, jComponent);
        ++this.tabbedPaneCount;
    }

    public void clearData() {
        this.graph.clear();
        this.dataTable.clearTable();
        this.resultPanelTextArea.setText("");
        if (this.modelType == 0) {
            this.graph.setYExtrema(-5.0f, 5.0f);
            this.graph.setXExtrema(-5.0f, 5.0f);
        } else {
            this.graph.setYExtrema(1.0f, 5.0f);
            this.graph.setXExtrema(-5.0f, 5.0f);
        }
    }

    public void toggleParams(boolean bl) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\t') {
            // empty if block
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.dataTable) {
            this.syncData();
        }
        if (focusEvent.getSource() == this.dataPanel) {
            this.syncData();
        }
    }

    public void rawToHist() {
        int n;
        this.xhist = new float[this.histBinNos];
        this.yhist = new float[this.histBinNos];
        float f = this.rawDat[0];
        float f2 = this.rawDat[0];
        for (n = 1; n < this.rawDat.length; ++n) {
            if (this.rawDat[n] > f2) {
                f2 = this.rawDat[n];
            }
            if (!(this.rawDat[n] < f)) continue;
            f = this.rawDat[n];
        }
        for (n = 0; n < this.xhist.length; ++n) {
            this.xhist[n] = f + (float)n * (f2 - f) / (float)this.histBinNos;
        }
        this.yhist = this.histBins(this.rawDat, f, f2);
    }

    public float[] histBins(float[] fArray, float f, float f2) {
        for (int i = 0; i < this.histBinNos; ++i) {
            this.yhist[i] = 0.0f;
        }
        float f3 = (f2 - f) / (float)this.histBinNos;
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < this.histBinNos; ++j) {
                if (!(fArray[i] >= f + (float)j * f3) || !(fArray[i] < f + (float)(j + 1) * f3)) continue;
                int n = j;
                this.yhist[n] = this.yhist[n] + 1.0f;
            }
        }
        return this.yhist;
    }

    public void histToRaw() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.yhist.length; ++n) {
            n2 += (int)this.yhist[n];
        }
        this.rawDat = new float[n2];
        n = 0;
        for (int i = 0; i < this.xhist.length; ++i) {
            for (int j = 0; j < (int)this.yhist[i]; ++j) {
                this.rawDat[n] = this.xhist[i];
                ++n;
            }
        }
    }

    public void setBins(int n) {
        this.histBinNos = n;
        this.graph.setBins(n);
        this.syncData();
    }

    public void setXScale(int n, boolean bl) {
        this.graph.setxMax((double)n);
        this.xScaleMin = bl ? 0.0 : (double)(-n);
        this.xScaleMax = n;
        this.graph.setxMin((double)(-n));
        this.syncData();
    }

    public void setYScale(int n) {
        this.graph.setyMax((double)n);
        this.syncData();
    }

    public void panLeft() {
        this.graph.panLeft();
    }

    public void panRight() {
        this.graph.panRight();
    }

    public int zoomIn(int n, boolean bl) {
        bl = false;
        int n2 = this.graph.zoomIn();
        this.xScaleMin = bl ? 0.0 : (this.xScaleMin /= 2.0);
        this.xScaleMax /= 2.0;
        this.graph.setPlotXMin(this.xScaleMin);
        this.graph.setPlotXMax(this.xScaleMax);
        if (n2 == 1) {
            this.syncData();
            this.setBins(n);
        }
        return n2;
    }

    public int zoomOut(int n, boolean bl) {
        bl = false;
        int n2 = this.graph.zoomOut();
        this.xScaleMin = bl ? 0.0 : (this.xScaleMin *= 2.0);
        this.xScaleMax *= 2.0;
        this.graph.setPlotXMin(this.xScaleMin);
        this.graph.setPlotXMax(this.xScaleMax);
        if (n2 == 1) {
            this.syncData();
            this.setBins(n);
        }
        return n2;
    }

    public void zoomInY(double d, boolean bl) {
        this.yScaleMax = d;
        this.graph.setPlotYMax(this.yScaleMax);
        this.syncData();
    }

    public void usePosX() {
        if (!this.xIsPos) {
            this.xScaleMax *= 2.0;
            this.xIsPos = true;
        }
        this.graph.setPlotXMin(0.0);
        this.graph.setPlotXMax(this.xScaleMax);
        this.syncData();
    }

    public void usePosNegX() {
        if (this.xIsPos) {
            this.xScaleMax /= 2.0;
            this.xIsPos = false;
        }
        this.graph.setPlotXMin(this.xScaleMin);
        this.graph.setPlotXMax(this.xScaleMax);
        this.syncData();
    }

    public void setUpperLimit(double d) {
        this.modelUpperlimit = d;
    }

    public void setLowerLimit(double d) {
        this.modelLowerlimit = d;
    }

    private void setScale(ModelerHistogram modelerHistogram, Modeler modeler) {
        modelerHistogram.setLeft(this.modelLowerlimit);
        modelerHistogram.setRight(this.modelUpperlimit);
        modelerHistogram.setGraphLeft(-501.0);
        modelerHistogram.setGraphRight(501.0);
        modelerHistogram.setPlotXMin(this.xScaleMin);
        modelerHistogram.setPlotXMax(this.xScaleMax);
        if (modeler.isContinuous()) {
            modelerHistogram.setBarWidth((this.modelUpperlimit - this.modelLowerlimit) / 10.0);
        } else {
            modelerHistogram.setBarWidth(1.0);
        }
    }

    public boolean useInitButton() {
        return this.modelObject.useInitButton();
    }
}

