/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.stat.SOCR.core;

import edu.ucla.stat.SOCR.core.Distribution;
import edu.ucla.stat.SOCR.core.SOCRDistributions;
import edu.ucla.stat.SOCR.distributions.Domain;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class GraphPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private int leftMargin;
    private int rightMargin;
    private int topMargin;
    private int bottomMargin;
    private double xMin;
    private double xMax;
    private double yMin;
    private double yMax;
    private Distribution dist;
    private Domain domain;
    private int type;
    private int xPosition = 0;
    private int yPosition = 0;
    private double left;
    private double right;
    private double leftx;
    private double rightx;
    SOCRDistributions container;
    private Font font = new Font("sansserif", 0, 11);
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int ABOVE = 2;
    public static final int BELOW = 3;
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    public static final int MIDPOINTS = 0;
    public static final int BOUNDS = 1;
    public static final int DISCRETE = 0;
    public static final int CONTINUOUS = 1;
    public static final int MIXED = 2;
    public DecimalFormat decimalFormat = new DecimalFormat();

    public GraphPanel(SOCRDistributions sOCRDistributions) {
        this.container = sOCRDistributions;
        this.setScale(0.0, 1.0, 0.0, 1.0);
        this.setMargins(30, 30, 30, 30);
        this.setBackground(Color.white);
        this.setFont(this.font);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public void setDistribution(Distribution distribution) {
        if (distribution != null) {
            this.dist = distribution;
            this.domain = this.dist.getDomain();
            this.type = this.dist.getType();
            this.left = this.domain.getLowerBound();
            this.right = this.domain.getUpperBound();
            if (this.dist.getMaxDensity() < 1.0) {
                this.setScale(this.left, this.right, 0.0, this.dist.getMaxDensity() / 0.7);
            } else {
                this.setScale(this.left, this.right, 0.0, this.dist.getMaxDensity());
            }
        }
        this.repaint();
    }

    public void setLeftCutOff(double d) {
        if (d <= this.right && d >= this.domain.getLowerBound()) {
            this.left = d;
            if (this.type == 0 && d >= this.domain.getLowerBound() + 0.5) {
                this.rigidIntegralMotionOfDiscriteDistributions(true);
            }
            this.repaint();
        } else if (this.type == 0) {
            this.container.leftCutOff.setText(new Double(this.left + 0.5).toString());
        } else if (this.type == 1) {
            this.container.leftCutOff.setText(new Double(this.left).toString());
        }
    }

    public void setRightCutOff(double d) {
        if (d >= this.left && d <= this.domain.getUpperBound()) {
            this.right = d;
            if (this.type == 0 && d <= this.domain.getUpperBound() - 0.5) {
                this.rigidIntegralMotionOfDiscriteDistributions(false);
            }
            this.repaint();
        } else if (this.type == 0) {
            this.container.rightCutOff.setText(new Double(this.right - 0.5).toString());
        } else if (this.type == 1) {
            this.container.rightCutOff.setText(new Double(this.right).toString());
        }
    }

    public double getLeftCutOff() {
        if (this.type == 0) {
            return (int)(this.left - 0.5);
        }
        return this.left;
    }

    public double getRightCutOff() {
        if (this.type == 0) {
            return (int)(this.right - 0.5);
        }
        return this.right;
    }

    public void setScale(double d, double d2, double d3, double d4) {
        this.xMin = d;
        this.xMax = d2;
        this.yMin = d3;
        this.yMax = d4;
    }

    public void setMargins(int n, int n2, int n3, int n4) {
        this.leftMargin = n;
        this.rightMargin = n2;
        this.bottomMargin = n3;
        this.topMargin = n4;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        SwingUtilities.getRoot(this).validate();
        this.container.updateStatus();
        if (this.dist != null) {
            int n;
            double d = this.domain.getWidth();
            double d2 = this.domain.getSize();
            graphics.setColor(Color.black);
            this.drawAxis(graphics, 0.0, this.yMax, 0.1 * this.yMax, this.xMin, 0);
            this.drawAxis(graphics, this.domain, 0.0, 1, this.type);
            graphics.drawLine(this.leftMargin, this.topMargin, this.getWidth() - this.rightMargin, this.topMargin);
            graphics.drawLine(this.getWidth() - this.rightMargin, this.topMargin, this.getWidth() - this.rightMargin, this.getHeight() - this.bottomMargin);
            graphics.setColor(Color.red);
            if (this.type == 0) {
                double d3;
                n = 0;
                while ((double)n < d2) {
                    d3 = this.domain.getValue(n);
                    this.drawBox(graphics, d3 - d / 2.0, 0.0, d3 + d / 2.0, this.dist.getDensity(d3));
                    ++n;
                }
                double d4 = this.left;
                double d5 = this.right;
                double d6 = (d5 - d4) / (double)(this.getWidth() - this.leftMargin - this.rightMargin);
                for (d3 = d4; d3 < d5; d3 += d6) {
                    this.drawLine(graphics, d3, this.dist.getDensity(d3), d3, 0.0);
                }
            } else {
                double d7;
                double d8 = this.domain.getLowerValue();
                double d9 = this.domain.getUpperValue();
                double d10 = (d9 - d8) / (double)(this.getWidth() - this.leftMargin - this.rightMargin);
                for (d7 = d8; d7 < d9; d7 += d10) {
                    this.drawLine(graphics, d7, this.dist.getDensity(d7), d7 + d10, this.dist.getDensity(d7 + d10));
                }
                d8 = this.left;
                d9 = this.right;
                for (d7 = d8; d7 < d9; d7 += d10) {
                    this.drawLine(graphics, d7, this.dist.getDensity(d7), d7, 0.0);
                }
            }
            if (this.xPosition > this.leftMargin && this.xPosition < this.getWidth() - this.rightMargin && this.yPosition > this.topMargin && this.yPosition < this.getHeight() - this.bottomMargin) {
                graphics.setColor(Color.black);
                n = this.yGraph(this.dist.getDensity(this.xScale(this.xPosition)));
                graphics.drawLine(this.xPosition, n - 6, this.xPosition, n + 6);
                graphics.drawLine(this.xPosition - 6, n, this.xPosition + 6, n);
                String string = "";
                string = this.type == 0 ? "( " + (double)((int)(this.xScale(this.xPosition) + 0.5 * this.domain.getWidth())) / this.domain.getWidth() + ", " + this.format(this.dist.getDensity(this.xScale(this.xPosition))) + " )" : "( " + this.format(this.xScale(this.xPosition)) + ", " + this.format(this.dist.getDensity(this.xScale(this.xPosition))) + " )";
                graphics.drawString(string, this.xPosition + 5, n - 5);
            }
        }
    }

    public int xGraph(double d) {
        return this.leftMargin + (int)((d - this.xMin) / (this.xMax - this.xMin) * (double)(this.getSize().width - this.leftMargin - this.rightMargin));
    }

    public int yGraph(double d) {
        return this.getSize().height - this.bottomMargin - (int)((d - this.yMin) / (this.yMax - this.yMin) * (double)(this.getSize().height - this.bottomMargin - this.topMargin));
    }

    public double xScale(int n) {
        return this.xMin + (double)(n - this.leftMargin) / (double)(this.getSize().width - this.leftMargin - this.rightMargin) * (this.xMax - this.xMin);
    }

    public double yScale(int n) {
        return this.yMin + (double)(this.getSize().height - n - this.bottomMargin) / (double)(this.getSize().height - this.bottomMargin - this.topMargin) * (this.yMax - this.yMin);
    }

    public int xPixels(double d) {
        return this.xGraph(this.xMin + d) - this.xGraph(this.xMin);
    }

    public int yPixels(double d) {
        return this.yGraph(this.yMin + d) - this.yGraph(this.yMin);
    }

    public void drawLine(Graphics graphics, double d, double d2, double d3, double d4) {
        graphics.drawLine(this.xGraph(d), this.yGraph(d2), this.xGraph(d3), this.yGraph(d4));
    }

    public void drawTick(Graphics graphics, double d, double d2, int n, int n2, int n3) {
        int n4 = this.xGraph(d);
        int n5 = this.yGraph(d2);
        if (n3 == 0) {
            graphics.drawLine(n4, n5 - n2, n4, n5 + n);
        } else {
            graphics.drawLine(n4 - n, n5, n4 + n2, n5);
        }
    }

    public void drawTick(Graphics graphics, double d, double d2, int n) {
        this.drawTick(graphics, d, d2, 3, 3, n);
    }

    public void drawLabel(Graphics graphics, String string, double d, double d2, int n) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n2 = fontMetrics.getHeight();
        int n3 = fontMetrics.stringWidth(string);
        switch (n) {
            case 0: {
                graphics.drawString(string, this.xGraph(d) - n3 - 3, this.yGraph(d2) + n2 / 2);
                break;
            }
            case 1: {
                graphics.drawString(string, this.xGraph(d) + 3, this.yGraph(d2) + n2 / 2);
                break;
            }
            case 2: {
                graphics.drawString(string, this.xGraph(d) - n3 / 2, this.yGraph(d2) + 1);
                break;
            }
            case 3: {
                graphics.drawString(string, this.xGraph(d) - n3 / 2, this.yGraph(d2) + n2);
            }
        }
    }

    public void drawAxis(Graphics graphics, Domain domain, double d, int n, int n2) {
        if (n == 1) {
            double d2;
            this.drawLine(graphics, domain.getLowerBound(), d, domain.getUpperBound(), d);
            for (int i = 0; i < domain.getSize(); ++i) {
                d2 = n2 == 0 ? domain.getValue(i) : domain.getBound(i);
                this.drawTick(graphics, d2, d, 0);
            }
            if (n2 == 1) {
                this.drawTick(graphics, domain.getUpperBound(), d, 0);
            }
            d2 = n2 == 0 ? domain.getLowerValue() : domain.getLowerBound();
            this.drawLabel(graphics, this.format(d2), d2, d, 3);
            d2 = n2 == 0 ? domain.getUpperValue() : domain.getUpperBound();
            this.drawLabel(graphics, this.format(d2), d2, d, 3);
        } else {
            double d3;
            this.drawLine(graphics, d, domain.getLowerBound(), d, domain.getUpperBound());
            for (int i = 0; i < domain.getSize(); ++i) {
                d3 = n2 == 0 ? domain.getValue(i) : domain.getBound(i);
                this.drawTick(graphics, d, d3, 1);
            }
            if (n2 == 1) {
                this.drawTick(graphics, d, domain.getUpperBound(), 1);
            }
            d3 = n2 == 0 ? domain.getLowerValue() : domain.getLowerBound();
            this.drawLabel(graphics, this.format(d3), d, d3, 0);
            d3 = n2 == 0 ? domain.getUpperValue() : domain.getUpperBound();
            this.drawLabel(graphics, this.format(d3), d, d3, 0);
        }
    }

    public void drawAxis(Graphics graphics, double d, double d2, double d3, double d4, int n, int n2) {
        this.drawAxis(graphics, new Domain(d, d2, d3), d4, n, n2);
    }

    public void drawAxis(Graphics graphics, double d, double d2, double d3, double d4, int n) {
        this.drawAxis(graphics, d, d2, d3, d4, n, 1);
    }

    public void drawBox(Graphics graphics, double d, double d2, double d3, double d4) {
        graphics.drawRect(this.xGraph(d), this.yGraph(d4), this.xGraph(d3) - this.xGraph(d), this.yGraph(d2) - this.yGraph(d4));
    }

    public void fillBox(Graphics graphics, double d, double d2, double d3, double d4) {
        graphics.fillRect(this.xGraph(d), this.yGraph(d4), this.xGraph(d3) - this.xGraph(d), this.yGraph(d2) - this.yGraph(d4));
    }

    public void drawBoxPlot(Graphics graphics, double d, double d2, int n) {
        graphics.drawRect(this.xGraph(d - d2), n - 3, this.xGraph(d + d2) - this.xGraph(d - d2), 6);
        graphics.drawLine(this.xGraph(d), n - 6, this.xGraph(d), n + 6);
    }

    public void fillBoxPlot(Graphics graphics, double d, double d2, int n) {
        graphics.fillRect(this.xGraph(d - d2), n - 3, this.xGraph(d + d2) - this.xGraph(d - d2), 6);
        graphics.drawLine(this.xGraph(d), n - 6, this.xGraph(d), n + 6);
    }

    public void drawBoxPlot(Graphics graphics, double d, double d2, double d3, double d4, double d5, int n) {
        graphics.drawLine(this.xGraph(d), n, this.xGraph(d5), n);
        graphics.drawLine(this.xGraph(d), n - 3, this.xGraph(d), n + 3);
        graphics.drawLine(this.xGraph(d5), n - 3, this.xGraph(d5), n + 3);
        graphics.drawRect(this.xGraph(d2), n - 3, this.xGraph(d4) - this.xGraph(d2), 6);
        graphics.drawLine(this.xGraph(d3), n - 6, this.xGraph(d3), n + 6);
    }

    public void fillBoxPlot(Graphics graphics, double d, double d2, double d3, double d4, double d5, int n) {
        graphics.drawLine(this.xGraph(d), n, this.xGraph(d5), n);
        graphics.drawLine(this.xGraph(d), n - 6, this.xGraph(d), n + 6);
        graphics.drawLine(this.xGraph(d5), n - 6, this.xGraph(d5), n + 6);
        graphics.fillRect(this.xGraph(d2), n - 3, this.xGraph(d4) - this.xGraph(d2), 6);
        graphics.drawLine(this.xGraph(d3), n - 8, this.xGraph(d3), n + 8);
    }

    public void drawBox(Graphics graphics, int n, double d, double d2, double d3, int n2, int n3) {
        if (n == 0) {
            graphics.drawRect(this.xGraph(d) - n2, this.yGraph(d2 + d3), n2 + n3, this.yGraph(d2) - this.yGraph(d2 + d3));
        } else if (n == 1) {
            graphics.drawRect(this.xGraph(d), this.yGraph(d2) - n2, this.xGraph(d + d3) - this.xGraph(d), n2 + n3);
        }
    }

    public void fillBox(Graphics graphics, int n, double d, double d2, double d3, int n2, int n3) {
        if (n == 0) {
            graphics.fillRect(this.xGraph(d) - n2, this.yGraph(d2 + d3), n2 + n3, this.yGraph(d2) - this.yGraph(d2 + d3));
        } else if (n == 1) {
            graphics.fillRect(this.xGraph(d), this.yGraph(d2) - n2, this.xGraph(d + d3) - this.xGraph(d), n2 + n3);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.xPosition = mouseEvent.getX();
        this.yPosition = mouseEvent.getY();
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        boolean bl = true;
        if (n >= this.leftMargin && n < this.getWidth() - this.rightMargin) {
            double d;
            double d2 = Math.abs(this.xScale(n) - this.left);
            if (d2 < (d = Math.abs(this.xScale(n) - this.right))) {
                this.left = this.xScale(n);
            } else if (d2 == d) {
                this.left = this.xScale(n);
                this.right = this.xScale(n);
            } else {
                this.right = this.xScale(n);
                bl = false;
            }
            if (this.left > this.right) {
                double d3 = this.left;
                this.left = this.right;
                this.right = d3;
            }
            this.xPosition = mouseEvent.getX();
            this.yPosition = mouseEvent.getY();
            if (this.type == 0) {
                this.rigidIntegralMotionOfDiscriteDistributions(bl);
                this.container.leftCutOff.setText(new Double((int)(this.getLeftCutOff() + 1.5)).toString());
                this.container.rightCutOff.setText(new Double(this.getRightCutOff()).toString());
            } else {
                this.container.leftCutOff.setText(new Double(this.getLeftCutOff()).toString());
                this.container.rightCutOff.setText(new Double(this.getRightCutOff()).toString());
            }
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        boolean bl = true;
        if (n >= this.leftMargin && n < this.getWidth() - this.rightMargin) {
            double d;
            double d2 = Math.abs(this.xScale(n) - this.left);
            if (d2 < (d = Math.abs(this.xScale(n) - this.right))) {
                this.left = this.xScale(n);
            } else if (d2 == d) {
                this.left = this.xScale(n);
                this.right = this.xScale(n);
            } else {
                this.right = this.xScale(n);
                bl = false;
            }
            if (this.left > this.right) {
                double d3 = this.left;
                this.left = this.right;
                this.right = d3;
            }
            if (this.type == 0) {
                this.rigidIntegralMotionOfDiscriteDistributions(bl);
                this.container.leftCutOff.setText(new Double((int)(this.getLeftCutOff() + 1.5)).toString());
                this.container.rightCutOff.setText(new Double(this.getRightCutOff()).toString());
            } else {
                this.container.leftCutOff.setText(new Double(this.getLeftCutOff()).toString());
                this.container.rightCutOff.setText(new Double(this.getRightCutOff()).toString());
            }
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void rigidIntegralMotionOfDiscriteDistributions(boolean bl) {
        if (this.type == 0) {
            if (bl) {
                this.left = (double)((int)(this.left + 0.5)) - 0.5;
            } else {
                this.right = (double)((int)(this.right + 0.5)) + 0.5;
            }
        }
    }

    public double getLeftCDF() {
        if (this.type == 0) {
            return this.dist.getCDF(this.left - 0.5);
        }
        return this.dist.getCDF(this.left);
    }

    public double getRightCDF() {
        if (this.type == 0) {
            return 1.0 - this.dist.getCDF(this.right - 0.5);
        }
        return 1.0 - this.dist.getCDF(this.right);
    }

    public double getBetweenCDF() {
        return 1.0 - this.getLeftCDF() - this.getRightCDF();
    }

    private String format(double d) {
        return this.decimalFormat.format(d);
    }
}

