/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.stat.SOCR.core;

import edu.ucla.stat.SOCR.core.IExperiment;
import edu.ucla.stat.SOCR.core.MultiplePartsPanel;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JSplitPane;

public class Experiment
extends MultiplePartsPanel
implements Runnable,
ActionListener,
ItemListener,
IExperiment {
    private int time = 0;
    private int updateCount = 0;
    private int stopCount = 0;
    private int updateFreq = 1;
    private int stopFreq = 10;
    private boolean stopNow = false;
    private JButton stepJButton = new JButton("Step");
    private JButton runJButton = new JButton("Run");
    private JButton stopJButton = new JButton("Stop");
    private JComboBox updateChoice = new JComboBox();
    private JComboBox stopChoice = new JComboBox();
    private Thread simulation = null;

    public static IExperiment getInstance(String string) throws Exception {
        Class<?> clazz = Class.forName(string);
        if (clazz == null) {
            return null;
        }
        return (IExperiment)clazz.newInstance();
    }

    public void initialize() {
    }

    public Experiment() {
        this.updateChoice.addItem("Result Report Freq: 1");
        this.updateChoice.addItem("Result Report Freq: 10");
        this.updateChoice.addItem("Result Report Freq: 100");
        this.updateChoice.addItem("Result Report Freq: 1000");
        this.updateChoice.setSelectedIndex(0);
        this.stopChoice.addItem("Run Continuously");
        this.stopChoice.addItem("Number of Experiments: 10");
        this.stopChoice.addItem("Number of Experiments: 100");
        this.stopChoice.addItem("Number of Experiments: 1000");
        this.stopChoice.addItem("Number of Experiments: 10000");
        this.stopChoice.setSelectedIndex(1);
        this.addTool(this.stepJButton);
        this.addTool(this.runJButton);
        this.addTool(this.stopJButton);
        this.addTool2(this.updateChoice);
        this.addTool2(this.stopChoice);
        this.getRecordTable().setText("Experimental Results");
        this.stepJButton.addActionListener(this);
        this.runJButton.addActionListener(this);
        this.stopJButton.addActionListener(this);
        this.stopChoice.addItemListener(this);
        this.updateChoice.addItemListener(this);
    }

    public int getTime() {
        return this.time;
    }

    public void stop() {
        this.simulation = null;
        this.stopCount = 0;
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (this.simulation == thread) {
            this.doExperiment();
            ++this.stopCount;
            ++this.updateCount;
            if (this.updateCount == this.updateFreq) {
                this.update();
            }
            if (this.stopCount == this.stopFreq || this.stopNow) {
                this.stop();
                if (this.updateCount != 0) {
                    this.update();
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                this.stop();
            }
        }
        this.update();
    }

    public String getName() {
        return new String("SOCR Experiments: http://www.socr.ucla.edu \n");
    }

    public String getAppletInfo() {
        return new String("SOCR Experiments: http://www.socr.ucla.edu \n");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.stepJButton) {
            this.stop();
            this.step();
        } else if (actionEvent.getSource() == this.runJButton) {
            if (this.simulation == null) {
                this.simulation = new Thread(this);
                this.simulation.start();
            }
        } else if (actionEvent.getSource() == this.stopJButton) {
            this.stop();
            if (this.updateCount != 0) {
                this.update();
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.updateChoice) {
            this.updateFreq = (int)Math.pow(10.0, this.updateChoice.getSelectedIndex());
        } else if (itemEvent.getSource() == this.stopChoice) {
            int n = this.stopChoice.getSelectedIndex();
            this.stopFreq = n > 0 ? (int)Math.pow(10.0, n) : -1;
        }
    }

    public void doExperiment() {
        ++this.time;
    }

    public void step() {
        this.doExperiment();
        this.update();
    }

    public void reset() {
        this.stop();
        this.time = 0;
        this.getRecordTable().setText("Experiment Number:\tObservation:");
        this.update();
    }

    public void update() {
        this.updateCount = 0;
        this.getRecordTable().append("\n" + this.getTime());
    }

    public void setStopNow(boolean bl) {
        this.stopNow = bl;
    }

    public int getStopFreq() {
        return this.stopFreq;
    }

    public void setStopFreq(int n) {
        this.stopFreq = n;
    }

    public JComboBox getUpdateChoice() {
        return this.updateChoice;
    }

    public JComboBox getStopChoice() {
        return this.stopChoice;
    }

    public String getOnlineDescription() {
        return new String("http://socr.stat.ucla.edu/");
    }

    public Container getDisplayPane() {
        JSplitPane jSplitPane = new JSplitPane(0, this.getMainPanel(), this.getTextPanel());
        return jSplitPane;
    }
}

