/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.stat.SOCR.core;

import edu.ucla.stat.SOCR.core.Pluginable;
import edu.ucla.stat.SOCR.core.SOCRValueSettable;
import edu.ucla.stat.SOCR.distributions.Domain;
import java.awt.Container;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JApplet;

public abstract class Distribution
extends SOCRValueSettable
implements Pluginable {
    public static final int DISCRETE = 0;
    public static final int CONTINUOUS = 1;
    public static final int MIXED = 2;
    protected JApplet applet;
    private Observable observable = new Observable(){

        public void notifyObservers() {
            this.setChanged();
            super.notifyObservers(Distribution.this);
        }
    };
    private int type;
    private Domain domain;
    protected String name = "";

    public static Distribution getInstance(String string) throws Exception {
        Class<?> clazz = Class.forName(string);
        if (clazz == null) {
            return null;
        }
        return (Distribution)clazz.newInstance();
    }

    public void setApplet(JApplet jApplet) {
        this.applet = jApplet;
    }

    public void addObserver(Observer observer) {
        this.observable.addObserver(observer);
    }

    public void initialize() {
    }

    public void update(Observable observable, Object object) {
        this.valueChanged(observable, object);
        this.observable.notifyObservers();
    }

    public void valueChanged() {
    }

    public void valueChanged(Observable observable, Object object) {
        this.valueChanged();
    }

    public String getName() {
        return this.name;
    }

    public abstract double getDensity(double var1);

    public void setParameters(double d, double d2, double d3, int n) {
        if (n < 0) {
            n = 0;
        } else if (n > 2) {
            n = 2;
        }
        this.type = n;
        this.domain = this.type == 0 ? new Domain(d - 0.5 * d3, d2 + 0.5 * d3, d3) : new Domain(d, d2, d3);
    }

    protected void setDomain(Domain domain) {
        this.domain = domain;
        this.type = this.domain.getType();
    }

    protected void setDomain(double d, double d2, double d3, int n) {
        this.setDomain(new Domain(d, d2, d3, n));
    }

    public Domain getDomain() {
        return this.domain;
    }

    public final int getType() {
        return this.type;
    }

    public void paramEstimate(double[] dArray) {
    }

    public double getMaxDensity() {
        double d = 0.0;
        for (int i = 0; i < this.domain.getSize(); ++i) {
            double d2 = this.getDensity(this.domain.getValue(i));
            if (!(d2 > d & d2 < Double.POSITIVE_INFINITY)) continue;
            d = d2;
        }
        return d;
    }

    public double getMean() {
        double d = 0.0;
        double d2 = this.type == 0 ? 1.0 : this.domain.getWidth();
        for (int i = 0; i < this.domain.getSize(); ++i) {
            double d3 = this.domain.getValue(i);
            d += d3 * this.getDensity(d3) * d2;
        }
        return d;
    }

    public double getVariance() {
        double d = 0.0;
        double d2 = this.getMean();
        double d3 = this.type == 0 ? 1.0 : this.domain.getWidth();
        for (int i = 0; i < this.domain.getSize(); ++i) {
            double d4 = this.domain.getValue(i);
            d += (d4 - d2) * (d4 - d2) * this.getDensity(d4) * d3;
        }
        return d;
    }

    public double getSD() {
        return Math.sqrt(this.getVariance());
    }

    public double getCDF(double d) {
        double d2 = 0.0;
        double d3 = this.type == 0 ? 1.0 : this.domain.getWidth();
        int n = this.domain.getIndex(d);
        if (n < 0) {
            return 0.0;
        }
        if (n >= this.domain.getSize()) {
            return 1.0;
        }
        for (int i = 0; i <= n; ++i) {
            d2 += this.getDensity(this.domain.getValue(i)) * d3;
        }
        if (this.type == 1) {
            double d4 = this.domain.getValue(n) - 0.5 * d3;
            d2 += this.getDensity((d + d4) / 2.0) * (d - d4);
        }
        return d2;
    }

    public double getQuantile(double d) {
        double d2 = 0.0;
        double d3 = this.type == 0 ? 1.0 : this.domain.getWidth();
        if (d <= 0.0) {
            return this.domain.getLowerValue();
        }
        if (d >= 1.0) {
            return this.domain.getUpperValue();
        }
        int n = this.domain.getSize();
        int n2 = 0;
        double d4 = this.domain.getValue(n2);
        d2 = this.getDensity(d4) * d3;
        while (d2 < d & n2 < n) {
            d4 = this.domain.getValue(++n2);
            d2 += this.getDensity(d4) * d3;
        }
        return d4;
    }

    public double simulate() {
        return this.getQuantile(Math.random());
    }

    public double sampleMean(double[] dArray) {
        double d = 0.0;
        double d2 = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            d2 += dArray[i];
        }
        d = d2 / (double)dArray.length;
        return d;
    }

    public double sampleVar(double[] dArray, double d) {
        double d2 = 1.0;
        double d3 = dArray[0] * dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            d3 += dArray[i] * dArray[i];
        }
        d2 = -d * d + d3 / (double)dArray.length;
        return d2;
    }

    public String getOnlineDescription() {
        return "http://mathworld.wolfram.com/topics/StatisticalDistributions.html";
    }

    public String getLocalHelp() {
        return "Introduction: These interactive distribution applets allow you to:\n\n\t1. Dynamically compute any area under any of the implemented distributions\n\t2. Calculate quantiles and percentiles.\n\nHow to use the Interactive Distribution Applets:\n\n\t1. Select a distribution from the drop-down list in the top-left corner\n\t2. Select the paramenters of the distributiion accordingly (make sure these make sense!)\n\t3. Control the left-limit of the area of interest: click the mouse on the graph canvas near the LEFT end of the support of the distribution and drag it to the right\n\t\t Alternatively you can use the text areas on the bottom-left to enter the left/right limits numerically\n\t4. Control the right-limit of the area of interest: click the mouse near the RIGHT end of the support of the distribution and drag it to the left\n\t5. Play with the left and right limits to select the desired area or to find the corresponding tail probabilities.\n\nNotes: \n\t1. You can change the parameters of the distribution at any time. We have optimized the applet to show a maximal field-of-view for each distribution\n\t for any set of parameters. As a consequence, changing the the set of parameters may effect only the scales of the vertical and horizontal axes.\n\t2. To report bugs or make recommendations please visit: http://www.socr.ucla.edu/";
    }

    public double getMedian() {
        return this.getQuantile(0.5);
    }

    public double getFailureRate(double d) {
        return this.getDensity(d) / (1.0 - this.getCDF(d));
    }

    public static double perm(double d, int n) {
        if ((double)n > d | n < 0) {
            return 0.0;
        }
        double d2 = 1.0;
        for (int i = 1; i <= n; ++i) {
            d2 *= d - (double)i + 1.0;
        }
        return d2;
    }

    public static double factorial(int n) {
        return Distribution.perm(n, n);
    }

    public static double comb(double d, int n) {
        return Distribution.perm(d, n) / Distribution.factorial(n);
    }

    public static double logGamma(double d) {
        double[] dArray = new double[]{76.18009173, -86.50532033, 24.01409822, -1.231739516, 0.00120858003, -5.36382E-6};
        double d2 = 2.50662827465;
        double d3 = 5.5;
        double d4 = d - 1.0;
        double d5 = d4 + d3;
        d5 = (d4 + 0.5) * Math.log(d5) - d5;
        double d6 = 1.0;
        for (int i = 1; i <= 6; ++i) {
            d6 += dArray[i - 1] / (d4 += 1.0);
        }
        return d5 + Math.log(d2 * d6);
    }

    public static double gamma(double d) {
        return Math.exp(Distribution.logGamma(d));
    }

    public static double gammaCDF(double d, double d2) {
        if (d <= 0.0) {
            return 0.0;
        }
        if (d < d2 + 1.0) {
            return Distribution.gammaSeries(d, d2);
        }
        return 1.0 - Distribution.gammaCF(d, d2);
    }

    private static double gammaSeries(double d, double d2) {
        int n = 100;
        double d3 = 3.0E-7;
        double d4 = 1.0 / d2;
        double d5 = d2;
        double d6 = Distribution.logGamma(d2);
        double d7 = d4;
        for (int i = 1; i <= n; ++i) {
            d7 = d7 * d / (d5 += 1.0);
            if (Math.abs(d7) < Math.abs(d4 += d7) * d3) break;
        }
        return d4 * Math.exp(-d + d2 * Math.log(d) - d6);
    }

    private static double gammaCF(double d, double d2) {
        int n = 100;
        double d3 = 3.0E-7;
        double d4 = Distribution.logGamma(d2);
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 1.0;
        double d8 = d;
        double d9 = 0.0;
        double d10 = 1.0;
        double d11 = 1.0;
        for (int i = 1; i <= n; ++i) {
            double d12 = 1.0 * (double)i;
            double d13 = d12 - d2;
            d7 = (d8 + d7 * d13) * d11;
            d9 = (d10 + d9 * d13) * d11;
            double d14 = d12 * d11;
            d8 = d * d7 + d14 * d8;
            d10 = d * d9 + d14 * d10;
            if (d8 == 0.0) continue;
            d11 = 1.0 / d8;
            d5 = d10 * d11;
            if (Math.abs((d5 - d6) / d5) < d3) break;
            d6 = d5;
        }
        return Math.exp(-d + d2 * Math.log(d) - d4) * d5;
    }

    public static double betaCDF(double d, double d2, double d3) {
        double d4 = d == 0.0 | d == 1.0 ? 0.0 : Math.exp(Distribution.logGamma(d2 + d3) - Distribution.logGamma(d2) - Distribution.logGamma(d3) + d2 * Math.log(d) + d3 * Math.log(1.0 - d));
        if (d < (d2 + 1.0) / (d2 + d3 + 2.0)) {
            return d4 * Distribution.betaCF(d, d2, d3) / d2;
        }
        return 1.0 - d4 * Distribution.betaCF(1.0 - d, d3, d2) / d3;
    }

    private static double betaCF(double d, double d2, double d3) {
        int n = 100;
        double d4 = 3.0E-7;
        double d5 = 1.0;
        double d6 = 1.0;
        double d7 = 1.0;
        double d8 = d2 + d3;
        double d9 = d2 + 1.0;
        double d10 = d2 - 1.0;
        double d11 = 1.0 - d8 * d / d9;
        for (int i = 1; i <= n; ++i) {
            double d12 = i;
            double d13 = d12 + d12;
            double d14 = d12 * (d3 - (double)i) * d / ((d10 + d13) * (d2 + d13));
            double d15 = d7 + d14 * d5;
            double d16 = d11 + d14 * d6;
            d14 = -(d2 + d12) * (d8 + d12) * d / ((d2 + d13) * (d9 + d13));
            double d17 = d15 + d14 * d7;
            double d18 = d16 + d14 * d11;
            double d19 = d7;
            d5 = d15 / d18;
            d6 = d16 / d18;
            d7 = d17 / d18;
            d11 = 1.0;
            if (Math.abs(d7 - d19) < d4 * Math.abs(d7)) break;
        }
        return d7;
    }

    public double inverseCDF(double d) {
        if (0.0 < d && d < 1.0) {
            double d2 = this.getQuantile(0.5);
            return this.findRoot(d, d2, d2 - 6.0, d2 + 6.0);
        }
        if (d <= 0.0) {
            return 0.0;
        }
        return 1.0;
    }

    protected double findRoot(double d, double d2, double d3, double d4) {
        if (d < 0.0 || 1.0 < d) {
            return 0.0;
        }
        if (d3 > d2 || d2 > d4) {
            return 0.0;
        }
        double d5 = d2;
        double d6 = d2;
        double d7 = 1000.0;
        int n = 0;
        while (Math.abs(d7) > 1.0E-7 && n++ < 150) {
            double d8 = this.getCDF(d5) - d;
            if (d8 < 0.0) {
                d3 = d5;
            } else {
                d4 = d5;
            }
            double d9 = this.getDensity(d5);
            if (d9 != 0.0) {
                d7 = d8 / d9;
                d6 = d5 - d7;
            }
            if (d6 < d3 || d6 > d4 || d9 == 0.0) {
                d6 = (d3 + d4) / 2.0;
                d7 = d6 - d5;
            }
            d5 = d6;
        }
        return d5;
    }

    public Container getDisplayPane() {
        throw new IllegalStateException("overrite getDisplayPane()");
    }
}

