/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class mdFdrCalculator {
    private int m_NumComparisons;
    private int m_NumBootStraps;
    private int m_NumGenes;
    private int m_NumTimePoints;
    private List m_ComparisonsList;
    private List m_AllPValuesList;
    private List m_AdjPValuesList;
    private List m_BootstrapIndicesList = new ArrayList();
    private int m_RandomSeed;
    private UtilityFunctions.RandomSeed m_RandomSeedObj;
    private int[] m_SampleSize;
    private int[] m_DefaultSampleSize;
    private double[] m_VarianceArray;
    private double[] m_YBarArray;
    private double[] m_PairwiseRawData;
    private double m_Alpha;
    private double m_AlphaStar;
    private String[] m_GroupNameArray;
    private int m_SigProfileColumnIdx;
    private String m_LastError;
    private final String SIG_PROFILES_COL_HDR = "Sig. Profiles";

    public mdFdrCalculator() {
        this.m_AllPValuesList = new ArrayList();
        this.m_AdjPValuesList = new ArrayList();
        this.m_RandomSeedObj = UtilityFunctions.getInstance().createRandomSeed();
    }

    public String getLastError() {
        return this.m_LastError;
    }

    public void setComparisonsList(List list) {
        this.m_ComparisonsList = list;
        this.m_NumComparisons = list.size();
    }

    public void setNumGenes(int value) {
        this.m_NumGenes = value;
    }

    public void setNumBootStraps(int numBoot) {
        this.m_NumBootStraps = numBoot;
    }

    public void setNumTimePoints(int value) {
        this.m_NumTimePoints = value;
    }

    public void setSampleSize(int[] sampSize) {
        this.m_SampleSize = sampSize;
    }

    public void setDefaultSampleSize(int[] sampSize) {
        this.m_DefaultSampleSize = sampSize;
    }

    public void setVarianceArray(double[] values) {
        this.m_VarianceArray = values;
    }

    public void setYBarArray(double[] values) {
        this.m_YBarArray = values;
    }

    public void setRandomSeed(int seed) {
        this.m_RandomSeedObj.initialSeed = this.m_RandomSeed = seed;
    }

    public void setAlpha(double value) {
        this.m_Alpha = value;
    }

    public void setGroupNameArray(String[] groupNames) {
        this.m_GroupNameArray = groupNames;
    }

    public void reset() {
        if (this.m_ComparisonsList != null) {
            this.m_ComparisonsList.clear();
        }
        if (this.m_BootstrapIndicesList != null) {
            this.m_BootstrapIndicesList.clear();
        }
        if (this.m_AllPValuesList != null) {
            this.m_AllPValuesList.clear();
        }
        if (this.m_AdjPValuesList != null) {
            this.m_AdjPValuesList.clear();
        }
    }

    public void createBootstrapIndices() {
        double randomResult = 0.0;
        double iu = 0.0;
        int iuInt = 0;
        for (MdFdrComparisonItem item : this.m_ComparisonsList) {
            int totalPairwiseSamples = this.m_DefaultSampleSize[item.timePt1] + this.m_DefaultSampleSize[item.timePt2];
            int[][] bootStrapIndices = new int[this.m_NumBootStraps + 1][totalPairwiseSamples + 1];
            for (int i = 1; i <= this.m_NumBootStraps; ++i) {
                for (int j = 1; j <= totalPairwiseSamples; ++j) {
                    randomResult = this.m_RandomSeed == -1 ? Math.random() : UtilityFunctions.randomNumber(this.m_RandomSeedObj);
                    iu = (double)totalPairwiseSamples * randomResult;
                    if (iu == 0.0) {
                        iuInt = totalPairwiseSamples;
                    } else {
                        iuInt = (int)iu;
                        if (iuInt == 0) {
                            iuInt = totalPairwiseSamples;
                        }
                    }
                    bootStrapIndices[i][j] = iuInt;
                }
            }
            this.m_BootstrapIndicesList.add(bootStrapIndices);
        }
    }

    public boolean calculatePValues(int geneIdx, double[] dataValues) {
        boolean returnValue = true;
        int compareIdx = 0;
        double[] yBarArray = new double[3];
        double[] stdErrArray = new double[3];
        double[] varianceArray = new double[3];
        int[] pairwiseSampleSizeArray = new int[3];
        double minPValue = Double.MAX_VALUE;
        ArrayList<Double> pValuesList = new ArrayList<Double>();
        for (MdFdrComparisonItem item : this.m_ComparisonsList) {
            int i;
            int timePt1 = item.timePt1;
            int timePt2 = item.timePt2;
            if (this.m_SampleSize[timePt1] <= 0 || this.m_SampleSize[timePt2] <= 0) {
                pValuesList.add((Double)Double.MAX_VALUE);
                continue;
            }
            double denom = Math.sqrt(this.m_VarianceArray[timePt1] / (double)this.m_SampleSize[timePt1] + this.m_VarianceArray[timePt2] / (double)this.m_SampleSize[timePt2]);
            double tStat = Math.abs(this.m_YBarArray[timePt1] - this.m_YBarArray[timePt2]) / denom;
            int totalPairwiseSamples = this.m_DefaultSampleSize[timePt1] + this.m_DefaultSampleSize[timePt2];
            int truePairwiseSamples = this.m_SampleSize[timePt1] + this.m_SampleSize[timePt2];
            this.m_PairwiseRawData = new double[totalPairwiseSamples + 1];
            double[] residuals = new double[totalPairwiseSamples + 1];
            double[] bootstrapData = new double[totalPairwiseSamples + 1];
            int maxPairwisePts = Math.max(this.m_DefaultSampleSize[timePt1], this.m_DefaultSampleSize[timePt2]);
            double[][] summaryRawDataArray = new double[3][maxPairwisePts + 1];
            for (i = 1; i <= truePairwiseSamples; ++i) {
                int origIdx = UtilityFunctions.getOriginalIndexFromPairwiseIndex(this.m_SampleSize, i, timePt1, timePt2);
                this.m_PairwiseRawData[i] = dataValues[origIdx];
            }
            int[][] bootstrapIndices = (int[][])this.m_BootstrapIndicesList.get(compareIdx);
            int numBootstrapFailures = 0;
            for (i = 1; i <= this.m_NumBootStraps; ++i) {
                int j;
                pairwiseSampleSizeArray[1] = 0;
                pairwiseSampleSizeArray[2] = 0;
                int timePtIdx = timePt1;
                int overallIdx = 0;
                double overallMean = 0.0;
                for (j = 1; j <= totalPairwiseSamples; ++j) {
                    if (j > this.m_SampleSize[timePt1]) {
                        timePtIdx = timePt2;
                    }
                    if (this.m_PairwiseRawData[j] < Double.MAX_VALUE) {
                        residuals[j] = this.m_PairwiseRawData[j] - this.m_YBarArray[timePtIdx];
                        overallMean += this.m_PairwiseRawData[j];
                        ++overallIdx;
                        continue;
                    }
                    residuals[j] = Double.MAX_VALUE;
                }
                if (overallIdx > 0) {
                    overallMean /= (double)overallIdx;
                }
                int pairIdx = 1;
                overallIdx = 0;
                for (j = 1; j <= totalPairwiseSamples; ++j) {
                    int bootstrapIdx;
                    if (j > this.m_DefaultSampleSize[timePt1]) {
                        pairIdx = 2;
                    }
                    if ((bootstrapIdx = bootstrapIndices[i][j]) > truePairwiseSamples) continue;
                    int n = pairIdx;
                    pairwiseSampleSizeArray[n] = pairwiseSampleSizeArray[n] + 1;
                    bootstrapData[++overallIdx] = overallMean + residuals[bootstrapIdx];
                }
                UtilityFunctions.summary(bootstrapData, yBarArray, stdErrArray, varianceArray, pairwiseSampleSizeArray, 2, summaryRawDataArray, 0.0);
                denom = Math.sqrt(varianceArray[1] / (double)pairwiseSampleSizeArray[1] + varianceArray[2] / (double)pairwiseSampleSizeArray[2]);
                double tBoot = Math.abs(yBarArray[1] - yBarArray[2]) / denom;
                if (!(tBoot >= tStat)) continue;
                ++numBootstrapFailures;
            }
            double pValue = (double)numBootstrapFailures / (double)this.m_NumBootStraps;
            if (pValue < minPValue) {
                minPValue = pValue;
            }
            pValuesList.add(pValue);
            ++compareIdx;
        }
        double adjPValue = (double)this.m_NumComparisons * minPValue;
        if (adjPValue > 1.0) {
            adjPValue = 1.0;
        }
        this.m_AllPValuesList.add(pValuesList);
        this.m_AdjPValuesList.add(new UtilityFunctions.BHSortElement(geneIdx, adjPValue, pValuesList));
        return returnValue;
    }

    public int selectSignificantGenes() {
        int returnValue = 0;
        List bhList = UtilityFunctions.applyBH(this.m_AdjPValuesList, this.m_Alpha);
        int numSelected = bhList.size();
        if (numSelected == 0) {
            return 0;
        }
        this.m_AlphaStar = (double)numSelected * this.m_Alpha / ((double)this.m_NumGenes * (double)this.m_NumComparisons);
        for (UtilityFunctions.BHSortElement bhEl : bhList) {
            List pValueList = bhEl.comparisonPValues;
            Iterator pValuesIt = pValueList.iterator();
            bhEl.isSelected = false;
            while (pValuesIt.hasNext()) {
                Double pValue = (Double)pValuesIt.next();
                if (!(pValue <= this.m_AlphaStar)) continue;
                bhEl.isSelected = true;
            }
            if (!bhEl.isSelected) continue;
            ++returnValue;
        }
        OrigIndexComparator comparator = new OrigIndexComparator();
        Collections.sort(this.m_AdjPValuesList, comparator);
        return returnValue;
    }

    public String getHeaderStr() {
        int i;
        String returnValue = "Index\tInput File Index\tGene ID\tUser Desc\t";
        for (MdFdrComparisonItem item : this.m_ComparisonsList) {
            String compareDesc = item.toString();
            returnValue = returnValue + compareDesc + " Significant\t";
            returnValue = returnValue + compareDesc + " pValue\t";
            returnValue = returnValue + compareDesc + " FoldChange\t";
        }
        returnValue = returnValue + "Sig. Profiles\t";
        for (i = 1; i <= this.m_NumTimePoints; ++i) {
            returnValue = returnValue + "Raw Mean " + i + "\t";
        }
        for (i = 1; i <= this.m_NumTimePoints; ++i) {
            returnValue = returnValue + "Std Err " + i + "\t";
        }
        return returnValue;
    }

    public int getSelectStatus(int geneIdx) {
        int returnValue = 0;
        UtilityFunctions.BHSortElement bhEl = this.getBHSortElement(geneIdx);
        if (bhEl != null && bhEl.isSelected) {
            returnValue = 1;
        }
        return returnValue;
    }

    public UtilityFunctions.BHSortElement getBHSortElement(int geneIdx) {
        UtilityFunctions.BHSortElement returnValue = null;
        for (UtilityFunctions.BHSortElement el : this.m_AdjPValuesList) {
            if (el.origIdx != geneIdx) continue;
            returnValue = el;
            break;
        }
        return returnValue;
    }

    public String getPValuesStr(int geneIdx, double[] rawMeans, int logTransformType) {
        String returnValue = "";
        DecimalFormat dec5Format = new DecimalFormat("0.00000");
        DecimalFormat dec3Format = new DecimalFormat("0.000");
        int compareIdx = 0;
        double foldChange = 0.0;
        String summarySigStr = "";
        UtilityFunctions.BHSortElement bhEl = this.getBHSortElement(geneIdx);
        if (bhEl == null) {
            for (compareIdx = 0; compareIdx < this.m_NumComparisons; ++compareIdx) {
                returnValue = returnValue + "false\t1.0\t0.0\t";
            }
        } else {
            for (Double pValue : bhEl.comparisonPValues) {
                MdFdrComparisonItem item = (MdFdrComparisonItem)this.m_ComparisonsList.get(compareIdx);
                switch (logTransformType) {
                    case 2: {
                        foldChange = Math.pow(2.0, rawMeans[item.timePt2]) / Math.pow(2.0, rawMeans[item.timePt1]);
                        break;
                    }
                    case 4: {
                        foldChange = Math.pow(10.0, rawMeans[item.timePt2]) / Math.pow(10.0, rawMeans[item.timePt1]);
                        break;
                    }
                    case 0: 
                    case 3: {
                        foldChange = Math.pow(Math.E, rawMeans[item.timePt2]) / Math.pow(Math.E, rawMeans[item.timePt1]);
                        break;
                    }
                    case 1: {
                        foldChange = rawMeans[item.timePt2] / rawMeans[item.timePt1];
                    }
                }
                if (foldChange < 1.0) {
                    foldChange = -1.0 / foldChange;
                }
                if (pValue <= this.m_AlphaStar) {
                    returnValue = returnValue + "true\t";
                    if (summarySigStr.length() > 0) {
                        summarySigStr = summarySigStr + ",";
                    }
                    summarySigStr = summarySigStr + item.toOutputString(this.m_GroupNameArray, foldChange);
                } else {
                    returnValue = returnValue + "false\t";
                }
                returnValue = returnValue + dec5Format.format(pValue) + "\t";
                returnValue = returnValue + dec3Format.format(foldChange) + "\t";
                ++compareIdx;
            }
        }
        if (summarySigStr.length() == 0) {
            summarySigStr = "(none)";
        }
        returnValue = returnValue + summarySigStr + "\t";
        return returnValue;
    }

    public boolean resortOutputFile(String filename) {
        boolean returnValue = true;
        File inFile = new File(filename);
        ArrayList<String> headingList = new ArrayList<String>();
        ArrayList<String> dataList = new ArrayList<String>();
        boolean firstDataFound = false;
        BufferedReader in = null;
        int i = 0;
        try {
            String tmpStr;
            in = new BufferedReader(new FileReader(inFile));
            block2: while ((tmpStr = in.readLine()) != null) {
                if (firstDataFound) {
                    dataList.add(tmpStr);
                    continue;
                }
                headingList.add(tmpStr);
                if (!tmpStr.contains("Sig. Profiles\t")) continue;
                firstDataFound = true;
                String[] tokens = tmpStr.split("\t");
                for (i = 0; i < tokens.length; ++i) {
                    if (!tokens[i].equals("Sig. Profiles")) continue;
                    this.m_SigProfileColumnIdx = i;
                    continue block2;
                }
            }
            in.close();
            Collections.sort(dataList, new MdfdrComparator());
            ListIterator it = null;
            PrintWriter out = new PrintWriter(new FileOutputStream(filename));
            it = headingList.listIterator();
            while (it.hasNext()) {
                tmpStr = (String)it.next();
                out.println(tmpStr);
            }
            it = dataList.listIterator();
            while (it.hasNext()) {
                tmpStr = (String)it.next();
                out.println(tmpStr);
            }
            out.close();
        }
        catch (IOException e) {
            this.m_LastError = "Error re-sorting results file: " + e.getMessage();
            returnValue = false;
        }
        return returnValue;
    }

    public class MdfdrComparator
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            int returnValue = 0;
            String[] tokens1 = o1.split("\t");
            String[] tokens2 = o2.split("\t");
            if (tokens1.length > mdFdrCalculator.this.m_SigProfileColumnIdx && tokens2.length > mdFdrCalculator.this.m_SigProfileColumnIdx) {
                returnValue = tokens1[mdFdrCalculator.this.m_SigProfileColumnIdx].compareTo(tokens2[mdFdrCalculator.this.m_SigProfileColumnIdx]);
            }
            return returnValue;
        }
    }
}

